/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.metadata;

import com.viaversion.viaversion.api.minecraft.entities.Entity1_10Types;
import com.viaversion.viaversion.api.minecraft.item.Item;
import com.viaversion.viaversion.api.minecraft.metadata.Metadata;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import net.raphimc.vialegacy.ViaLegacy;
import net.raphimc.vialegacy.api.remapper.LegacyItemRewriter;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.Protocol1_8to1_7_6_10;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.metadata.MetaIndex1_8to1_7_6;

public class MetadataRewriter {
    private final Protocol1_8to1_7_6_10 protocol;

    public MetadataRewriter(Protocol1_8to1_7_6_10 protocol) {
        this.protocol = protocol;
    }

    public void transform(Entity1_10Types.EntityType type, List<Metadata> list) {
        for (Metadata entry : new ArrayList<Metadata>(list)) {
            MetaIndex1_8to1_7_6 metaIndex = MetaIndex1_8to1_7_6.searchIndex(type, entry.id());
            try {
                if (metaIndex == null) {
                    ViaLegacy.getPlatform().getLogger().warning("Could not find valid metaindex entry for " + type.name() + ": " + entry);
                    list.remove(entry);
                    continue;
                }
                Object value = entry.getValue();
                entry.setTypeAndValue(metaIndex.getOldType(), value);
                entry.setMetaTypeUnsafe(metaIndex.getNewType());
                entry.setId(metaIndex.getNewIndex());
                if (metaIndex == MetaIndex1_8to1_7_6.ENTITY_AGEABLE_AGE) {
                    entry.setValue((Integer)value < 0 ? (byte)-1 : 0);
                    continue;
                }
                if (metaIndex == MetaIndex1_8to1_7_6.ITEM_FRAME_ROTATION) {
                    entry.setValue(Integer.valueOf((Byte)value * 2).byteValue());
                    continue;
                }
                if (metaIndex == MetaIndex1_8to1_7_6.ENDERMAN_CARRIED_BLOCK) {
                    byte id = (Byte)value;
                    Metadata blockDataMeta = null;
                    for (Metadata metadata : list) {
                        if (metadata.id() != MetaIndex1_8to1_7_6.ENDERMAN_CARRIED_BLOCK_DATA.getOldIndex()) continue;
                        blockDataMeta = metadata;
                        list.remove(blockDataMeta);
                        break;
                    }
                    byte data = blockDataMeta != null ? (Byte)blockDataMeta.getValue() : (byte)0;
                    entry.setValue((short)(id | data << 12));
                    continue;
                }
                if (metaIndex == MetaIndex1_8to1_7_6.HUMAN_SKIN_FLAGS) {
                    byte flags = (Byte)value;
                    boolean cape = (flags & 2) == 0;
                    flags = (byte)(cape ? 127 : 126);
                    entry.setValue(flags);
                    continue;
                }
                switch (metaIndex.getNewType()) {
                    case Byte: {
                        entry.setValue(((Number)value).byteValue());
                        break;
                    }
                    case Short: {
                        entry.setValue(((Number)value).shortValue());
                        break;
                    }
                    case Int: {
                        entry.setValue(((Number)value).intValue());
                        break;
                    }
                    case Float: {
                        entry.setValue(Float.valueOf(((Number)value).floatValue()));
                        break;
                    }
                    case Slot: {
                        ((LegacyItemRewriter)this.protocol.getItemRewriter()).handleItemToClient((Item)value);
                        break;
                    }
                    case String: 
                    case Position: 
                    case Rotation: {
                        break;
                    }
                    default: {
                        ViaLegacy.getPlatform().getLogger().warning("1.7.10 MetaDataType: Unhandled Type: " + metaIndex.getNewType() + " " + entry);
                        list.remove(entry);
                        break;
                    }
                }
            }
            catch (Throwable e) {
                ViaLegacy.getPlatform().getLogger().log(Level.WARNING, "Error rewriting metadata entry for " + type.name() + ": " + entry, e);
                list.remove(entry);
            }
        }
    }
}

