/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.model;

import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.minecraft.entities.Entity1_10Types;
import com.viaversion.viaversion.api.minecraft.metadata.Metadata;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.version.Types1_8;
import com.viaversion.viaversion.protocols.protocol1_8.ClientboundPackets1_8;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.raphimc.vialegacy.api.model.Location;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.Protocol1_8to1_7_6_10;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.metadata.MetaIndex1_8to1_7_6;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.storage.EntityTracker;

public class HologramPartEntity {
    private static final float HORSE_HEIGHT = 1.6f;
    private static final float WITHER_SKULL_HEIGHT = 0.3125f;
    private final UserConnection user;
    private final EntityTracker entityTracker;
    private final int entityId;
    private final Entity1_10Types.EntityType entityType;
    private HologramPartEntity riderEntity;
    private HologramPartEntity vehicleEntity;
    private Location location;
    private final Map<MetaIndex1_8to1_7_6, Object> metadata = new HashMap<MetaIndex1_8to1_7_6, Object>();
    private Integer mappedEntityId;

    public HologramPartEntity(UserConnection user, int entityId, Entity1_10Types.EntityType entityType) {
        this.user = user;
        this.entityTracker = this.user.get(EntityTracker.class);
        this.entityId = entityId;
        this.entityType = entityType;
        this.location = new Location(Double.NaN, Double.NaN, Double.NaN);
        if (entityType == Entity1_10Types.EntityType.HORSE) {
            this.metadata.put(MetaIndex1_8to1_7_6.ENTITY_FLAGS, (byte)0);
            this.metadata.put(MetaIndex1_8to1_7_6.ENTITY_LIVING_NAME_TAG_VISIBILITY, (byte)0);
            this.metadata.put(MetaIndex1_8to1_7_6.ENTITY_LIVING_NAME_TAG, "");
            this.metadata.put(MetaIndex1_8to1_7_6.ENTITY_AGEABLE_AGE, 0);
        }
    }

    public void onChange() throws Exception {
        if (this.vehicleEntity == null && this.riderEntity != null) {
            this.riderEntity.setPositionFromVehicle();
        }
        if (this.isHologram()) {
            if (this.wouldBeInvisible()) {
                this.destroyHologramPartEntities();
                this.destroyArmorStand();
                return;
            }
            if (this.mappedEntityId == null) {
                this.mappedEntityId = this.entityTracker.getNextMappedEntityId();
                this.entityTracker.getVirtualHolograms().put((int)this.mappedEntityId, this);
                this.destroyHologramPartEntities();
                this.spawnArmorStand();
            }
            this.updateArmorStand();
        } else if (this.mappedEntityId != null) {
            this.onRemove();
        }
    }

    public void onRemove() throws Exception {
        if (this.mappedEntityId != null) {
            this.entityTracker.getVirtualHolograms().remove(this.mappedEntityId);
            this.destroyArmorStand();
            this.spawnHologramPartEntities();
            this.mappedEntityId = null;
        }
    }

    public void relocate(int newMappedEntityId) throws Exception {
        this.destroyArmorStand();
        this.mappedEntityId = newMappedEntityId;
        this.spawnArmorStand();
        this.updateArmorStand();
    }

    private void spawnHologramPartEntities() throws Exception {
        PacketWrapper spawnMob = PacketWrapper.create(ClientboundPackets1_8.SPAWN_MOB, this.user);
        spawnMob.write(Type.VAR_INT, this.entityId);
        spawnMob.write(Type.UNSIGNED_BYTE, (short)this.entityType.getId());
        spawnMob.write(Type.INT, (int)(this.location.getX() * 32.0));
        spawnMob.write(Type.INT, (int)(this.location.getY() * 32.0));
        spawnMob.write(Type.INT, (int)(this.location.getZ() * 32.0));
        spawnMob.write(Type.BYTE, (byte)0);
        spawnMob.write(Type.BYTE, (byte)0);
        spawnMob.write(Type.BYTE, (byte)0);
        spawnMob.write(Type.SHORT, (short)0);
        spawnMob.write(Type.SHORT, (short)0);
        spawnMob.write(Type.SHORT, (short)0);
        spawnMob.write(Types1_8.METADATA_LIST, this.get1_8Metadata());
        spawnMob.send(Protocol1_8to1_7_6_10.class);
        if (this.vehicleEntity != null) {
            int objectId = Arrays.stream(Entity1_10Types.ObjectType.values()).filter(o -> o.getType() == this.vehicleEntity.entityType).map(Entity1_10Types.ObjectType::getId).findFirst().orElse(-1);
            if (objectId == -1) {
                throw new IllegalStateException("Could not find object id for entity type " + this.vehicleEntity.entityType);
            }
            PacketWrapper spawnEntity = PacketWrapper.create(ClientboundPackets1_8.SPAWN_ENTITY, this.user);
            spawnEntity.write(Type.VAR_INT, this.vehicleEntity.entityId);
            spawnEntity.write(Type.BYTE, (byte)objectId);
            spawnEntity.write(Type.INT, (int)(this.vehicleEntity.location.getX() * 32.0));
            spawnEntity.write(Type.INT, (int)(this.vehicleEntity.location.getY() * 32.0));
            spawnEntity.write(Type.INT, (int)(this.vehicleEntity.location.getZ() * 32.0));
            spawnEntity.write(Type.BYTE, (byte)0);
            spawnEntity.write(Type.BYTE, (byte)0);
            spawnEntity.write(Type.INT, 0);
            spawnEntity.send(Protocol1_8to1_7_6_10.class);
            PacketWrapper entityMetadata = PacketWrapper.create(ClientboundPackets1_8.ENTITY_METADATA, this.user);
            entityMetadata.write(Type.VAR_INT, this.vehicleEntity.entityId);
            entityMetadata.write(Types1_8.METADATA_LIST, this.vehicleEntity.get1_8Metadata());
            entityMetadata.send(Protocol1_8to1_7_6_10.class);
            PacketWrapper attachEntity = PacketWrapper.create(ClientboundPackets1_8.ATTACH_ENTITY, this.user);
            attachEntity.write(Type.INT, this.entityId);
            attachEntity.write(Type.INT, this.vehicleEntity.entityId);
            attachEntity.write(Type.UNSIGNED_BYTE, (short)0);
            attachEntity.send(Protocol1_8to1_7_6_10.class);
        }
    }

    private void destroyHologramPartEntities() throws Exception {
        PacketWrapper destroyEntities = PacketWrapper.create(ClientboundPackets1_8.DESTROY_ENTITIES, this.user);
        destroyEntities.write(Type.VAR_INT_ARRAY_PRIMITIVE, new int[]{this.entityId, this.vehicleEntity.entityId});
        destroyEntities.scheduleSend(Protocol1_8to1_7_6_10.class);
    }

    private void spawnArmorStand() throws Exception {
        PacketWrapper spawnMob = PacketWrapper.create(ClientboundPackets1_8.SPAWN_MOB, this.user);
        spawnMob.write(Type.VAR_INT, this.mappedEntityId);
        spawnMob.write(Type.UNSIGNED_BYTE, (short)Entity1_10Types.EntityType.ARMOR_STAND.getId());
        spawnMob.write(Type.INT, (int)(this.location.getX() * 32.0));
        spawnMob.write(Type.INT, (int)((this.location.getY() + (double)this.getHeight()) * 32.0));
        spawnMob.write(Type.INT, (int)(this.location.getZ() * 32.0));
        spawnMob.write(Type.BYTE, (byte)0);
        spawnMob.write(Type.BYTE, (byte)0);
        spawnMob.write(Type.BYTE, (byte)0);
        spawnMob.write(Type.SHORT, (short)0);
        spawnMob.write(Type.SHORT, (short)0);
        spawnMob.write(Type.SHORT, (short)0);
        spawnMob.write(Types1_8.METADATA_LIST, this.getArmorStandMetadata());
        spawnMob.send(Protocol1_8to1_7_6_10.class);
    }

    private void destroyArmorStand() throws Exception {
        if (this.mappedEntityId == null) {
            return;
        }
        PacketWrapper destroyEntities = PacketWrapper.create(ClientboundPackets1_8.DESTROY_ENTITIES, this.user);
        destroyEntities.write(Type.VAR_INT_ARRAY_PRIMITIVE, new int[]{this.mappedEntityId});
        destroyEntities.send(Protocol1_8to1_7_6_10.class);
    }

    private void updateArmorStand() throws Exception {
        if (this.mappedEntityId == null) {
            return;
        }
        PacketWrapper entityMetadata = PacketWrapper.create(ClientboundPackets1_8.ENTITY_METADATA, this.user);
        entityMetadata.write(Type.VAR_INT, this.mappedEntityId);
        entityMetadata.write(Types1_8.METADATA_LIST, this.getArmorStandMetadata());
        entityMetadata.send(Protocol1_8to1_7_6_10.class);
        PacketWrapper entityTeleport = PacketWrapper.create(ClientboundPackets1_8.ENTITY_TELEPORT, this.user);
        entityTeleport.write(Type.VAR_INT, this.mappedEntityId);
        entityTeleport.write(Type.INT, (int)(this.location.getX() * 32.0));
        entityTeleport.write(Type.INT, (int)((this.location.getY() + (double)this.getHeight()) * 32.0));
        entityTeleport.write(Type.INT, (int)(this.location.getZ() * 32.0));
        entityTeleport.write(Type.BYTE, (byte)0);
        entityTeleport.write(Type.BYTE, (byte)0);
        entityTeleport.write(Type.BOOLEAN, false);
        entityTeleport.send(Protocol1_8to1_7_6_10.class);
    }

    private boolean isHologram() {
        if (this.entityType != Entity1_10Types.EntityType.HORSE) {
            return false;
        }
        if (this.vehicleEntity == null) {
            return false;
        }
        if (this.riderEntity != null) {
            return false;
        }
        if (this.vehicleEntity.riderEntity != this) {
            return false;
        }
        if (this.vehicleEntity.vehicleEntity != null) {
            return false;
        }
        return (Integer)this.getMetadata(MetaIndex1_8to1_7_6.ENTITY_AGEABLE_AGE) <= -44000;
    }

    private boolean wouldBeInvisible() {
        if (this.entityType != Entity1_10Types.EntityType.HORSE) {
            return false;
        }
        int age = (Integer)this.getMetadata(MetaIndex1_8to1_7_6.ENTITY_AGEABLE_AGE);
        return age >= -50000;
    }

    private float getHeight() {
        if (this.entityType == Entity1_10Types.EntityType.HORSE) {
            int age = (Integer)this.getMetadata(MetaIndex1_8to1_7_6.ENTITY_AGEABLE_AGE);
            float size = age >= 0 ? 1.0f : 0.5f + (-24000.0f - (float)age) / -24000.0f * 0.5f;
            return 1.6f * size;
        }
        return 0.3125f;
    }

    private void setPositionFromVehicle() {
        if (this.vehicleEntity != null) {
            this.location = new Location(this.vehicleEntity.location.getX(), this.vehicleEntity.location.getY() + (double)(this.vehicleEntity.getHeight() * 0.75f), this.vehicleEntity.location.getZ());
        }
        if (this.riderEntity != null) {
            this.riderEntity.setPositionFromVehicle();
        }
    }

    public int getEntityId() {
        return this.entityId;
    }

    public Entity1_10Types.EntityType getEntityType() {
        return this.entityType;
    }

    public void setVehicleEntity(HologramPartEntity vehicleEntity) throws Exception {
        if (vehicleEntity == null) {
            if (this.vehicleEntity != null) {
                this.location = this.vehicleEntity.location;
                this.location = new Location(this.location.getX(), this.location.getY() + (double)(this.vehicleEntity.entityType == Entity1_10Types.EntityType.HORSE ? 1.6f : 0.3125f), this.location.getZ());
                this.vehicleEntity.riderEntity = null;
                this.vehicleEntity.onChange();
            }
            this.vehicleEntity = null;
        } else {
            if (this.vehicleEntity != null) {
                this.vehicleEntity.riderEntity = null;
                this.vehicleEntity.onChange();
            }
            HologramPartEntity entity = vehicleEntity.vehicleEntity;
            while (entity != null) {
                if (entity == this) {
                    return;
                }
                entity = entity.riderEntity;
            }
            this.vehicleEntity = vehicleEntity;
            vehicleEntity.riderEntity = this;
            vehicleEntity.onChange();
        }
        this.onChange();
    }

    public HologramPartEntity getVehicleEntity() {
        return this.vehicleEntity;
    }

    public HologramPartEntity getRiderEntity() {
        return this.riderEntity;
    }

    public void setLocation(Location location) throws Exception {
        this.location = location;
        this.onChange();
    }

    public Location getLocation() {
        return this.location;
    }

    public void setMetadata(MetaIndex1_8to1_7_6 index, Object value) {
        this.metadata.put(index, value);
    }

    public Object getMetadata(MetaIndex1_8to1_7_6 index) {
        return this.metadata.get((Object)index);
    }

    private List<Metadata> get1_8Metadata() {
        ArrayList<Metadata> metadataList = new ArrayList<Metadata>();
        for (Map.Entry<MetaIndex1_8to1_7_6, Object> entry : this.metadata.entrySet()) {
            metadataList.add(new Metadata(entry.getKey().getOldIndex(), entry.getKey().getOldType(), entry.getValue()));
        }
        this.user.getProtocolInfo().getPipeline().getProtocol(Protocol1_8to1_7_6_10.class).getMetadataRewriter().transform(this.entityType, metadataList);
        return metadataList;
    }

    private List<Metadata> getArmorStandMetadata() {
        ArrayList<Metadata> metadataList = new ArrayList<Metadata>();
        if (this.entityType == Entity1_10Types.EntityType.HORSE) {
            metadataList.add(new Metadata(MetaIndex1_8to1_7_6.ENTITY_LIVING_NAME_TAG_VISIBILITY.getNewIndex(), MetaIndex1_8to1_7_6.ENTITY_LIVING_NAME_TAG_VISIBILITY.getNewType(), this.getMetadata(MetaIndex1_8to1_7_6.ENTITY_LIVING_NAME_TAG_VISIBILITY)));
            metadataList.add(new Metadata(MetaIndex1_8to1_7_6.ENTITY_LIVING_NAME_TAG.getNewIndex(), MetaIndex1_8to1_7_6.ENTITY_LIVING_NAME_TAG.getNewType(), this.getMetadata(MetaIndex1_8to1_7_6.ENTITY_LIVING_NAME_TAG)));
            metadataList.add(new Metadata(MetaIndex1_8to1_7_6.ENTITY_FLAGS.getNewIndex(), MetaIndex1_8to1_7_6.ENTITY_FLAGS.getNewType(), (byte)32));
            metadataList.add(new Metadata(MetaIndex1_8to1_7_6.ARMOR_STAND_FLAGS.getNewIndex(), MetaIndex1_8to1_7_6.ARMOR_STAND_FLAGS.getNewType(), (byte)16));
        }
        return metadataList;
    }
}

