/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.storage;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.connection.StoredObject;
import com.viaversion.viaversion.api.connection.UserConnection;
import com.viaversion.viaversion.api.protocol.packet.PacketWrapper;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.protocols.protocol1_8.ClientboundPackets1_8;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.Protocol1_8to1_7_6_10;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.model.GameProfile;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.model.TabListEntry;

public class TablistStorage
extends StoredObject {
    public final Map<String, TabListEntry> tablist = new HashMap<String, TabListEntry>();

    public TablistStorage(UserConnection user) {
        super(user);
    }

    public void sendTempEntry(TabListEntry entry) throws Exception {
        entry.ping = -1;
        this.sendAddEntry(entry);
        Via.getPlatform().runSync(() -> {
            try {
                this.sendRemoveEntry(entry);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }, entry.gameProfile.isOffline() ? 2L : 60L);
    }

    public void sendAddEntry(TabListEntry entry) throws Exception {
        List<GameProfile.Property> gameProfileProperties = entry.gameProfile.getAllProperties();
        PacketWrapper addPlayerListItemPacket = PacketWrapper.create(ClientboundPackets1_8.PLAYER_INFO, this.getUser());
        addPlayerListItemPacket.write(Type.VAR_INT, 0);
        addPlayerListItemPacket.write(Type.VAR_INT, 1);
        addPlayerListItemPacket.write(Type.UUID, entry.gameProfile.uuid);
        addPlayerListItemPacket.write(Type.STRING, entry.gameProfile.userName);
        addPlayerListItemPacket.write(Type.VAR_INT, gameProfileProperties.size());
        for (GameProfile.Property profileEntry : gameProfileProperties) {
            addPlayerListItemPacket.write(Type.STRING, profileEntry.key);
            addPlayerListItemPacket.write(Type.STRING, profileEntry.value);
            addPlayerListItemPacket.write(Type.OPTIONAL_STRING, profileEntry.signature);
        }
        addPlayerListItemPacket.write(Type.VAR_INT, entry.gameMode);
        addPlayerListItemPacket.write(Type.VAR_INT, entry.ping);
        addPlayerListItemPacket.write(Type.OPTIONAL_STRING, null);
        addPlayerListItemPacket.send(Protocol1_8to1_7_6_10.class);
    }

    public void sendRemoveEntry(TabListEntry entry) throws Exception {
        PacketWrapper removePlayerListItemPacket = PacketWrapper.create(ClientboundPackets1_8.PLAYER_INFO, this.getUser());
        removePlayerListItemPacket.write(Type.VAR_INT, 4);
        removePlayerListItemPacket.write(Type.VAR_INT, 1);
        removePlayerListItemPacket.write(Type.UUID, entry.gameProfile.uuid);
        removePlayerListItemPacket.send(Protocol1_8to1_7_6_10.class);
    }
}

