/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.types;

import com.viaversion.viaversion.api.minecraft.chunks.Chunk;
import com.viaversion.viaversion.api.type.PartialType;
import com.viaversion.viaversion.api.type.Type;
import com.viaversion.viaversion.api.type.types.CustomByteType;
import com.viaversion.viaversion.api.type.types.minecraft.BaseChunkBulkType;
import com.viaversion.viaversion.protocols.protocol1_9_3to1_9_1_2.storage.ClientWorld;
import com.viaversion.viaversion.util.Pair;
import io.netty.buffer.ByteBuf;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.raphimc.vialegacy.protocols.release.protocol1_8to1_7_6_10.types.Chunk1_7_6Type;

public class ChunkBulk1_7_6Type
extends PartialType<Chunk[], ClientWorld> {
    public ChunkBulk1_7_6Type(ClientWorld clientWorld) {
        super(clientWorld, Chunk[].class);
    }

    @Override
    public Class<? extends Type> getBaseClass() {
        return BaseChunkBulkType.class;
    }

    protected boolean readHasSkyLight(ByteBuf byteBuf, ClientWorld clientWorld) {
        return byteBuf.readBoolean();
    }

    protected void writeHasSkyLight(ByteBuf byteBuf, ClientWorld clientWorld, boolean hasSkyLight) {
        byteBuf.writeBoolean(hasSkyLight);
    }

    @Override
    public Chunk[] read(ByteBuf byteBuf, ClientWorld clientWorld) throws Exception {
        int chunkCount = byteBuf.readShort();
        int compressedSize = byteBuf.readInt();
        boolean hasSkyLight = this.readHasSkyLight(byteBuf, clientWorld);
        byte[] data = (byte[])new CustomByteType(compressedSize).read(byteBuf);
        int[] chunkX = new int[chunkCount];
        int[] chunkZ = new int[chunkCount];
        short[] primaryBitMask = new short[chunkCount];
        short[] additionalBitMask = new short[chunkCount];
        for (int i = 0; i < chunkCount; ++i) {
            chunkX[i] = byteBuf.readInt();
            chunkZ[i] = byteBuf.readInt();
            primaryBitMask[i] = byteBuf.readShort();
            additionalBitMask[i] = byteBuf.readShort();
        }
        byte[] uncompressedData = new byte[Chunk1_7_6Type.getSize((short)-1, (short)-1, true, hasSkyLight) * chunkCount];
        Inflater inflater = new Inflater();
        try {
            inflater.setInput(data, 0, compressedSize);
            inflater.inflate(uncompressedData);
        }
        catch (DataFormatException ex) {
            throw new IOException("Bad compressed data format");
        }
        finally {
            inflater.end();
        }
        Chunk[] chunks = new Chunk[chunkCount];
        int dataPosition = 0;
        for (int i = 0; i < chunkCount; ++i) {
            byte[] chunkData = new byte[Chunk1_7_6Type.getSize(primaryBitMask[i], additionalBitMask[i], true, hasSkyLight)];
            System.arraycopy(uncompressedData, dataPosition, chunkData, 0, chunkData.length);
            chunks[i] = Chunk1_7_6Type.deserialize(chunkX[i], chunkZ[i], true, hasSkyLight, primaryBitMask[i], additionalBitMask[i], chunkData);
            dataPosition += chunkData.length;
        }
        return chunks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(ByteBuf byteBuf, ClientWorld clientWorld, Chunk[] chunks) throws Exception {
        int compressedSize;
        byte[] compressedData;
        int chunkCount = chunks.length;
        ByteArrayOutputStream output = new ByteArrayOutputStream();
        int[] chunkX = new int[chunkCount];
        int[] chunkZ = new int[chunkCount];
        short[] primaryBitMask = new short[chunkCount];
        short[] additionalBitMask = new short[chunkCount];
        for (int i = 0; i < chunkCount; ++i) {
            Chunk chunk = chunks[i];
            Pair<byte[], Short> chunkData = Chunk1_7_6Type.serialize(chunk);
            output.write(chunkData.key());
            chunkX[i] = chunk.getX();
            chunkZ[i] = chunk.getZ();
            primaryBitMask[i] = (short)chunk.getBitmask();
            additionalBitMask[i] = chunkData.value();
        }
        byte[] data = output.toByteArray();
        Deflater deflater = new Deflater();
        try {
            deflater.setInput(data, 0, data.length);
            deflater.finish();
            compressedData = new byte[data.length];
            compressedSize = deflater.deflate(compressedData);
        }
        finally {
            deflater.end();
        }
        byteBuf.writeShort(chunkCount);
        byteBuf.writeInt(compressedSize);
        this.writeHasSkyLight(byteBuf, clientWorld, true);
        byteBuf.writeBytes(compressedData, 0, compressedSize);
        for (int i = 0; i < chunkCount; ++i) {
            byteBuf.writeInt(chunkX[i]);
            byteBuf.writeInt(chunkZ[i]);
            byteBuf.writeShort((int)primaryBitMask[i]);
            byteBuf.writeShort((int)additionalBitMask[i]);
        }
    }
}

