/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialoader.impl.platform;

import com.viaversion.viaversion.api.Via;
import com.viaversion.viaversion.api.ViaAPI;
import com.viaversion.viaversion.api.command.ViaCommandSender;
import com.viaversion.viaversion.api.configuration.ConfigurationProvider;
import com.viaversion.viaversion.api.configuration.ViaVersionConfig;
import com.viaversion.viaversion.api.platform.ViaPlatform;
import com.viaversion.viaversion.configuration.AbstractViaConfig;
import com.viaversion.viaversion.libs.gson.JsonObject;
import java.io.File;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.logging.Logger;
import net.raphimc.vialoader.commands.UserCommandSender;
import net.raphimc.vialoader.impl.viaversion.VLApiBase;
import net.raphimc.vialoader.impl.viaversion.VLViaConfig;
import net.raphimc.vialoader.util.JLoggerToSLF4J;
import net.raphimc.vialoader.util.VLTask;
import org.slf4j.LoggerFactory;

public class ViaVersionPlatformImpl
implements ViaPlatform<UUID> {
    private static final Logger LOGGER = new JLoggerToSLF4J(LoggerFactory.getLogger((String)"ViaVersion"));
    private final File dataFolder;
    private final AbstractViaConfig config;
    private final ViaAPI<UUID> api;

    public ViaVersionPlatformImpl(File rootFolder) {
        this.dataFolder = new File(rootFolder, "ViaLoader");
        this.config = this.createConfig();
        this.api = this.createApi();
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getPlatformName() {
        return "ViaLoader";
    }

    @Override
    public String getPlatformVersion() {
        return "2.2.5";
    }

    @Override
    public String getPluginVersion() {
        return "4.7.0";
    }

    @Override
    public VLTask runAsync(Runnable runnable) {
        return new VLTask(Via.getManager().getScheduler().execute(runnable));
    }

    @Override
    public VLTask runRepeatingAsync(Runnable runnable, long period) {
        return new VLTask(Via.getManager().getScheduler().scheduleRepeating(runnable, 0L, period * 50L, TimeUnit.MILLISECONDS));
    }

    @Override
    public VLTask runSync(Runnable runnable) {
        return this.runAsync(runnable);
    }

    @Override
    public VLTask runSync(Runnable runnable, long delay) {
        return new VLTask(Via.getManager().getScheduler().schedule(runnable, delay * 50L, TimeUnit.MILLISECONDS));
    }

    @Override
    public VLTask runRepeatingSync(Runnable runnable, long period) {
        return this.runRepeatingAsync(runnable, period);
    }

    @Override
    public ViaCommandSender[] getOnlinePlayers() {
        return (ViaCommandSender[])Via.getManager().getConnectionManager().getConnectedClients().values().stream().map(UserCommandSender::new).toArray(ViaCommandSender[]::new);
    }

    @Override
    public void sendMessage(UUID uuid, String msg) {
        if (uuid == null) {
            this.getLogger().info(msg);
        } else {
            this.getLogger().info("[" + uuid + "] " + msg);
        }
    }

    @Override
    public boolean kickPlayer(UUID uuid, String s) {
        return false;
    }

    @Override
    public boolean isPluginEnabled() {
        return true;
    }

    @Override
    public boolean isOldClientsAllowed() {
        return true;
    }

    @Override
    public boolean hasPlugin(String s) {
        return s.equalsIgnoreCase("ViaVersion") || s.equalsIgnoreCase("ViaBackwards") || s.equalsIgnoreCase("ViaRewind");
    }

    @Override
    public boolean isProxy() {
        return true;
    }

    @Override
    public ViaAPI<UUID> getApi() {
        return this.api;
    }

    @Override
    public ViaVersionConfig getConf() {
        return this.config;
    }

    @Override
    public ConfigurationProvider getConfigurationProvider() {
        return this.config;
    }

    @Override
    public File getDataFolder() {
        return this.dataFolder;
    }

    @Override
    public void onReload() {
    }

    @Override
    public JsonObject getDump() {
        return new JsonObject();
    }

    protected AbstractViaConfig createConfig() {
        VLViaConfig config = new VLViaConfig(new File(this.dataFolder, "viaversion.yml"));
        config.reloadConfig();
        return config;
    }

    protected ViaAPI<UUID> createApi() {
        return new VLApiBase();
    }
}

