/*
 * Decompiled with CFR 0.152.
 */
package net.raphimc.vialoader.util;

import net.raphimc.vialoader.util.VersionEnum;

public class VersionRange {
    private final VersionEnum lowerBound;
    private final VersionEnum upperBound;

    public VersionRange(VersionEnum lowerBound, VersionEnum upperBound) {
        if (lowerBound == null && upperBound == null) {
            throw new RuntimeException("Invalid protocol range");
        }
        this.lowerBound = lowerBound;
        this.upperBound = upperBound;
    }

    public static VersionRange andNewer(VersionEnum version) {
        return new VersionRange(null, version);
    }

    public static VersionRange singleton(VersionEnum version) {
        return new VersionRange(version, version);
    }

    public static VersionRange andOlder(VersionEnum version) {
        return new VersionRange(version, null);
    }

    public boolean contains(VersionEnum protocolVersion) {
        if (this.lowerBound != null && this.lowerBound.isOlderThan(protocolVersion)) {
            return false;
        }
        return this.upperBound == null || this.upperBound.isOlderThanOrEqualTo(protocolVersion);
    }

    public String toString() {
        if (this.lowerBound == null) {
            return this.upperBound.getName() + "+";
        }
        if (this.upperBound == null) {
            return this.lowerBound.getName() + "-";
        }
        if (this.lowerBound == this.upperBound) {
            return this.lowerBound.getName();
        }
        return this.lowerBound.getName() + " - " + this.upperBound.getName();
    }
}

