/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.minecraft.class_2561;
import net.minecraft.class_5244;
import traben.entity_model_features.EMFVersionDifferenceManager;
import traben.entity_model_features.utils.EMFUtils;

public class EMFConfig {
    private static EMFConfig EMFConfigData;
    public boolean printModelCreationInfoToLog = false;
    public boolean printAllMaths = false;
    public boolean renderCustomModelsGreen = false;
    public VanillaModelRenderMode vanillaModelRenderMode = VanillaModelRenderMode.Off;
    public final MathFunctionChoice mathFunctionChoice = MathFunctionChoice.JavaMath;
    public boolean tryForceEmfModels = true;
    public boolean printModdedMappingHelp = false;
    public boolean attemptToCopyVanillaModelIntoMissingModelPart = false;

    public static EMFConfig getConfig() {
        if (EMFConfigData == null) {
            EMFConfig.loadConfig();
        }
        return EMFConfigData;
    }

    public static void setConfig(EMFConfig newConfig) {
        if (newConfig != null) {
            EMFConfigData = newConfig;
        }
    }

    public static void EMF_saveConfig() {
        File config = new File(EMFVersionDifferenceManager.getConfigDirectory().toFile(), "entity_model_features.json");
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        if (!config.getParentFile().exists()) {
            config.getParentFile().mkdir();
        }
        try {
            FileWriter fileWriter = new FileWriter(config);
            fileWriter.write(gson.toJson((Object)EMFConfigData));
            fileWriter.close();
        }
        catch (IOException e) {
            EMFUtils.EMFModMessage("Config could not be saved", false);
        }
    }

    public static void loadConfig() {
        try {
            File config = new File(EMFVersionDifferenceManager.getConfigDirectory().toFile(), "entity_model_features.json");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            if (config.exists()) {
                try {
                    FileReader fileReader = new FileReader(config);
                    EMFConfigData = (EMFConfig)gson.fromJson((Reader)fileReader, EMFConfig.class);
                    fileReader.close();
                    EMFConfig.EMF_saveConfig();
                }
                catch (IOException e) {
                    EMFUtils.EMFModMessage("Config could not be loaded, using defaults", false);
                }
            } else {
                EMFConfigData = new EMFConfig();
                EMFConfig.EMF_saveConfig();
            }
            if (EMFConfigData == null) {
                EMFConfigData = new EMFConfig();
                EMFConfig.EMF_saveConfig();
            }
        }
        catch (Exception e) {
            EMFConfigData = new EMFConfig();
        }
    }

    public static EMFConfig copyFrom(EMFConfig source) {
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        return (EMFConfig)gson.fromJson(gson.toJson((Object)source), EMFConfig.class);
    }

    public static enum VanillaModelRenderMode {
        Off(class_5244.field_24333),
        Position_normal((class_2561)class_2561.method_43471((String)"entity_model_features.config.vanilla_render.normal")),
        Positon_offset((class_2561)class_2561.method_43471((String)"entity_model_features.config.vanilla_render.offset"));

        private final class_2561 text;

        private VanillaModelRenderMode(class_2561 text) {
            this.text = text;
        }

        public class_2561 asText() {
            return this.text;
        }

        public VanillaModelRenderMode next() {
            return switch (this) {
                case Off -> Position_normal;
                case Position_normal -> Positon_offset;
                default -> Off;
            };
        }
    }

    public static enum MathFunctionChoice {
        JavaMath,
        MinecraftMath;

    }
}

