/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models;

import it.unimi.dsi.fastutil.ints.Int2ObjectArrayMap;
import it.unimi.dsi.fastutil.objects.Object2ReferenceOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1921;
import net.minecraft.class_2350;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5603;
import net.minecraft.class_630;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.mixin.accessor.CuboidAccessor;
import traben.entity_model_features.mixin.accessor.ModelPartAccessor;
import traben.entity_model_features.models.jem_objects.EMFBoxData;
import traben.entity_model_features.models.jem_objects.EMFJemData;
import traben.entity_model_features.models.jem_objects.EMFPartData;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_texture_features.ETFApi;

@Environment(value=EnvType.CLIENT)
public class EMFModelPartMutable
extends class_630 {
    private static final class_630.class_628 EMPTY_CUBOID = new class_630.class_628(0, 0, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, false, 0.0f, 0.0f, (Set)new HashSet<class_2350>(){
        {
            this.addAll(List.of(class_2350.values()));
        }
    });
    public final List<EMFCuboid> emfCuboids = new ArrayList<EMFCuboid>();
    public final Map<String, EMFModelPartMutable> emfChildren = new HashMap<String, EMFModelPartMutable>();
    public final EMFPartData selfModelData;
    public int currentModelVariantState = 0;
    public boolean isValidToRenderInThisState = true;
    public final Int2ObjectArrayMap<EMFModelState> allKnownStateVariants = new Int2ObjectArrayMap();
    public class_2960 textureOverride;
    private boolean isTopLevelModelRoot = false;
    public static class_4597 currentlyHeldProvider = null;
    public static class_1297 currentlyHeldEntity = null;

    public EMFModelPartMutable(List<class_630.class_628> cuboids, Map<String, class_630> children, int variantNumber, EMFJemData jemData) {
        super(cuboids, children);
        this.selfModelData = null;
        this.textureOverride = jemData.customTexture;
        this.allKnownStateVariants.put(variantNumber, (Object)this.getCurrentState());
    }

    public EMFModelPartMutable(EMFPartData emfPartData, int variantNumber) {
        super(EMFModelPartMutable.getCuboidsFromData(emfPartData), EMFModelPartMutable.getChildrenFromData(emfPartData, variantNumber));
        this.selfModelData = emfPartData;
        this.textureOverride = emfPartData.customTexture;
        this.field_37938 = this.selfModelData.scale;
        this.field_37939 = this.selfModelData.scale;
        this.field_37940 = this.selfModelData.scale;
        this.field_3657 = this.selfModelData.translate[0];
        this.field_3656 = this.selfModelData.translate[1];
        this.field_3655 = this.selfModelData.translate[2];
        this.field_3654 = this.selfModelData.rotate[0];
        this.field_3675 = this.selfModelData.rotate[1];
        this.field_3674 = this.selfModelData.rotate[2];
        this.method_41918(this.method_32084());
        this.allKnownStateVariants.put(variantNumber, (Object)this.getCurrentState());
    }

    private static List<class_630.class_628> getCuboidsFromData(EMFPartData emfPartData) {
        return EMFModelPartMutable.createCuboidsFromBoxDataV3(emfPartData);
    }

    private static Map<String, class_630> getChildrenFromData(EMFPartData emfPartData, int variantNumber) {
        HashMap<String, class_630> emfChildren = new HashMap<String, class_630>();
        for (EMFPartData sub : emfPartData.submodels) {
            Object idForMap;
            Object object = idForMap = sub.part == null ? sub.id : sub.part;
            while (emfChildren.containsKey(idForMap)) {
                idForMap = (String)idForMap + "-";
            }
            if (EMFConfig.getConfig().printModelCreationInfoToLog) {
                System.out.println(" > > > > EMF sub part made: " + sub.toString(false));
            }
            emfChildren.put((String)idForMap, new EMFModelPartMutable(sub, variantNumber));
        }
        return emfChildren;
    }

    private static List<class_630.class_628> createCuboidsFromBoxDataV3(EMFPartData emfPartData) {
        LinkedList<class_630.class_628> emfCuboids = new LinkedList<class_630.class_628>();
        if (emfPartData.boxes.length > 0) {
            try {
                for (EMFBoxData box : emfPartData.boxes) {
                    EMFCuboid cube = box.textureOffset.length == 2 ? new EMFCuboid(emfPartData, box.textureOffset[0], box.textureOffset[1], box.coordinates[0], box.coordinates[1], box.coordinates[2], box.coordinates[3], box.coordinates[4], box.coordinates[5], box.sizeAdd, box.sizeAdd, box.sizeAdd, emfPartData.textureSize[0], emfPartData.textureSize[1], emfPartData.mirrorTexture.contains("u"), emfPartData.mirrorTexture.contains("v")) : new EMFCuboid(emfPartData, box.uvDown, box.uvUp, box.uvNorth, box.uvSouth, box.uvWest, box.uvEast, box.coordinates[0], box.coordinates[1], box.coordinates[2], box.coordinates[3], box.coordinates[4], box.coordinates[5], box.sizeAdd, box.sizeAdd, box.sizeAdd, emfPartData.textureSize[0], emfPartData.textureSize[1], emfPartData.mirrorTexture.contains("u"), emfPartData.mirrorTexture.contains("v"));
                    emfCuboids.add(cube);
                }
            }
            catch (Exception e) {
                EMFUtils.EMFModMessage("cuboid construction broke: " + e, false);
            }
        }
        return emfCuboids;
    }

    public void method_22699(class_4587 matrices, class_4588 vertices, int light, int overlay, float red, float green, float blue, float alpha) {
        if (this.isValidToRenderInThisState) {
            class_4597.class_4598 bob;
            class_4588 newVertex;
            if (!this.isTopLevelModelRoot && this.textureOverride != null && currentlyHeldProvider != null && currentlyHeldEntity != null && (newVertex = (bob = class_310.method_1551().method_22940().method_23000()).getBuffer(class_1921.method_23580((class_2960)ETFApi.getCurrentETFVariantTextureOfEntity((class_1297)currentlyHeldEntity, (class_2960)this.textureOverride)))) != null) {
                vertices = newVertex;
            }
            if (EMFConfig.getConfig().renderCustomModelsGreen) {
                float flash = (float)Math.abs(Math.sin((double)System.currentTimeMillis() / 1000.0));
                super.method_22699(matrices, vertices, light, overlay, flash, green, flash, alpha);
            } else {
                super.method_22699(matrices, vertices, light, overlay, red, green, blue, alpha);
            }
        }
    }

    public void assertChildrenAndCuboids() {
        ((ModelPartAccessor)((Object)this)).setChildren(new HashMap<String, class_630>(this.emfChildren));
        ((ModelPartAccessor)((Object)this)).setCuboids(new ArrayList<class_630.class_628>(this.emfCuboids));
    }

    protected void method_22702(class_4587.class_4665 entry, class_4588 vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        for (class_630.class_628 cuboid : ((ModelPartAccessor)((Object)this)).getCuboids()) {
            cuboid.method_32089(entry, vertexConsumer, light, overlay, red, green, blue, alpha);
        }
    }

    public void applyDefaultModelRotates(class_5603 defaults) {
        if (defaults != null) {
            this.method_32085(defaults);
            this.method_41918(defaults);
            if (this.allKnownStateVariants.containsKey(0) && this.allKnownStateVariants.size() == 1) {
                this.allKnownStateVariants.put(0, (Object)this.getCurrentState());
            }
        }
    }

    public void setPartAsTopLevelRoot() {
        this.isTopLevelModelRoot = true;
    }

    public Object2ReferenceOpenHashMap<String, EMFModelPartMutable> getAllChildPartsAsMap() {
        Object2ReferenceOpenHashMap list = new Object2ReferenceOpenHashMap();
        for (class_630 part : ((ModelPartAccessor)((Object)this)).getChildren().values()) {
            String thisKey;
            if (!(part instanceof EMFModelPartMutable)) continue;
            EMFModelPartMutable part3 = (EMFModelPartMutable)part;
            String string = thisKey = part3.selfModelData == null ? String.valueOf(((Object)((Object)part3)).hashCode()) : part3.selfModelData.part;
            if (thisKey == null) {
                thisKey = part3.selfModelData.id;
            }
            list.put((Object)thisKey, (Object)part3);
            list.putAll(part3.getAllChildPartsAsMap());
        }
        return list;
    }

    public String toString() {
        return "emfPart3{id=" + this.selfModelData.id + ", part=" + this.selfModelData.part + "}";
    }

    public Map<String, class_630> getChildrenEMF() {
        return ((ModelPartAccessor)((Object)this)).getChildren();
    }

    public void setChildrenEMF(Map<String, class_630> children) {
        ((ModelPartAccessor)((Object)this)).setChildren(children);
    }

    public void mergePartVariant(int variantNumber, EMFModelPartMutable partToMergeIntoThisAsVariant) {
        EMFModelState incomingPartState = partToMergeIntoThisAsVariant.getCurrentState();
        this.allKnownStateVariants.put(variantNumber, (Object)incomingPartState);
        for (Map.Entry<String, class_630> childEntry : partToMergeIntoThisAsVariant.getChildrenEMF().entrySet()) {
            class_630 class_6302 = childEntry.getValue();
            if (class_6302 instanceof EMFModelPartMutable) {
                EMFModelPartMutable p2 = (EMFModelPartMutable)class_6302;
                class_6302 = this.getChildrenEMF().get(childEntry.getKey());
                if (class_6302 instanceof EMFModelPartMutable) {
                    EMFModelPartMutable p3 = (EMFModelPartMutable)class_6302;
                    p3.mergePartVariant(variantNumber, p2);
                    continue;
                }
            }
            Map<String, class_630> children = this.getChildrenEMF();
            children.put(childEntry.getKey(), childEntry.getValue());
        }
    }

    public void mergeInVanillaWhereRequired(class_630 partToMergeIntoThisAsVanilla) {
        if (this.selfModelData != null && this.selfModelData.thisNeedsToMergeWithVanilla) {
            EMFModelState incomingPartState = this.getStateOf(partToMergeIntoThisAsVanilla);
            this.setFromState(incomingPartState);
        }
        for (Map.Entry<String, class_630> childEntry : this.getChildrenEMF().entrySet()) {
            class_630 class_6302;
            if (!partToMergeIntoThisAsVanilla.method_41919(childEntry.getKey()) || !((class_6302 = childEntry.getValue()) instanceof EMFModelPartMutable)) continue;
            EMFModelPartMutable p3 = (EMFModelPartMutable)class_6302;
            p3.mergeInVanillaWhereRequired(partToMergeIntoThisAsVanilla.method_32086(childEntry.getKey()));
        }
    }

    public void setVariantStateTo(int newVariantState) {
        if (this.currentModelVariantState != newVariantState) {
            if (this.allKnownStateVariants.containsKey(newVariantState)) {
                this.currentModelVariantState = newVariantState;
                this.setFromState((EMFModelState)this.allKnownStateVariants.get(newVariantState));
                this.isValidToRenderInThisState = true;
            } else if (this.selfModelData != null && this.selfModelData.part == null) {
                this.currentModelVariantState = newVariantState;
                this.isValidToRenderInThisState = false;
            } else {
                EMFUtils.EMFModWarn("no state for top level part????");
                this.currentModelVariantState = newVariantState;
                this.isValidToRenderInThisState = false;
            }
            for (class_630 part : this.getChildrenEMF().values()) {
                if (!(part instanceof EMFModelPartMutable)) continue;
                EMFModelPartMutable p3 = (EMFModelPartMutable)part;
                p3.setVariantStateTo(newVariantState);
            }
        }
    }

    private EMFModelState getCurrentState() {
        return new EMFModelState(this.method_41921(), ((ModelPartAccessor)((Object)this)).getCuboids(), this.field_37938, this.field_37939, this.field_37940, this.field_3665, this.field_38456);
    }

    private EMFModelState getStateOf(class_630 modelPart) {
        return new EMFModelState(modelPart.method_41921(), ((ModelPartAccessor)modelPart).getCuboids(), modelPart.field_37938, modelPart.field_37939, modelPart.field_37940, modelPart.field_3665, modelPart.field_38456);
    }

    private void setFromState(EMFModelState newState) {
        this.method_41918(newState.defaultTransform());
        this.method_32085(this.method_41921());
        ((ModelPartAccessor)((Object)this)).setCuboids(newState.cuboids());
        this.field_37938 = newState.xScale();
        this.field_37939 = newState.yScale();
        this.field_37940 = newState.zScale();
        this.field_3665 = newState.visible();
        this.field_38456 = newState.hidden();
    }

    private record EMFModelState(class_5603 defaultTransform, List<class_630.class_628> cuboids, float xScale, float yScale, float zScale, boolean visible, boolean hidden) {
    }

    @Environment(value=EnvType.CLIENT)
    public static class EMFCuboid
    extends class_630.class_628 {
        public final float minXEMF;
        public final float minYEMF;
        public final float minZEMF;
        public final float maxXEMF;
        public final float maxYEMF;
        public final float maxZEMF;
        private final class_630.class_593[] sidesEMF;

        public EMFCuboid(EMFPartData selfModelData, float textureU, float textureV, float cubeX, float cubeY, float cubeZ, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, float textureWidth, float textureHeight, boolean mirrorU, boolean mirrorV) {
            ArrayList<class_630.class_593> sides;
            block25: {
                float r;
                float q;
                float o;
                float n;
                class_630.class_618 vertex8;
                class_630.class_618 vertex7;
                class_630.class_618 vertex6;
                class_630.class_618 vertex5;
                block24: {
                    float l;
                    class_630.class_618 vertex4;
                    class_630.class_618 vertex3;
                    class_630.class_618 vertex2;
                    class_630.class_618 vertex;
                    block23: {
                        float k;
                        block22: {
                            float j;
                            block21: {
                                float p;
                                float m;
                                block20: {
                                    super((int)textureU, (int)textureV, cubeX, cubeY, cubeZ, sizeX, sizeY, sizeZ, extraX, extraY, extraZ, false, textureWidth, textureHeight, (Set)new HashSet<class_2350>(){
                                        {
                                            this.addAll(List.of(class_2350.values()));
                                        }
                                    });
                                    CuboidAccessor accessor = (CuboidAccessor)((Object)this);
                                    accessor.setMinX(cubeX);
                                    this.minXEMF = cubeX;
                                    accessor.setMinY(cubeY);
                                    this.minYEMF = cubeY;
                                    accessor.setMinZ(cubeZ);
                                    this.minZEMF = cubeZ;
                                    accessor.setMaxX(cubeX + sizeX);
                                    this.maxXEMF = cubeX + sizeX;
                                    accessor.setMaxY(cubeY + sizeY);
                                    this.maxYEMF = cubeY + sizeY;
                                    accessor.setMaxZ(cubeZ + sizeZ);
                                    this.maxZEMF = cubeZ + sizeZ;
                                    sides = new ArrayList<class_630.class_593>();
                                    float cubeX2 = cubeX + sizeX;
                                    float cubeY2 = cubeY + sizeY;
                                    float cubeZ2 = cubeZ + sizeZ;
                                    vertex = new class_630.class_618(cubeX -= extraX, cubeY -= extraY, cubeZ -= extraZ, 0.0f, 0.0f);
                                    vertex2 = new class_630.class_618(cubeX2 += extraX, cubeY, cubeZ, 0.0f, 8.0f);
                                    vertex3 = new class_630.class_618(cubeX2, cubeY2 += extraY, cubeZ, 8.0f, 8.0f);
                                    vertex4 = new class_630.class_618(cubeX, cubeY2, cubeZ, 8.0f, 0.0f);
                                    vertex5 = new class_630.class_618(cubeX, cubeY, cubeZ2 += extraZ, 0.0f, 0.0f);
                                    vertex6 = new class_630.class_618(cubeX2, cubeY, cubeZ2, 0.0f, 8.0f);
                                    vertex7 = new class_630.class_618(cubeX2, cubeY2, cubeZ2, 8.0f, 8.0f);
                                    vertex8 = new class_630.class_618(cubeX, cubeY2, cubeZ2, 8.0f, 0.0f);
                                    j = textureU;
                                    k = textureU + sizeZ;
                                    l = textureU + sizeZ + sizeX;
                                    m = textureU + sizeZ + sizeX + sizeX;
                                    n = textureU + sizeZ + sizeX + sizeZ;
                                    o = textureU + sizeZ + sizeX + sizeZ + sizeX;
                                    p = textureV;
                                    q = textureV + sizeZ;
                                    r = textureV + sizeZ + sizeY;
                                    try {
                                        class_630.class_618[] class_618Array;
                                        if (mirrorV) {
                                            class_630.class_618[] class_618Array2 = new class_630.class_618[4];
                                            class_618Array2[0] = vertex3;
                                            class_618Array2[1] = vertex4;
                                            class_618Array2[2] = vertex8;
                                            class_618Array = class_618Array2;
                                            class_618Array2[3] = vertex7;
                                        } else {
                                            class_630.class_618[] class_618Array3 = new class_630.class_618[4];
                                            class_618Array3[0] = vertex6;
                                            class_618Array3[1] = vertex5;
                                            class_618Array3[2] = vertex;
                                            class_618Array = class_618Array3;
                                            class_618Array3[3] = vertex2;
                                        }
                                        sides.add(new class_630.class_593(class_618Array, mirrorU ? l : k, mirrorV ? q : p, mirrorU ? k : l, mirrorV ? p : q, textureWidth, textureHeight, false, mirrorV ? class_2350.field_11036 : class_2350.field_11033));
                                    }
                                    catch (Exception e) {
                                        if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block20;
                                        EMFUtils.EMFModMessage("uv-dwn failed for " + selfModelData.id);
                                    }
                                }
                                try {
                                    class_630.class_618[] class_618Array;
                                    if (mirrorV) {
                                        class_630.class_618[] class_618Array4 = new class_630.class_618[4];
                                        class_618Array4[0] = vertex6;
                                        class_618Array4[1] = vertex5;
                                        class_618Array4[2] = vertex;
                                        class_618Array = class_618Array4;
                                        class_618Array4[3] = vertex2;
                                    } else {
                                        class_630.class_618[] class_618Array5 = new class_630.class_618[4];
                                        class_618Array5[0] = vertex3;
                                        class_618Array5[1] = vertex4;
                                        class_618Array5[2] = vertex8;
                                        class_618Array = class_618Array5;
                                        class_618Array5[3] = vertex7;
                                    }
                                    sides.add(new class_630.class_593(class_618Array, mirrorU ? m : l, mirrorV ? p : q, mirrorU ? l : m, mirrorV ? q : p, textureWidth, textureHeight, false, mirrorV ? class_2350.field_11033 : class_2350.field_11036));
                                }
                                catch (Exception e) {
                                    if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block21;
                                    EMFUtils.EMFModMessage("uv-up failed for " + selfModelData.id);
                                }
                            }
                            try {
                                class_630.class_618[] class_618Array;
                                if (mirrorU) {
                                    class_630.class_618[] class_618Array6 = new class_630.class_618[4];
                                    class_618Array6[0] = vertex6;
                                    class_618Array6[1] = vertex2;
                                    class_618Array6[2] = vertex3;
                                    class_618Array = class_618Array6;
                                    class_618Array6[3] = vertex7;
                                } else {
                                    class_630.class_618[] class_618Array7 = new class_630.class_618[4];
                                    class_618Array7[0] = vertex;
                                    class_618Array7[1] = vertex5;
                                    class_618Array7[2] = vertex8;
                                    class_618Array = class_618Array7;
                                    class_618Array7[3] = vertex4;
                                }
                                sides.add(new class_630.class_593(class_618Array, mirrorU ? k : j, mirrorV ? r : q, mirrorU ? j : k, mirrorV ? q : r, textureWidth, textureHeight, false, mirrorU ? class_2350.field_11034 : class_2350.field_11039));
                            }
                            catch (Exception e) {
                                if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block22;
                                EMFUtils.EMFModMessage("uv-west failed for " + selfModelData.id);
                            }
                        }
                        try {
                            sides.add(new class_630.class_593(new class_630.class_618[]{vertex2, vertex, vertex4, vertex3}, mirrorU ? l : k, mirrorV ? r : q, mirrorU ? k : l, mirrorV ? q : r, textureWidth, textureHeight, false, class_2350.field_11043));
                        }
                        catch (Exception e) {
                            if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block23;
                            EMFUtils.EMFModMessage("uv-nrth failed for " + selfModelData.id);
                        }
                    }
                    try {
                        class_630.class_618[] class_618Array;
                        if (mirrorU) {
                            class_630.class_618[] class_618Array8 = new class_630.class_618[4];
                            class_618Array8[0] = vertex;
                            class_618Array8[1] = vertex5;
                            class_618Array8[2] = vertex8;
                            class_618Array = class_618Array8;
                            class_618Array8[3] = vertex4;
                        } else {
                            class_630.class_618[] class_618Array9 = new class_630.class_618[4];
                            class_618Array9[0] = vertex6;
                            class_618Array9[1] = vertex2;
                            class_618Array9[2] = vertex3;
                            class_618Array = class_618Array9;
                            class_618Array9[3] = vertex7;
                        }
                        sides.add(new class_630.class_593(class_618Array, mirrorU ? n : l, mirrorV ? r : q, mirrorU ? l : n, mirrorV ? q : r, textureWidth, textureHeight, false, mirrorU ? class_2350.field_11039 : class_2350.field_11034));
                    }
                    catch (Exception e) {
                        if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block24;
                        EMFUtils.EMFModMessage("uv-east failed for " + selfModelData.id);
                    }
                }
                try {
                    sides.add(new class_630.class_593(new class_630.class_618[]{vertex5, vertex6, vertex7, vertex8}, mirrorU ? o : n, mirrorV ? r : q, mirrorU ? n : o, mirrorV ? q : r, textureWidth, textureHeight, false, class_2350.field_11035));
                }
                catch (Exception e) {
                    if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block25;
                    EMFUtils.EMFModMessage("uv-sth failed for " + selfModelData.id);
                }
            }
            this.sidesEMF = sides.toArray(new class_630.class_593[0]);
            ((CuboidAccessor)((Object)this)).setSides(this.sidesEMF);
        }

        public EMFCuboid(EMFPartData selfModelData, float[] uvDown, float[] uvUp, float[] uvNorth, float[] uvSouth, float[] uvWest, float[] uvEast, float cubeX, float cubeY, float cubeZ, float sizeX, float sizeY, float sizeZ, float extraX, float extraY, float extraZ, float textureWidth, float textureHeight, boolean mirrorU, boolean mirrorV) {
            ArrayList<class_630.class_593> sides;
            block25: {
                class_630.class_618 vertex8;
                class_630.class_618 vertex7;
                class_630.class_618 vertex6;
                class_630.class_618 vertex5;
                block24: {
                    class_630.class_618 vertex4;
                    class_630.class_618 vertex3;
                    class_630.class_618 vertex2;
                    class_630.class_618 vertex;
                    block23: {
                        block22: {
                            block21: {
                                block20: {
                                    super(0, 0, cubeX, cubeY, cubeZ, sizeX, sizeY, sizeZ, extraX, extraY, extraZ, false, textureWidth, textureHeight, (Set)new HashSet<class_2350>(){
                                        {
                                            this.addAll(List.of(class_2350.values()));
                                        }
                                    });
                                    CuboidAccessor accessor = (CuboidAccessor)((Object)this);
                                    accessor.setMinX(cubeX);
                                    this.minXEMF = cubeX;
                                    accessor.setMinY(cubeY);
                                    this.minYEMF = cubeY;
                                    accessor.setMinZ(cubeZ);
                                    this.minZEMF = cubeZ;
                                    accessor.setMaxX(cubeX + sizeX);
                                    this.maxXEMF = cubeX + sizeX;
                                    accessor.setMaxY(cubeY + sizeY);
                                    this.maxYEMF = cubeY + sizeY;
                                    accessor.setMaxZ(cubeZ + sizeZ);
                                    this.maxZEMF = cubeZ + sizeZ;
                                    sides = new ArrayList<class_630.class_593>();
                                    float cubeX2 = cubeX + sizeX;
                                    float cubeY2 = cubeY + sizeY;
                                    float cubeZ2 = cubeZ + sizeZ;
                                    vertex = new class_630.class_618(cubeX -= extraX, cubeY -= extraY, cubeZ -= extraZ, 0.0f, 0.0f);
                                    vertex2 = new class_630.class_618(cubeX2 += extraX, cubeY, cubeZ, 0.0f, 8.0f);
                                    vertex3 = new class_630.class_618(cubeX2, cubeY2 += extraY, cubeZ, 8.0f, 8.0f);
                                    vertex4 = new class_630.class_618(cubeX, cubeY2, cubeZ, 8.0f, 0.0f);
                                    vertex5 = new class_630.class_618(cubeX, cubeY, cubeZ2 += extraZ, 0.0f, 0.0f);
                                    vertex6 = new class_630.class_618(cubeX2, cubeY, cubeZ2, 0.0f, 8.0f);
                                    vertex7 = new class_630.class_618(cubeX2, cubeY2, cubeZ2, 8.0f, 8.0f);
                                    vertex8 = new class_630.class_618(cubeX, cubeY2, cubeZ2, 8.0f, 0.0f);
                                    try {
                                        class_630.class_618[] class_618Array;
                                        if (mirrorV) {
                                            class_630.class_618[] class_618Array2 = new class_630.class_618[4];
                                            class_618Array2[0] = vertex8;
                                            class_618Array2[1] = vertex7;
                                            class_618Array2[2] = vertex3;
                                            class_618Array = class_618Array2;
                                            class_618Array2[3] = vertex4;
                                        } else {
                                            class_630.class_618[] class_618Array3 = new class_630.class_618[4];
                                            class_618Array3[0] = vertex;
                                            class_618Array3[1] = vertex2;
                                            class_618Array3[2] = vertex6;
                                            class_618Array = class_618Array3;
                                            class_618Array3[3] = vertex5;
                                        }
                                        sides.add(new class_630.class_593(class_618Array, mirrorU ? uvUp[2] : uvUp[0], mirrorV ? uvUp[3] : uvUp[1], mirrorU ? uvUp[0] : uvUp[2], mirrorV ? uvUp[1] : uvUp[3], textureWidth, textureHeight, false, mirrorV ? class_2350.field_11036 : class_2350.field_11033));
                                    }
                                    catch (Exception e) {
                                        if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block20;
                                        EMFUtils.EMFModMessage("uv-up failed for " + selfModelData.id);
                                    }
                                }
                                try {
                                    class_630.class_618[] class_618Array;
                                    if (mirrorV) {
                                        class_630.class_618[] class_618Array4 = new class_630.class_618[4];
                                        class_618Array4[0] = vertex;
                                        class_618Array4[1] = vertex2;
                                        class_618Array4[2] = vertex6;
                                        class_618Array = class_618Array4;
                                        class_618Array4[3] = vertex5;
                                    } else {
                                        class_630.class_618[] class_618Array5 = new class_630.class_618[4];
                                        class_618Array5[0] = vertex8;
                                        class_618Array5[1] = vertex7;
                                        class_618Array5[2] = vertex3;
                                        class_618Array = class_618Array5;
                                        class_618Array5[3] = vertex4;
                                    }
                                    sides.add(new class_630.class_593(class_618Array, mirrorU ? uvDown[2] : uvDown[0], mirrorV ? uvDown[3] : uvDown[1], mirrorU ? uvDown[0] : uvDown[2], mirrorV ? uvDown[1] : uvDown[3], textureWidth, textureHeight, false, mirrorV ? class_2350.field_11033 : class_2350.field_11036));
                                }
                                catch (Exception e) {
                                    if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block21;
                                    EMFUtils.EMFModMessage("uv-down failed for " + selfModelData.id);
                                }
                            }
                            try {
                                class_630.class_618[] class_618Array;
                                if (mirrorU) {
                                    class_630.class_618[] class_618Array6 = new class_630.class_618[4];
                                    class_618Array6[0] = vertex;
                                    class_618Array6[1] = vertex5;
                                    class_618Array6[2] = vertex8;
                                    class_618Array = class_618Array6;
                                    class_618Array6[3] = vertex4;
                                } else {
                                    class_630.class_618[] class_618Array7 = new class_630.class_618[4];
                                    class_618Array7[0] = vertex6;
                                    class_618Array7[1] = vertex2;
                                    class_618Array7[2] = vertex3;
                                    class_618Array = class_618Array7;
                                    class_618Array7[3] = vertex7;
                                }
                                sides.add(new class_630.class_593(class_618Array, mirrorU ? uvWest[2] : uvWest[0], mirrorV ? uvWest[3] : uvWest[1], mirrorU ? uvWest[0] : uvWest[2], mirrorV ? uvWest[1] : uvWest[3], textureWidth, textureHeight, false, mirrorU ? class_2350.field_11039 : class_2350.field_11034));
                            }
                            catch (Exception e) {
                                if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block22;
                                EMFUtils.EMFModMessage("uv-west failed for " + selfModelData.id);
                            }
                        }
                        try {
                            sides.add(new class_630.class_593(new class_630.class_618[]{vertex2, vertex, vertex4, vertex3}, mirrorU ? uvNorth[2] : uvNorth[0], mirrorV ? uvNorth[3] : uvNorth[1], mirrorU ? uvNorth[0] : uvNorth[2], mirrorV ? uvNorth[1] : uvNorth[3], textureWidth, textureHeight, false, class_2350.field_11043));
                        }
                        catch (Exception e) {
                            if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block23;
                            EMFUtils.EMFModMessage("uv-north failed for " + selfModelData.id);
                        }
                    }
                    try {
                        class_630.class_618[] class_618Array;
                        if (mirrorU) {
                            class_630.class_618[] class_618Array8 = new class_630.class_618[4];
                            class_618Array8[0] = vertex6;
                            class_618Array8[1] = vertex2;
                            class_618Array8[2] = vertex3;
                            class_618Array = class_618Array8;
                            class_618Array8[3] = vertex7;
                        } else {
                            class_630.class_618[] class_618Array9 = new class_630.class_618[4];
                            class_618Array9[0] = vertex;
                            class_618Array9[1] = vertex5;
                            class_618Array9[2] = vertex8;
                            class_618Array = class_618Array9;
                            class_618Array9[3] = vertex4;
                        }
                        sides.add(new class_630.class_593(class_618Array, mirrorU ? uvEast[2] : uvEast[0], mirrorV ? uvEast[3] : uvEast[1], mirrorU ? uvEast[0] : uvEast[2], mirrorV ? uvEast[1] : uvEast[3], textureWidth, textureHeight, false, mirrorU ? class_2350.field_11034 : class_2350.field_11039));
                    }
                    catch (Exception e) {
                        if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block24;
                        EMFUtils.EMFModMessage("uv-east failed for " + selfModelData.id);
                    }
                }
                try {
                    sides.add(new class_630.class_593(new class_630.class_618[]{vertex5, vertex6, vertex7, vertex8}, mirrorU ? uvSouth[2] : uvSouth[0], mirrorV ? uvSouth[3] : uvSouth[1], mirrorU ? uvSouth[0] : uvSouth[2], mirrorV ? uvSouth[1] : uvSouth[3], textureWidth, textureHeight, false, class_2350.field_11035));
                }
                catch (Exception e) {
                    if (!EMFConfig.getConfig().printModelCreationInfoToLog) break block25;
                    EMFUtils.EMFModMessage("uv-south failed for " + selfModelData.id);
                }
            }
            this.sidesEMF = sides.toArray(new class_630.class_593[0]);
            ((CuboidAccessor)((Object)this)).setSides(this.sidesEMF);
        }
    }
}

