/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation;

import it.unimi.dsi.fastutil.objects.Object2FloatOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1297;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.models.EMFModelPartMutable;
import traben.entity_model_features.models.animation.EMFAnimationVariableSuppliers;
import traben.entity_model_features.models.animation.EMFDefaultModelVariable;
import traben.entity_model_features.models.animation.animation_math_parser.MathComponent;
import traben.entity_model_features.models.animation.animation_math_parser.MathExpressionParser;
import traben.entity_model_features.utils.EMFUtils;

public class EMFAnimation {
    public final EMFModelPartMutable partToApplyTo;
    public final EMFDefaultModelVariable variableToChange;
    public final String animKey;
    public final String expressionString;
    public final String modelName;
    public final EMFAnimationVariableSuppliers variableSuppliers;
    public final boolean isVariable;
    final float defaultValue;
    private final Random rand = new Random();
    public int indentCount = 0;
    public Object2ObjectLinkedOpenHashMap<String, EMFAnimation> emfAnimationVariables = null;
    public Object2ObjectOpenHashMap<String, EMFModelPartMutable> allPartByName = null;
    public boolean verboseMode = false;
    public final Object2FloatOpenHashMap<UUID> prevResult = new Object2FloatOpenHashMap();
    MathComponent EMFCalculator = MathExpressionParser.NULL_EXPRESSION;

    public EMFAnimation(EMFModelPartMutable partToApplyTo, EMFDefaultModelVariable variableToChange, String animKey, String initialExpression, String modelName, EMFAnimationVariableSuppliers variableSuppliers) {
        this.variableSuppliers = variableSuppliers;
        this.modelName = modelName;
        this.animKey = animKey;
        this.isVariable = animKey.startsWith("var");
        this.variableToChange = variableToChange;
        this.partToApplyTo = partToApplyTo;
        if (variableToChange != null) {
            if (partToApplyTo == null) {
                System.out.println("null part for " + animKey);
                this.defaultValue = 0.0f;
            } else {
                this.defaultValue = variableToChange.getDefaultFromModel(partToApplyTo);
            }
        } else {
            this.defaultValue = 0.0f;
        }
        this.prevResult.defaultReturnValue(this.defaultValue);
        this.expressionString = initialExpression;
    }

    public String toString() {
        return this.animKey;
    }

    public void initExpression(Object2ObjectLinkedOpenHashMap<String, EMFAnimation> emfAnimationVariables, Object2ObjectOpenHashMap<String, EMFModelPartMutable> allPartByName) {
        this.emfAnimationVariables = emfAnimationVariables;
        this.allPartByName = allPartByName;
        this.EMFCalculator = MathExpressionParser.getOptimizedExpression(this.expressionString, false, this);
        this.emfAnimationVariables = null;
        this.allPartByName = null;
    }

    public void setVerbose(boolean val) {
        this.verboseMode = val;
    }

    public float getLastResultOnly(class_1297 entity0) {
        if (entity0 == null) {
            return 0.0f;
        }
        float value = this.prevResult.getFloat((Object)entity0.method_5667());
        return value == Float.MIN_VALUE ? 0.0f : value;
    }

    public float getResultViaCalculate(class_1297 entity0, boolean storeResult) {
        if (entity0 == null) {
            return 0.0f;
        }
        float result = this.calculatorRun();
        if (storeResult) {
            this.prevResult.put((Object)entity0.method_5667(), result);
        }
        return result;
    }

    public float getResultViaCalculate(class_1297 entity0) {
        return this.getResultViaCalculate(entity0, true);
    }

    public float calculatorRun() {
        if (EMFConfig.getConfig().printAllMaths && this.animKey.equals("left_leg.ry") && this.rand.nextInt(100) == 1) {
            this.setVerbose(true);
            double val = this.EMFCalculator.get();
            System.out.println(this.EMFCalculator.toString() + " is " + this.EMFCalculator.getClass());
            EMFUtils.EMFModMessage("animation result: " + this.animKey + " = " + val);
            return (float)val;
        }
        return this.EMFCalculator.get();
    }

    public void calculateAndSet(class_1297 entity0) {
        if (this.isVariable) {
            this.getResultViaCalculate(entity0);
        } else {
            this.handleResult(this.getResultViaCalculate(entity0));
        }
    }

    private void handleResult(float result) {
        if (Double.isNaN(result)) {
            if (this.variableToChange != null) {
                this.variableToChange.setValueIn3Model(this.partToApplyTo, Float.MAX_VALUE);
            }
        } else if (this.partToApplyTo != null) {
            this.variableToChange.setValueIn3Model(this.partToApplyTo, result);
        }
    }

    public boolean isValid() {
        return this.EMFCalculator != MathExpressionParser.NULL_EXPRESSION;
    }

    public void animPrint(String str) {
        StringBuilder indent = new StringBuilder();
        indent.append("> ".repeat(Math.max(0, this.indentCount)));
        System.out.println(indent + str);
    }
}

