/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation;

import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1321;
import net.minecraft.class_1451;
import net.minecraft.class_1453;
import net.minecraft.class_1493;
import net.minecraft.class_1667;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4019;
import net.minecraft.class_5354;
import net.minecraft.class_7134;

public class EMFAnimationVariableSuppliers {
    public class_1297 entity = null;
    public float limbAngle = 0.0f;
    public float limbDistance = 0.0f;
    public float animationProgress = 0.0f;
    public float headYaw = 0.0f;
    public float headPitch = 0.0f;
    public float tickDelta = 0.0f;
    private final Object2IntOpenHashMap<UUID> knownHighestAngerTimeByUUID = new Object2IntOpenHashMap<UUID>(){
        {
            this.defaultReturnValue(0);
        }
    };

    public float getRuleIndex() {
        return 0.0f;
    }

    public class_1297 getEntity() {
        return this.entity;
    }

    public float getDimension() {
        if (this.entity == null || this.entity.method_37908() == null) {
            return 0.0f;
        }
        class_2960 id = this.entity.method_37908().method_44013().method_29177();
        if (id.equals((Object)class_7134.field_37671)) {
            return -1.0f;
        }
        if (id.equals((Object)class_7134.field_37672)) {
            return 1.0f;
        }
        return 0.0f;
    }

    public float getPlayerX() {
        return class_310.method_1551().field_1724 == null ? 0.0f : (float)class_3532.method_16436((double)this.tickDelta, (double)class_310.method_1551().field_1724.field_6014, (double)class_310.method_1551().field_1724.method_23317());
    }

    public float getPlayerY() {
        return class_310.method_1551().field_1724 == null ? 0.0f : (float)class_3532.method_16436((double)this.tickDelta, (double)class_310.method_1551().field_1724.field_6036, (double)class_310.method_1551().field_1724.method_23318());
    }

    public float getPlayerZ() {
        return class_310.method_1551().field_1724 == null ? 0.0f : (float)class_3532.method_16436((double)this.tickDelta, (double)class_310.method_1551().field_1724.field_5969, (double)class_310.method_1551().field_1724.method_23321());
    }

    public float getPlayerRX() {
        return class_310.method_1551().field_1724 == null ? 0.0f : (float)Math.toRadians(class_3532.method_17821((float)this.tickDelta, (float)class_310.method_1551().field_1724.field_6004, (float)class_310.method_1551().field_1724.method_36455()));
    }

    public float getPlayerRY() {
        return class_310.method_1551().field_1724 == null ? 0.0f : (float)Math.toRadians(class_3532.method_17821((float)this.tickDelta, (float)class_310.method_1551().field_1724.field_5982, (float)class_310.method_1551().field_1724.method_36454()));
    }

    public float getEntityX() {
        return this.getEntity() == null ? 0.0f : (float)class_3532.method_16436((double)this.getTickDelta(), (double)this.getEntity().field_6014, (double)this.getEntity().method_23317());
    }

    public float getEntityY() {
        return this.getEntity() == null ? 0.0f : (float)class_3532.method_16436((double)this.getTickDelta(), (double)this.getEntity().field_6036, (double)this.getEntity().method_23318());
    }

    public float getEntityZ() {
        return this.getEntity() == null ? 0.0f : (float)class_3532.method_16436((double)this.getTickDelta(), (double)this.getEntity().field_5969, (double)this.getEntity().method_23321());
    }

    public float getEntityRX() {
        return this.getEntity() == null ? 0.0f : (float)Math.toRadians(class_3532.method_17821((float)this.tickDelta, (float)this.getEntity().field_6004, (float)this.getEntity().method_36455()));
    }

    public float getEntityRY() {
        float f;
        class_1297 class_12972 = this.getEntity();
        if (class_12972 instanceof class_1309) {
            class_1309 alive = (class_1309)class_12972;
            f = (float)Math.toRadians(class_3532.method_17821((float)this.tickDelta, (float)alive.field_6220, (float)alive.method_43078()));
        } else {
            f = 0.0f;
        }
        return f;
    }

    public float getTime() {
        if (this.entity == null || this.entity.method_37908() == null) {
            return 0.0f + this.tickDelta;
        }
        long upTimeInTicks = this.entity.method_37908().method_8510();
        return this.constrainedFloat(upTimeInTicks, 720720) + this.tickDelta;
    }

    public float getDayTime() {
        if (this.entity == null || this.entity.method_37908() == null) {
            return 0.0f + this.tickDelta;
        }
        return this.constrainedFloat(this.entity.method_37908().method_8532(), 24000) + this.tickDelta;
    }

    public float getDayCount() {
        if (this.entity == null || this.entity.method_37908() == null) {
            return 0.0f + this.tickDelta;
        }
        return (float)(this.entity.method_37908().method_8532() / 24000L) + this.tickDelta;
    }

    public float getHealth() {
        float f;
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_1309) {
            class_1309 alive = (class_1309)class_12972;
            f = alive.method_6032();
        } else {
            f = 1.0f;
        }
        return f;
    }

    public float getDeathTime() {
        float f;
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_1309) {
            class_1309 alive = (class_1309)class_12972;
            f = alive.field_6213;
        } else {
            f = 0.0f;
        }
        return f;
    }

    public float getAngerTime() {
        if (!(this.entity instanceof class_5354)) {
            return 0.0f;
        }
        float currentKnownHighest = this.knownHighestAngerTimeByUUID.getInt((Object)this.entity.method_5667());
        int angerTime = ((class_5354)this.entity).method_29507();
        if (angerTime <= 0) {
            this.knownHighestAngerTimeByUUID.put((Object)this.entity.method_5667(), 0);
            return 0.0f;
        }
        if ((float)angerTime > currentKnownHighest) {
            this.knownHighestAngerTimeByUUID.put((Object)this.entity.method_5667(), angerTime);
        }
        return (float)angerTime - this.tickDelta;
    }

    public float getAngerTimeStart() {
        return !(this.entity instanceof class_5354) ? 0.0f : (float)this.knownHighestAngerTimeByUUID.getInt((Object)this.entity.method_5667());
    }

    public float getMaxHealth() {
        float f;
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_1309) {
            class_1309 alive = (class_1309)class_12972;
            f = alive.method_6063();
        } else {
            f = 1.0f;
        }
        return f;
    }

    public float getId() {
        return this.entity == null ? 0.0f : (float)this.entity.method_5667().hashCode();
    }

    public float getHurtTime() {
        float f;
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_1309) {
            class_1309 alive = (class_1309)class_12972;
            f = alive.field_6235 > 0 ? (float)alive.field_6235 - this.tickDelta : 0.0f;
        } else {
            f = 0.0f;
        }
        return f;
    }

    public boolean isInWater() {
        return this.entity != null && this.entity.method_5799();
    }

    public boolean isBurning() {
        return this.entity != null && this.entity.method_5809();
    }

    public boolean isRiding() {
        return this.entity != null && this.entity.method_5765();
    }

    public boolean isChild() {
        class_1309 alive;
        class_1297 class_12972 = this.entity;
        return class_12972 instanceof class_1309 && (alive = (class_1309)class_12972).method_6109();
    }

    public boolean isOnGround() {
        return this.entity != null && this.entity.method_24828();
    }

    public boolean isClimbing() {
        class_1309 alive;
        class_1297 class_12972 = this.entity;
        return class_12972 instanceof class_1309 && (alive = (class_1309)class_12972).method_6101();
    }

    public boolean isAlive() {
        return this.entity != null && this.entity.method_5805();
    }

    public boolean isAggressive() {
        return this.entity instanceof class_1308 && ((class_1308)this.entity).method_6510();
    }

    public boolean isGlowing() {
        return this.entity != null && this.entity.method_5851();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isHurt() {
        class_1297 class_12972 = this.entity;
        if (!(class_12972 instanceof class_1309)) return false;
        class_1309 alive = (class_1309)class_12972;
        if (alive.field_6235 <= 0) return false;
        return true;
    }

    public boolean isInHand() {
        return false;
    }

    public boolean isInItemFrame() {
        return false;
    }

    public boolean isInGround() {
        class_1667 arrow;
        class_1297 class_12972 = this.entity;
        return class_12972 instanceof class_1667 && (arrow = (class_1667)class_12972).method_24828();
    }

    public boolean isInGui() {
        return false;
    }

    public boolean isInLava() {
        return this.entity != null && this.entity.method_5771();
    }

    public boolean isInvisible() {
        return this.entity != null && this.entity.method_5767();
    }

    public boolean isOnHead() {
        return false;
    }

    public boolean isOnShoulder() {
        return false;
    }

    public boolean isRidden() {
        return this.entity != null && this.entity.method_5782();
    }

    public boolean isSitting() {
        class_1493 wolf;
        class_1451 cat;
        class_1453 parrot;
        class_4019 fox;
        class_1321 tame;
        class_1297 class_12972;
        return this.entity != null && ((class_12972 = this.entity) instanceof class_1321 && (tame = (class_1321)class_12972).method_6172() || (class_12972 = this.entity) instanceof class_4019 && (fox = (class_4019)class_12972).method_18272() || (class_12972 = this.entity) instanceof class_1453 && (parrot = (class_1453)class_12972).method_6172() || (class_12972 = this.entity) instanceof class_1451 && (cat = (class_1451)class_12972).method_6172() || (class_12972 = this.entity) instanceof class_1493 && (wolf = (class_1493)class_12972).method_6172());
    }

    public boolean isSneaking() {
        return this.entity != null && this.entity.method_5715();
    }

    public boolean isSprinting() {
        return this.entity != null && this.entity.method_5624();
    }

    public boolean isTamed() {
        class_1321 tame;
        class_1297 class_12972 = this.entity;
        return class_12972 instanceof class_1321 && (tame = (class_1321)class_12972).method_6181();
    }

    public boolean isWet() {
        return this.entity != null && this.entity.method_5637();
    }

    public float getSwingProgress() {
        float f;
        class_1297 class_12972 = this.entity;
        if (class_12972 instanceof class_1309) {
            class_1309 alive = (class_1309)class_12972;
            f = alive.method_6055(this.tickDelta);
        } else {
            f = 0.0f;
        }
        return f;
    }

    public float getAge() {
        if (this.entity == null) {
            return 0.0f + this.tickDelta;
        }
        return this.constrainedFloat(this.entity.field_6012, 24000) + this.tickDelta;
    }

    private float constrainedFloat(float value, int constraint) {
        return value >= (float)constraint ? value % (float)constraint : value;
    }

    private float constrainedFloat(float value) {
        return this.constrainedFloat(value, 24000);
    }

    private float constrainedFloat(long value, int constraint) {
        return value >= (long)constraint ? value % (long)constraint : value;
    }

    private float constrainedFloat(long value) {
        return this.constrainedFloat(value, 24000);
    }

    private float constrainedFloat(int value, int constraint) {
        return value >= constraint ? value % constraint : value;
    }

    private float constrainedFloat(int value) {
        return this.constrainedFloat(value, 24000);
    }

    public float getFrameTime() {
        return class_310.method_1551().method_1534() / 20.0f;
    }

    public float getLimbAngle() {
        return this.limbAngle;
    }

    public float getLimbDistance() {
        return this.limbDistance;
    }

    public float getHeadYaw() {
        return this.headYaw;
    }

    public float getHeadPitch() {
        return this.headPitch;
    }

    public float getTickDelta() {
        return this.tickDelta;
    }

    public float getMoveForward() {
        if (this.entity == null) {
            return 0.0f;
        }
        double lookDir = Math.toRadians(90.0f - this.entity.method_36454());
        class_243 velocity = this.entity.method_18798();
        double x = velocity.field_1352;
        double y = velocity.field_1350;
        double newX = x * Math.cos(lookDir) - y * Math.sin(lookDir);
        return this.processMove(newX, x, y);
    }

    public float getMoveStrafe() {
        if (this.entity == null) {
            return 0.0f;
        }
        double lookDir = Math.toRadians(90.0f - this.entity.method_36454());
        class_243 velocity = this.entity.method_18798();
        double x = velocity.field_1352;
        double y = velocity.field_1350;
        double newY = x * Math.sin(lookDir) + y * Math.cos(lookDir);
        return this.processMove(newY, x, y);
    }

    private float processMove(double value, double x, double y) {
        double totalMovementVector = Math.sqrt(x * x + y * y);
        if (totalMovementVector == 0.0) {
            return 0.0f;
        }
        return (float)(-(value / totalMovementVector));
    }
}

