/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation;

import net.minecraft.class_5603;
import net.minecraft.class_630;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.models.EMFModelPartMutable;

public enum EMFDefaultModelVariable {
    tx,
    ty,
    tz,
    rx(true),
    ry(true),
    rz(true),
    sx,
    sy,
    sz,
    visible,
    visible_boxes,
    CUSTOM;

    public final boolean isRotation;

    private EMFDefaultModelVariable(boolean val) {
        this.isRotation = val;
    }

    private EMFDefaultModelVariable() {
        this.isRotation = false;
    }

    @Nullable
    public static EMFDefaultModelVariable get(String id) {
        if (id == null) {
            return null;
        }
        return switch (id) {
            case "tx" -> tx;
            case "ty" -> ty;
            case "tz" -> tz;
            case "rx" -> rx;
            case "ry" -> ry;
            case "rz" -> rz;
            case "sx" -> sx;
            case "sy" -> sy;
            case "sz" -> sz;
            case "visible" -> visible;
            case "visible_boxes" -> visible_boxes;
            default -> null;
        };
    }

    public float getDefaultFromModel(class_630 modelPart) {
        if (modelPart == null) {
            System.out.println("model part was null cannot get its default value");
            return 0.0f;
        }
        class_5603 transform = modelPart.method_41921();
        switch (this) {
            case tx: {
                return transform.field_27702;
            }
            case ty: {
                return transform.field_27703;
            }
            case tz: {
                return transform.field_27704;
            }
            case rx: {
                return transform.field_27705;
            }
            case ry: {
                return transform.field_27706;
            }
            case rz: {
                return transform.field_27707;
            }
            case sx: {
                return modelPart.field_37938;
            }
            case sy: {
                return modelPart.field_37939;
            }
            case sz: {
                return modelPart.field_37940;
            }
            case visible: {
                return modelPart.field_3665 ? 1.0f : 0.0f;
            }
            case visible_boxes: {
                return modelPart.field_38456 ? 0.0f : 1.0f;
            }
        }
        System.out.println("model variable was defaulted cannot get its default value");
        return 0.0f;
    }

    public float getFrom3Model(EMFModelPartMutable modelPart, EMFModelPartMutable sourceModel) {
        if (modelPart == null) {
            System.out.println("model part was null cannot get its value");
            return 0.0f;
        }
        float[] parentModify = modelPart.selfModelData != null ? modelPart.selfModelData.parentModified : new float[]{0.0f, 0.0f, 0.0f};
        switch (this) {
            case tx: {
                return modelPart.field_3657 - parentModify[0];
            }
            case ty: {
                return modelPart.field_3656 - parentModify[1];
            }
            case tz: {
                return modelPart.field_3655 - parentModify[2];
            }
            case rx: {
                return modelPart.field_3654;
            }
            case ry: {
                return modelPart.field_3675;
            }
            case rz: {
                return modelPart.field_3674;
            }
            case sx: {
                return modelPart.field_37938;
            }
            case sy: {
                return modelPart.field_37939;
            }
            case sz: {
                return modelPart.field_37940;
            }
            case visible: {
                return modelPart.field_3665 ? 1.0f : 0.0f;
            }
            case visible_boxes: {
                return modelPart.field_38456 ? 0.0f : 1.0f;
            }
        }
        System.out.println("model variable was defaulted cannot get its value");
        return 0.0f;
    }

    public void setValueIn3Model(EMFModelPartMutable modelPart, float value) {
        if (modelPart == null) {
            System.out.println("model part was null cannot set its value");
            return;
        }
        float[] parentModify = modelPart.selfModelData != null ? modelPart.selfModelData.parentModified : new float[]{0.0f, 0.0f, 0.0f};
        switch (this) {
            case tx: {
                modelPart.field_3657 = value + parentModify[0];
                break;
            }
            case ty: {
                modelPart.field_3656 = value + parentModify[1];
                break;
            }
            case tz: {
                modelPart.field_3655 = value + parentModify[2];
                break;
            }
            case rx: {
                modelPart.field_3654 = value;
                break;
            }
            case ry: {
                modelPart.field_3675 = value;
                break;
            }
            case rz: {
                modelPart.field_3674 = value;
                break;
            }
            case sx: {
                modelPart.field_37938 = value;
                break;
            }
            case sy: {
                modelPart.field_37939 = value;
                break;
            }
            case sz: {
                modelPart.field_37940 = value;
                break;
            }
            case visible: {
                modelPart.field_3665 = value == 1.0f;
                break;
            }
            case visible_boxes: {
                modelPart.field_38456 = value != 1.0f;
                break;
            }
            default: {
                System.out.println("model variable was defaulted cannot set its value");
            }
        }
    }
}

