/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.models.animation.animation_math_parser;

import traben.entity_model_features.models.animation.animation_math_parser.MathComponent;
import traben.entity_model_features.models.animation.animation_math_parser.MathConstant;
import traben.entity_model_features.models.animation.animation_math_parser.MathValue;

public enum MathAction implements MathComponent
{
    add,
    subtract,
    multiply,
    divide,
    divisionRemainder,
    comma,
    openBracket,
    closedBracket,
    none,
    and,
    or,
    largerThan,
    smallerThan,
    largerThanOrEquals,
    smallerThanOrEquals,
    equals,
    notEquals,
    BOOLEAN_CHAR;


    public static MathAction getAction(char ch) {
        return switch (ch) {
            case '+' -> add;
            case '-' -> subtract;
            case '*' -> multiply;
            case '/' -> divide;
            case ',' -> comma;
            case '(' -> openBracket;
            case ')' -> closedBracket;
            case '%' -> divisionRemainder;
            case '!', '&', '<', '=', '>', '|' -> BOOLEAN_CHAR;
            default -> none;
        };
    }

    public float run(MathComponent first, MathComponent second) {
        return switch (this) {
            case add -> first.get() + second.get();
            case subtract -> first.get() - second.get();
            case multiply -> first.get() * second.get();
            case divide -> {
                if (second.isConstant()) {
                    yield first.get() * ((MathConstant)second).reciprocal;
                }
                yield first.get() * (1.0f / second.get());
            }
            case divisionRemainder -> first.get() % second.get();
            case largerThan -> {
                if (first.get() > second.get()) {
                    yield 1.0f;
                }
                yield 0.0f;
            }
            case largerThanOrEquals -> {
                if (first.get() >= second.get()) {
                    yield 1.0f;
                }
                yield 0.0f;
            }
            case smallerThan -> {
                if (first.get() < second.get()) {
                    yield 1.0f;
                }
                yield 0.0f;
            }
            case smallerThanOrEquals -> {
                if (first.get() <= second.get()) {
                    yield 1.0f;
                }
                yield 0.0f;
            }
            case equals -> {
                if (first.get() == second.get()) {
                    yield 1.0f;
                }
                yield 0.0f;
            }
            case notEquals -> {
                if (first.get() != second.get()) {
                    yield 1.0f;
                }
                yield 0.0f;
            }
            case and -> {
                if (first.get() == 1.0f && second.get() == 1.0f) {
                    yield 1.0f;
                }
                yield 0.0f;
            }
            case or -> {
                if (first.get() == 1.0f || second.get() == 1.0f) {
                    yield 1.0f;
                }
                yield 0.0f;
            }
            default -> Float.NaN;
        };
    }

    public MathValue.ValueSupplier getBinaryRunnable(MathComponent first, MathComponent second) {
        return switch (this) {
            case add -> () -> first.get() + second.get();
            case subtract -> () -> first.get() - second.get();
            case multiply -> () -> first.get() * second.get();
            case divide -> () -> first.get() / second.get();
            case divisionRemainder -> () -> first.get() % second.get();
            case largerThan -> () -> first.get() > second.get() ? 1.0f : 0.0f;
            case largerThanOrEquals -> () -> first.get() >= second.get() ? 1.0f : 0.0f;
            case smallerThan -> () -> first.get() < second.get() ? 1.0f : 0.0f;
            case smallerThanOrEquals -> () -> first.get() <= second.get() ? 1.0f : 0.0f;
            case equals -> () -> first.get() == second.get() ? 1.0f : 0.0f;
            case notEquals -> () -> first.get() != second.get() ? 1.0f : 0.0f;
            case and -> () -> first.get() == 1.0f && second.get() == 1.0f ? 1.0f : 0.0f;
            case or -> () -> first.get() == 1.0f || second.get() == 1.0f ? 1.0f : 0.0f;
            default -> () -> Float.NaN;
        };
    }

    @Override
    public boolean isConstant() {
        return true;
    }

    @Override
    public float get() {
        System.out.println("ERROR: math action incorrectly called [" + this + "].");
        return Float.NaN;
    }
}

