/*
 * Decompiled with CFR 0.152.
 */
package traben.entity_model_features.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import it.unimi.dsi.fastutil.objects.Object2BooleanOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1454;
import net.minecraft.class_1474;
import net.minecraft.class_151;
import net.minecraft.class_1510;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3298;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5601;
import net.minecraft.class_630;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import traben.entity_model_features.config.EMFConfig;
import traben.entity_model_features.mixin.accessor.MinecraftClientAccessor;
import traben.entity_model_features.mixin.accessor.ModelPartAccessor;
import traben.entity_model_features.models.EMFModelPartMutable;
import traben.entity_model_features.models.animation.EMFAnimation;
import traben.entity_model_features.models.animation.EMFAnimationVariableSuppliers;
import traben.entity_model_features.models.animation.EMFDefaultModelVariable;
import traben.entity_model_features.models.jem_objects.EMFJemData;
import traben.entity_model_features.models.jem_objects.EMFPartData;
import traben.entity_model_features.utils.EMFOptiFinePartNameMappings;
import traben.entity_model_features.utils.EMFUtils;
import traben.entity_texture_features.ETFApi;
import traben.entity_texture_features.config.ETFConfig;

public class EMFManager {
    private static final Object2ObjectOpenHashMap<String, String> map_MultiMobVariantMap = new Object2ObjectOpenHashMap<String, String>(){
        {
            this.put("shulker_b", "shulker_box");
        }
    };
    private static EMFManager self = null;
    private final Object2ObjectOpenHashMap<String, EMFJemData> cache_JemDataByFileName = new Object2ObjectOpenHashMap();
    private final Object2IntOpenHashMap<String> cache_AmountOfMobNameAlreadyDone = new Object2IntOpenHashMap();
    private final Object2ObjectOpenHashMap<String, EMFAnimationExecutor> cache_EntityNameToAnimationExecutable = new Object2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<String, EMFModelPartMutable> cache_JemNameToCannonModelRoot = new Object2ObjectOpenHashMap();
    private final Object2ObjectOpenHashMap<String, class_630> cache_JemNameToVanillaModelRoot = new Object2ObjectOpenHashMap();
    private final Object2BooleanOpenHashMap<String> cache_JemNameDoesHaveVariants = new Object2BooleanOpenHashMap<String>(){
        {
            this.defaultReturnValue(false);
        }
    };
    private final Object2BooleanOpenHashMap<UUID> cache_UUIDDoUpdating = new Object2BooleanOpenHashMap<UUID>(){
        {
            this.defaultReturnValue(true);
        }
    };
    private final Object2IntOpenHashMap<UUIDAndMobTypeKey> cache_UUIDAndTypeToCurrentVariantInt = new Object2IntOpenHashMap<UUIDAndMobTypeKey>(){
        {
            this.defaultReturnValue(0);
        }
    };
    public final Object2ObjectOpenHashMap<String, ETFApi.ETFRandomTexturePropertyInstance> cache_mobJemNameToPropertyTester = new Object2ObjectOpenHashMap();
    private boolean traderLlamaHappened = false;

    private EMFManager() {
    }

    public static EMFManager getInstance() {
        if (self == null) {
            self = new EMFManager();
        }
        return self;
    }

    public static void resetInstance() {
        EMFUtils.EMFModMessage("Clearing EMF data.");
        EMFOptiFinePartNameMappings.UNKNOWN_MODEL_MAP_CACHE.clear();
        self = new EMFManager();
    }

    public static class_630 traverseRootForChildOrNull(class_630 root, String nameOfModelToFind) {
        if (root.method_41919(nameOfModelToFind)) {
            return root.method_32086(nameOfModelToFind);
        }
        for (class_630 part : ((ModelPartAccessor)root).getChildren().values()) {
            class_630 found = EMFManager.traverseRootForChildOrNull(part, nameOfModelToFind);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public static String getTypeName(class_1297 entity) {
        Object forReturn = class_7923.field_41177.method_10221((Object)entity.method_5864()).toString().replace("minecraft:", "");
        if (((String)forReturn).contains(":")) {
            forReturn = "modded/" + ((String)forReturn).replaceFirst(":", "/");
        }
        if (entity instanceof class_1454) {
            class_1454 puffer = (class_1454)entity;
            forReturn = "puffer_fish_" + (switch (puffer.method_6594()) {
                case 0 -> "small";
                case 1 -> "medium";
                default -> "big";
            });
        } else if (entity instanceof class_1474) {
            class_1474 fish = (class_1474)entity;
            forReturn = fish.method_47862().method_47867() == class_1474.class_7991.field_41575 ? "tropical_fish_b" : "tropical_fish_a";
        } else if (entity instanceof class_1510) {
            forReturn = "dragon";
        }
        return forReturn;
    }

    @Nullable
    public static EMFJemData getJemData(String jemFileName, String rawMobName) {
        EMFJemData emfJemData = EMFManager.getJemDataWithDirectory("emf/cem/" + jemFileName);
        if (emfJemData != null) {
            return emfJemData;
        }
        emfJemData = EMFManager.getJemDataWithDirectory("emf/cem/" + rawMobName + "/" + jemFileName);
        if (emfJemData != null) {
            return emfJemData;
        }
        emfJemData = EMFManager.getJemDataWithDirectory("optifine/cem/" + jemFileName);
        if (emfJemData != null) {
            return emfJemData;
        }
        emfJemData = EMFManager.getJemDataWithDirectory("optifine/cem/" + rawMobName + "/" + jemFileName);
        return emfJemData;
    }

    @Nullable
    private static EMFJemData getJemDataWithDirectory(String pathOfJem) {
        if (EMFManager.getInstance().cache_JemDataByFileName.containsKey((Object)pathOfJem)) {
            return (EMFJemData)EMFManager.getInstance().cache_JemDataByFileName.get((Object)pathOfJem);
        }
        try {
            Optional res = class_310.method_1551().method_1478().method_14486(new class_2960(pathOfJem));
            if (res.isEmpty()) {
                if (EMFConfig.getConfig().printModelCreationInfoToLog) {
                    EMFUtils.EMFModMessage(".jem read failed " + pathOfJem + " does not exist", false);
                }
                return null;
            }
            if (EMFConfig.getConfig().printModelCreationInfoToLog) {
                EMFUtils.EMFModMessage(".jem read success " + pathOfJem + " exists", false);
            }
            class_3298 jemResource = (class_3298)res.get();
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            BufferedReader reader = new BufferedReader(new InputStreamReader(jemResource.method_14482()));
            EMFJemData jem = (EMFJemData)gson.fromJson((Reader)reader, EMFJemData.class);
            reader.close();
            jem.sendFileName(pathOfJem);
            jem.prepare();
            EMFManager.getInstance().cache_JemDataByFileName.put((Object)pathOfJem, (Object)jem);
            return jem;
        }
        catch (FileNotFoundException | class_151 e) {
            if (EMFConfig.getConfig().printModelCreationInfoToLog) {
                EMFUtils.EMFModMessage(".jem failed to load " + (Exception)e, false);
            }
        }
        catch (Exception e) {
            EMFUtils.EMFModMessage(".jem failed to load " + e, false);
            e.printStackTrace();
        }
        return null;
    }

    public class_630 injectIntoModelRootGetter(class_5601 layer, class_630 root) {
        String jemName;
        EMFJemData jemData;
        boolean printing = EMFConfig.getConfig().printModelCreationInfoToLog;
        Object mobModelName = layer.method_35743().method_12832();
        if (!"main".equals(layer.method_35744())) {
            mobModelName = (String)mobModelName + "_" + layer.method_35744();
        }
        if (!"minecraft".equals(layer.method_35743().method_12836())) {
            mobModelName = "modded/" + layer.method_35743().method_12836() + "/" + (String)mobModelName;
        } else {
            if (((String)mobModelName).contains("pufferfish")) {
                mobModelName = ((String)mobModelName).replace("pufferfish", "puffer_fish");
            }
            switch (mobModelName) {
                case "tropical_fish_large": {
                    mobModelName = "tropical_fish_b";
                    break;
                }
                case "tropical_fish_small": {
                    mobModelName = "tropical_fish_a";
                    break;
                }
                case "tropical_fish_large_pattern": {
                    mobModelName = "tropical_fish_pattern_b";
                    break;
                }
                case "tropical_fish_small_pattern": {
                    mobModelName = "tropical_fish_pattern_a";
                    break;
                }
                case "trader_llama": {
                    this.traderLlamaHappened = true;
                    break;
                }
                case "llama": {
                    this.traderLlamaHappened = false;
                    break;
                }
                case "llama_decor": {
                    mobModelName = this.traderLlamaHappened ? "trader_llama_decor" : "llama_decor";
                    break;
                }
                case "ender_dragon": {
                    mobModelName = "dragon";
                    break;
                }
                case "dragon_skull": {
                    mobModelName = "head_dragon";
                    break;
                }
                case "player_head": {
                    mobModelName = "head_player";
                    break;
                }
                case "skeleton_skull": {
                    mobModelName = "head_skeleton";
                    break;
                }
                case "wither_skeleton_skull": {
                    mobModelName = "head_wither_skeleton";
                    break;
                }
                case "zombie_head": {
                    mobModelName = "head_zombie";
                    break;
                }
                case "creeper_head": {
                    mobModelName = "head_creeper";
                    break;
                }
                case "piglin_head": {
                    mobModelName = "head_piglin";
                    break;
                }
                case "creeper_armor": {
                    mobModelName = "creeper_charge";
                    break;
                }
                case "sheep_fur": {
                    mobModelName = "sheep_wool";
                    break;
                }
                default: {
                    if (this.cache_AmountOfMobNameAlreadyDone.containsKey(mobModelName)) {
                        int amount = this.cache_AmountOfMobNameAlreadyDone.getInt(mobModelName);
                        this.cache_AmountOfMobNameAlreadyDone.put(mobModelName, ++amount);
                        String modelVariantAlias = (String)mobModelName + "_" + (Serializable)(amount > 0 && amount < 27 ? String.valueOf((char)(amount + 97 - 1)) : Integer.valueOf(amount));
                        mobModelName = (String)map_MultiMobVariantMap.getOrDefault((Object)modelVariantAlias, (Object)modelVariantAlias);
                        break;
                    }
                    EMFManager.getInstance().cache_AmountOfMobNameAlreadyDone.put(mobModelName, 1);
                }
            }
        }
        if (printing) {
            System.out.println(" > EMF try to find a model for: " + (String)mobModelName);
        }
        if (EMFOptiFinePartNameMappings.getMapOf((String)mobModelName).isEmpty()) {
            EMFOptiFinePartNameMappings.createMapForModdedOrUnknownEntityModel(root, (String)mobModelName);
        }
        if (printing) {
            System.out.println(" >> EMF trying to find: optifine/cem/" + (String)mobModelName + ".jem");
        }
        if ((jemData = EMFManager.getJemData(jemName = (String)mobModelName + ".jem", (String)mobModelName)) != null) {
            EMFModelPartMutable part = this.getEMFRootModelFromJem(jemData, root);
            this.cache_JemNameToCannonModelRoot.put(mobModelName, (Object)part);
            part.setPartAsTopLevelRoot();
            this.cache_JemNameToVanillaModelRoot.put(mobModelName, (Object)root);
            if (class_310.method_1551().method_1478().method_14486(new class_2960("optifine/cem/" + (String)mobModelName + ".properties")).isPresent()) {
                this.cache_JemNameDoesHaveVariants.put(mobModelName, true);
            }
            return part;
        }
        if (printing) {
            System.out.println(" >> EMF mob does not have a .jem file");
        }
        if (printing) {
            System.out.println(" > Vanilla model used for: " + (String)mobModelName);
        }
        return root;
    }

    private EMFModelPartMutable getEMFRootModelFromJem(EMFJemData jemData, class_630 vanillaRoot) {
        return this.getEMFRootModelFromJem(jemData, vanillaRoot, 0);
    }

    private EMFModelPartMutable getEMFRootModelFromJem(EMFJemData jemData, class_630 vanillaRoot, int variantNumber) {
        HashMap<String, class_630> rootChildren = new HashMap<String, class_630>();
        boolean printing = EMFConfig.getConfig().printModelCreationInfoToLog;
        for (EMFPartData partData : jemData.models) {
            if (partData != null && partData.part != null) {
                class_630 oldPart = EMFManager.traverseRootForChildOrNull(vanillaRoot, partData.part);
                EMFModelPartMutable newPart = new EMFModelPartMutable(partData, variantNumber);
                if (oldPart != null) {
                    newPart.applyDefaultModelRotates(oldPart.method_41921());
                    this.iterateChildTransformCopy(newPart, oldPart);
                }
                if (printing) {
                    System.out.println(" >>> EMF part made: " + partData.toString(false));
                }
                rootChildren.put(partData.part, newPart);
                continue;
            }
            System.out.println("no part definition");
        }
        EMFModelPartMutable emfRootModelPart = new EMFModelPartMutable(new ArrayList<class_630.class_628>(), rootChildren, variantNumber, jemData);
        if (printing) {
            System.out.println(" > EMF model returned");
        }
        this.setupAnimationsFromJemToModel(jemData, emfRootModelPart);
        if (vanillaRoot.method_41919("root")) {
            if (!emfRootModelPart.method_41919("root")) {
                class_630 subRoot = vanillaRoot.method_32086("root");
                if (subRoot.field_3657 != 0.0f || subRoot.field_3656 != 0.0f || subRoot.field_3655 != 0.0f || subRoot.field_3654 != 0.0f || subRoot.field_3675 != 0.0f || subRoot.field_3674 != 0.0f || subRoot.field_37938 != 0.0f || subRoot.field_37939 != 0.0f || subRoot.field_37940 != 0.0f) {
                    emfRootModelPart.method_32085(subRoot.method_32084());
                    emfRootModelPart.method_41918(subRoot.method_41921());
                }
                emfRootModelPart = new EMFModelPartMutable(new ArrayList<class_630.class_628>(), Map.of("root", emfRootModelPart), variantNumber, jemData);
            }
        } else if (emfRootModelPart.method_41919("root")) {
            emfRootModelPart = (EMFModelPartMutable)emfRootModelPart.method_32086("root");
        }
        if (EMFConfig.getConfig().attemptToCopyVanillaModelIntoMissingModelPart) {
            emfRootModelPart.mergeInVanillaWhereRequired(vanillaRoot);
        }
        return emfRootModelPart;
    }

    private void iterateChildTransformCopy(EMFModelPartMutable newPart, class_630 oldPart) {
        for (String emfChildId : newPart.getChildrenEMF().keySet()) {
            if (!oldPart.method_41919(emfChildId)) continue;
            EMFModelPartMutable newNewPart = (EMFModelPartMutable)newPart.getChildrenEMF().get(emfChildId);
            class_630 oldOldPart = oldPart.method_32086(emfChildId);
            newNewPart.applyDefaultModelRotates(oldOldPart.method_41921());
            this.iterateChildTransformCopy(newNewPart, oldOldPart);
        }
    }

    private void setupAnimationsFromJemToModel(EMFJemData jemData, EMFModelPartMutable emfRootModelPart) {
        boolean printing = EMFConfig.getConfig().printModelCreationInfoToLog;
        Object2ObjectOpenHashMap allPartByName = new Object2ObjectOpenHashMap();
        allPartByName.put((Object)"root", (Object)emfRootModelPart);
        allPartByName.putAll(emfRootModelPart.getAllChildPartsAsMap());
        Object2ObjectLinkedOpenHashMap emfAnimations = new Object2ObjectLinkedOpenHashMap();
        EMFAnimationVariableSuppliers variableSuppliers = new EMFAnimationVariableSuppliers();
        if (printing) {
            System.out.println(" > finalAnimationsForModel =");
            jemData.finalAnimationsForModel.forEach((key, expression) -> System.out.println(" >> " + key + " = " + expression));
        }
        jemData.finalAnimationsForModel.forEach((animKey, animationExpression) -> {
            if (EMFConfig.getConfig().printModelCreationInfoToLog) {
                EMFUtils.EMFModMessage("parsing animation value: [" + animKey + "]");
            }
            String modelId = animKey.split("\\.")[0];
            String modelVariable = animKey.split("\\.")[1];
            EMFDefaultModelVariable thisVariable = EMFDefaultModelVariable.get(modelVariable);
            EMFModelPartMutable thisPart = (EMFModelPartMutable)((Object)((Object)allPartByName.get((Object)modelId)));
            EMFAnimation thisCalculator = thisPart != null ? new EMFAnimation(thisPart, thisVariable, (String)animKey, (String)animationExpression, jemData.fileName, variableSuppliers) : new EMFAnimation(null, null, (String)animKey, (String)animationExpression, jemData.fileName, variableSuppliers);
            emfAnimations.put(animKey, (Object)thisCalculator);
        });
        LinkedList<EMFAnimation> orderedAnimations = new LinkedList<EMFAnimation>();
        emfAnimations.forEach((key, anim) -> {
            if (anim != null) {
                anim.initExpression((Object2ObjectLinkedOpenHashMap<String, EMFAnimation>)emfAnimations, (Object2ObjectOpenHashMap<String, EMFModelPartMutable>)allPartByName);
                if (anim.isValid()) {
                    orderedAnimations.add((EMFAnimation)anim);
                } else {
                    EMFUtils.EMFModWarn("animations was invalid: " + anim.animKey + " = " + anim.expressionString);
                }
            }
        });
        EMFAnimationExecutor executor = new EMFAnimationExecutor(variableSuppliers, orderedAnimations);
        this.cache_EntityNameToAnimationExecutable.put((Object)jemData.mobName, (Object)executor);
    }

    public void preRenderEMFActions(String modelName, class_1297 entity, class_4597 provider, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        EMFModelPartMutable.currentlyHeldProvider = provider;
        EMFModelPartMutable.currentlyHeldEntity = entity;
        int suffix = this.cache_UUIDAndTypeToCurrentVariantInt.getInt((Object)new UUIDAndMobTypeKey(entity.method_5667(), entity.method_5864()));
        if (suffix > 1) {
            modelName = (String)modelName + suffix;
        }
        if (this.cache_EntityNameToAnimationExecutable.containsKey(modelName)) {
            ((EMFAnimationExecutor)this.cache_EntityNameToAnimationExecutable.get(modelName)).executeAnimations(entity, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
        }
    }

    public void preRenderEMFActions(class_1297 entity, class_4597 provider, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
        String mobName = EMFManager.getTypeName(entity);
        this.preRenderEMFActions(mobName, entity, provider, limbAngle, limbDistance, animationProgress, headYaw, headPitch);
    }

    @Nullable
    public class_2960 getRootModelTextureOverride(String modelId) {
        EMFModelPartMutable modelRoot = (EMFModelPartMutable)((Object)this.cache_JemNameToCannonModelRoot.get((Object)modelId));
        if (modelRoot != null) {
            return modelRoot.textureOverride;
        }
        return null;
    }

    public void doVariantCheckFor(String mobName, class_1297 entity) {
        if (this.cache_JemNameDoesHaveVariants.getBoolean((Object)mobName) && this.cache_UUIDDoUpdating.getBoolean((Object)entity.method_5667()) && ETFApi.getETFConfigObject().textureUpdateFrequency_V2 != ETFConfig.UpdateFrequency.Never) {
            UUIDAndMobTypeKey key = new UUIDAndMobTypeKey(entity.method_5667(), entity.method_5864());
            long randomizer = (long)ETFApi.getETFConfigObject().textureUpdateFrequency_V2.getDelay() * 20L;
            if (System.currentTimeMillis() % randomizer == (long)Math.abs(entity.method_5667().hashCode()) % randomizer) {
                ETFApi.ETFRandomTexturePropertyInstance emfProperty;
                if (!this.cache_mobJemNameToPropertyTester.containsKey((Object)mobName)) {
                    class_2960 propertyID = new class_2960("optifine/cem/" + mobName + ".properties");
                    if (class_310.method_1551().method_1478().method_14486(propertyID).isPresent()) {
                        ETFApi.ETFRandomTexturePropertyInstance emfTester = ETFApi.readRandomPropertiesFileAndReturnTestingObject2((class_2960)propertyID, (String)"models");
                        this.cache_mobJemNameToPropertyTester.put((Object)mobName, (Object)emfTester);
                    } else {
                        EMFUtils.EMFModWarn("no property" + propertyID);
                        this.cache_JemNameDoesHaveVariants.put((Object)mobName, false);
                        return;
                    }
                }
                if ((emfProperty = (ETFApi.ETFRandomTexturePropertyInstance)this.cache_mobJemNameToPropertyTester.get((Object)mobName)) != null) {
                    int suffix = emfProperty.getSuffixForEntity(entity, this.cache_UUIDDoUpdating.containsKey((Object)entity.method_5667()), this.cache_UUIDDoUpdating);
                    EMFModelPartMutable cannonicalRoot = (EMFModelPartMutable)((Object)this.cache_JemNameToCannonModelRoot.get((Object)mobName));
                    if (suffix > 1) {
                        if (!cannonicalRoot.allKnownStateVariants.containsKey(suffix)) {
                            String jemName = mobName + suffix + ".jem";
                            System.out.println(" >> first time load of : " + jemName);
                            EMFJemData jemData = EMFManager.getJemData(jemName, mobName);
                            if (jemData != null) {
                                class_630 vanillaRoot = (class_630)this.cache_JemNameToVanillaModelRoot.get((Object)mobName);
                                if (vanillaRoot != null) {
                                    EMFModelPartMutable variantRoot = this.getEMFRootModelFromJem(jemData, vanillaRoot, suffix);
                                    cannonicalRoot.mergePartVariant(suffix, variantRoot);
                                    this.setupAnimationsFromJemToModel(jemData, cannonicalRoot);
                                }
                            } else {
                                System.out.println("invalid jem: " + jemName);
                            }
                        }
                        cannonicalRoot.setVariantStateTo(suffix);
                        this.cache_UUIDAndTypeToCurrentVariantInt.put((Object)key, suffix);
                    } else {
                        cannonicalRoot.setVariantStateTo(0);
                        this.cache_UUIDAndTypeToCurrentVariantInt.put((Object)key, 0);
                    }
                }
            } else {
                EMFModelPartMutable cannonicalRoot = (EMFModelPartMutable)((Object)this.cache_JemNameToCannonModelRoot.get((Object)mobName));
                cannonicalRoot.setVariantStateTo(this.cache_UUIDAndTypeToCurrentVariantInt.getInt((Object)key));
            }
        }
    }

    public void tryRenderVanillaRoot(String modelId, class_4587 matrixStack, class_4588 vertexConsumer, int light, int overlay) {
        class_630 vanillaRoot = (class_630)this.cache_JemNameToVanillaModelRoot.get((Object)modelId);
        if (vanillaRoot != null) {
            matrixStack.method_22903();
            if (EMFConfig.getConfig().vanillaModelRenderMode == EMFConfig.VanillaModelRenderMode.Positon_offset) {
                matrixStack.method_46416(1.0f, 0.0f, 0.0f);
            }
            vanillaRoot.method_22699(matrixStack, vertexConsumer, light, overlay, 1.0f, 0.5f, 0.5f, 0.5f);
            matrixStack.method_22909();
        }
    }

    public static class EMFAnimationExecutor {
        private final EMFAnimationVariableSuppliers variableSuppliers;
        private final LinkedList<EMFAnimation> orderedAnimations;

        EMFAnimationExecutor(EMFAnimationVariableSuppliers variableSuppliers, LinkedList<EMFAnimation> orderedAnimations) {
            this.variableSuppliers = variableSuppliers;
            this.orderedAnimations = orderedAnimations;
        }

        public void executeAnimations(class_1297 entity, float limbAngle, float limbDistance, float animationProgress, float headYaw, float headPitch) {
            if (headYaw >= 180.0f || headYaw <= -180.0f) {
                boolean isNegative = headYaw < 0.0f;
                float newHeadYaw = Math.abs(headYaw) % 360.0f;
                if (newHeadYaw >= 180.0f) {
                    newHeadYaw = 180.0f - (newHeadYaw - 180.0f);
                    isNegative = !isNegative;
                }
                headYaw = isNegative ? -newHeadYaw : newHeadYaw;
            }
            this.variableSuppliers.entity = entity;
            this.variableSuppliers.limbAngle = limbAngle;
            this.variableSuppliers.limbDistance = limbDistance;
            this.variableSuppliers.headYaw = headYaw;
            this.variableSuppliers.headPitch = headPitch;
            this.variableSuppliers.tickDelta = class_310.method_1551().method_1493() ? ((MinecraftClientAccessor)class_310.method_1551()).getPausedTickDelta() : class_310.method_1551().method_1488();
            this.variableSuppliers.animationProgress = this.alterAnimationProgress(animationProgress);
            for (EMFAnimation animation : this.orderedAnimations) {
                animation.calculateAndSet(this.variableSuppliers.entity);
            }
        }

        private float alterAnimationProgress(float animationProgress) {
            if (this.variableSuppliers.entity == null) {
                return animationProgress;
            }
            return (float)this.variableSuppliers.entity.field_6012 + this.variableSuppliers.tickDelta;
        }
    }

    private record UUIDAndMobTypeKey(UUID uuid, class_1299<?> entityType) {
    }
}

