/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import java.util.function.Supplier;
import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.pipeline.ShadowRenderer;
import net.coderbot.iris.shaderpack.PackDirectives;
import net.coderbot.iris.shadows.ShadowMatrices;
import net.coderbot.iris.uniforms.CapturedRenderingState;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;

public final class MatrixUniforms {
    private MatrixUniforms() {
    }

    public static void addMatrixUniforms(UniformHolder uniformHolder, PackDirectives packDirectives) {
        MatrixUniforms.addMatrix(uniformHolder, "ModelView", CapturedRenderingState.INSTANCE::getGbufferModelView);
        MatrixUniforms.addMatrix(uniformHolder, "Projection", CapturedRenderingState.INSTANCE::getGbufferProjection);
        MatrixUniforms.addShadowMatrix(uniformHolder, "ModelView", () -> new Matrix4f((Matrix4fc)ShadowRenderer.createShadowModelView(packDirectives.getSunPathRotation(), packDirectives.getShadowDirectives().getIntervalSize()).method_23760().method_23761()));
        MatrixUniforms.addShadowMatrix(uniformHolder, "Projection", () -> ShadowMatrices.createOrthoMatrix(packDirectives.getShadowDirectives().getDistance()));
    }

    private static void addMatrix(UniformHolder uniformHolder, String string, Supplier<Matrix4f> supplier) {
        uniformHolder.uniformMatrix(UniformUpdateFrequency.PER_FRAME, "gbuffer" + string, supplier).uniformMatrix(UniformUpdateFrequency.PER_FRAME, "gbuffer" + string + "Inverse", new Inverted(supplier)).uniformMatrix(UniformUpdateFrequency.PER_FRAME, "gbufferPrevious" + string, new Previous(supplier));
    }

    private static void addShadowMatrix(UniformHolder uniformHolder, String string, Supplier<Matrix4f> supplier) {
        uniformHolder.uniformMatrix(UniformUpdateFrequency.PER_FRAME, "shadow" + string, supplier).uniformMatrix(UniformUpdateFrequency.PER_FRAME, "shadow" + string + "Inverse", new Inverted(supplier));
    }

    private static class Inverted
    implements Supplier<Matrix4f> {
        private final Supplier<Matrix4f> parent;

        Inverted(Supplier<Matrix4f> supplier) {
            this.parent = supplier;
        }

        @Override
        public Matrix4f get() {
            Matrix4f matrix4f = new Matrix4f((Matrix4fc)this.parent.get());
            matrix4f.invert();
            return matrix4f;
        }
    }

    private static class Previous
    implements Supplier<Matrix4f> {
        private final Supplier<Matrix4f> parent;
        private Matrix4f previous;

        Previous(Supplier<Matrix4f> supplier) {
            this.parent = supplier;
            this.previous = new Matrix4f();
        }

        @Override
        public Matrix4f get() {
            Matrix4f matrix4f = new Matrix4f((Matrix4fc)this.parent.get());
            Matrix4f matrix4f2 = new Matrix4f((Matrix4fc)this.previous);
            this.previous = matrix4f;
            return matrix4f2;
        }
    }
}

