/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.properties;

import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import it.unimi.dsi.fastutil.ints.Int2IntMap;
import java.util.Properties;
import me.pepperbell.continuity.client.ContinuityClient;
import me.pepperbell.continuity.client.properties.StandardConnectingCTMProperties;
import net.minecraft.class_2960;
import net.minecraft.class_3262;
import net.minecraft.class_3300;

public class CompactConnectingCTMProperties
extends StandardConnectingCTMProperties {
    protected Int2IntMap tileReplacementMap;

    public CompactConnectingCTMProperties(Properties properties, class_2960 id, class_3262 pack, int packPriority, class_3300 resourceManager, String method) {
        super(properties, id, pack, packPriority, resourceManager, method);
    }

    @Override
    public void init() {
        super.init();
        this.parseTileReplacements();
    }

    protected void parseTileReplacements() {
        for (String key : this.properties.stringPropertyNames()) {
            int value;
            int index;
            if (!key.startsWith("ctm.")) continue;
            String indexStr = key.substring(4);
            try {
                index = Integer.parseInt(indexStr);
            }
            catch (NumberFormatException e) {
                continue;
            }
            if (index < 0) continue;
            String valueStr = this.properties.getProperty(key);
            try {
                value = Integer.parseInt(valueStr);
            }
            catch (NumberFormatException e) {
                ContinuityClient.LOGGER.warn("Invalid '" + key + "' value '" + valueStr + "' in file '" + this.id + "' in pack '" + this.packName + "'");
                continue;
            }
            if (value < 0) {
                ContinuityClient.LOGGER.warn("Invalid '" + key + "' value '" + valueStr + "' in file '" + this.id + "' in pack '" + this.packName + "'");
                continue;
            }
            if (this.tileReplacementMap == null) {
                this.tileReplacementMap = new Int2IntArrayMap();
            }
            this.tileReplacementMap.put(index, value);
        }
    }

    public Int2IntMap getTileReplacementMap() {
        return this.tileReplacementMap;
    }
}

