/*
 * Decompiled with CFR 0.152.
 */
package opekope2.optigui.internal;

import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import net.minecraft.class_2960;
import opekope2.filter.Filter;
import opekope2.filter.FirstMatchFilter;
import opekope2.filter.factory.FilterFactory;
import opekope2.filter.factory.FilterFactoryResult;
import opekope2.optigui.interaction.Interaction;
import opekope2.optigui.internal.InitializerKt;
import opekope2.optigui.internal.TextureReplacer;
import opekope2.optigui.internal.filter.IdentifiableFilter;
import opekope2.optigui.internal.filter.factory.ReusableFilterFactoryContext;
import opekope2.optigui.internal.interaction.FilterFactoryStore;
import opekope2.optigui.internal.service.ResourceLoaderService;
import opekope2.optigui.resource.OptiGuiResource;
import opekope2.util.DebugKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\b\u0010\tJ\u001d\u0010\u0006\u001a\u00020\u00052\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00030\u0002H\u0016\u00a2\u0006\u0004\b\u0006\u0010\u0007\u00a8\u0006\n"}, d2={"Lopekope2/optigui/internal/ResourceLoader;", "Lopekope2/optigui/internal/service/ResourceLoaderService;", "", "Lopekope2/optigui/resource/OptiGuiResource;", "resources", "", "loadResources", "(Ljava/util/Set;)V", "<init>", "()V", "optigui"})
public final class ResourceLoader
implements ResourceLoaderService {
    @NotNull
    public static final ResourceLoader INSTANCE = new ResourceLoader();

    private ResourceLoader() {
    }

    @Override
    public void loadResources(@NotNull Set<? extends OptiGuiResource> resources) {
        Intrinsics.checkNotNullParameter(resources, (String)"resources");
        List filters = new ArrayList();
        Set replaceableTextures = new LinkedHashSet();
        ReusableFilterFactoryContext context = new ReusableFilterFactoryContext();
        for (OptiGuiResource optiGuiResource : resources) {
            InitializerKt.getLogger().info("Loading " + optiGuiResource.getId() + " from " + optiGuiResource.getResourcePack());
            context.setResource(optiGuiResource);
            for (Map.Entry<String, Set<FilterFactory>> entry : FilterFactoryStore.INSTANCE.getFilterFactories().entrySet()) {
                String modId = entry.getKey();
                Set<FilterFactory> factories = entry.getValue();
                context.setModId(modId);
                for (FilterFactory factory : factories) {
                    FilterFactoryResult filterFactoryResult;
                    FilterFactoryResult filterFactoryResult2;
                    try {
                        filterFactoryResult2 = factory.createFilter(context);
                    }
                    catch (Exception exception) {
                        InitializerKt.getLogger().warn(modId + " threw an exception while creating filter for " + optiGuiResource.getId() + ".", (Throwable)exception);
                        continue;
                    }
                    if (filterFactoryResult2 == null) continue;
                    Filter<Interaction, class_2960> filter = filterFactoryResult.component1();
                    Set<class_2960> replaceable = filterFactoryResult.component2();
                    filters.add(new IdentifiableFilter(modId, filter, replaceable, optiGuiResource));
                    replaceableTextures.addAll((Collection)replaceable);
                }
            }
        }
        FirstMatchFilter filter = new FirstMatchFilter(filters);
        TextureReplacer.INSTANCE.setFilter$optigui(filter);
        TextureReplacer.INSTANCE.setReplaceableTextures$optigui(replaceableTextures);
        InitializerKt.getLogger().debug("Filter chain loaded on resource reload:\n" + DebugKt.dump(filter));
    }
}

