/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import java.util.List;
import java.util.function.Supplier;
import link.infra.indium.renderer.IndiumRenderer;
import link.infra.indium.renderer.aocalc.AoCalculator;
import link.infra.indium.renderer.mesh.EncodingFormat;
import link.infra.indium.renderer.mesh.MutableQuadViewImpl;
import link.infra.indium.renderer.render.BaseQuadRenderer;
import link.infra.indium.renderer.render.BlockRenderInfo;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.ModelHelper;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.fabricmc.fabric.api.util.TriState;
import net.minecraft.class_1087;
import net.minecraft.class_2350;
import net.minecraft.class_2680;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import org.jetbrains.annotations.Nullable;

public class BaseFallbackConsumer
extends BaseQuadRenderer
implements RenderContext.BakedModelConsumer {
    private static final RenderMaterial MATERIAL_FLAT = IndiumRenderer.INSTANCE.materialFinder().ambientOcclusion(TriState.FALSE).find();
    private static final RenderMaterial MATERIAL_SHADED = IndiumRenderer.INSTANCE.materialFinder().find();
    private final MutableQuadViewImpl editorQuad = new MutableQuadViewImpl(){
        {
            this.data = new int[EncodingFormat.TOTAL_STRIDE];
            this.material(MATERIAL_SHADED);
        }

        public QuadEmitter emit() {
            throw new UnsupportedOperationException("Fallback consumer does not support .emit()");
        }
    };

    BaseFallbackConsumer(BaseQuadRenderer.QuadBufferer bufferer, BlockRenderInfo blockInfo, AoCalculator aoCalc, RenderContext.QuadTransform transform) {
        super(bufferer, blockInfo, aoCalc, transform);
    }

    public void accept(class_1087 bakedModel) {
        this.accept(bakedModel, this.blockInfo.blockState);
    }

    public void accept(class_1087 model, @Nullable class_2680 blockState) {
        Supplier<class_5819> random = this.blockInfo.randomSupplier;
        RenderMaterial defaultMaterial = model.method_4708() ? MATERIAL_SHADED : MATERIAL_FLAT;
        for (int i = 0; i <= 6; ++i) {
            class_2350 cullFace = ModelHelper.faceFromIndex((int)i);
            List quads = model.method_4707(blockState, cullFace, random.get());
            int count = quads.size();
            if (count == 0) continue;
            for (int j = 0; j < count; ++j) {
                class_777 q = (class_777)quads.get(j);
                this.renderQuad(q, cullFace, defaultMaterial);
            }
        }
    }

    private void renderQuad(class_777 quad, class_2350 cullFace, RenderMaterial defaultMaterial) {
        MutableQuadViewImpl editorQuad = this.editorQuad;
        editorQuad.fromVanilla(quad, defaultMaterial, cullFace);
        this.renderQuad(editorQuad, true);
    }
}

