/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import java.util.function.Function;
import link.infra.indium.other.SpriteFinderCache;
import link.infra.indium.renderer.mesh.MutableQuadViewImpl;
import link.infra.indium.renderer.render.BaseQuadRenderer;
import me.jellysquid.mods.sodium.client.render.texture.SpriteUtil;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.minecraft.class_1058;
import net.minecraft.class_1921;
import net.minecraft.class_4588;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public abstract class VertexConsumerQuadBufferer
implements BaseQuadRenderer.QuadBufferer {
    protected final Function<class_1921, class_4588> bufferFunc;
    protected final Vector3f normalVec = new Vector3f();

    protected abstract Matrix4f matrix();

    protected abstract Matrix3f normalMatrix();

    protected abstract int overlay();

    VertexConsumerQuadBufferer(Function<class_1921, class_4588> bufferFunc) {
        this.bufferFunc = bufferFunc;
    }

    @Override
    public void bufferQuad(MutableQuadViewImpl quad, class_1921 renderLayer) {
        VertexConsumerQuadBufferer.bufferQuad(this.bufferFunc.apply(renderLayer), quad, this.matrix(), this.overlay(), this.normalMatrix(), this.normalVec);
    }

    public static void bufferQuad(class_4588 buff, MutableQuadViewImpl quad, Matrix4f matrix, int overlay, Matrix3f normalMatrix, Vector3f normalVec) {
        boolean useNormals = quad.hasVertexNormals();
        if (useNormals) {
            quad.populateMissingNormals();
        } else {
            normalVec.set((Vector3fc)quad.faceNormal());
            normalMatrix.transform(normalVec);
        }
        for (int i = 0; i < 4; ++i) {
            buff.method_22918(matrix, quad.x(i), quad.y(i), quad.z(i));
            int color = quad.color(i);
            buff.method_1336(color & 0xFF, color >> 8 & 0xFF, color >> 16 & 0xFF, color >> 24 & 0xFF);
            buff.method_22913(quad.u(i), quad.v(i));
            buff.method_22922(overlay);
            buff.method_22916(quad.lightmap(i));
            if (useNormals) {
                normalVec.set(quad.normalX(i), quad.normalY(i), quad.normalZ(i));
                normalMatrix.transform(normalVec);
            }
            buff.method_22914(normalVec.x(), normalVec.y(), normalVec.z());
            buff.method_1344();
        }
        class_1058 sprite = quad.cachedSprite();
        if (sprite == null) {
            sprite = SpriteFinderCache.forBlockAtlas().find((QuadView)quad);
        }
        SpriteUtil.markSpriteActive((class_1058)sprite);
    }
}

