/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.api;

import java.text.DecimalFormat;
import mcp.mobius.waila.api.__internal__.IApiService;
import net.minecraft.class_2960;

public final class WailaHelper {
    public static final class_2960 GUI_ICONS_TEXTURE = IApiService.INSTANCE.getGuiIconsTexture();
    private static final DecimalFormat SUFFIXED_FORMAT = new DecimalFormat("0.##");

    public static String suffix(long value) {
        if (value == Long.MIN_VALUE) {
            return WailaHelper.suffix(-9223372036854775807L);
        }
        if (value < 0L) {
            return "-" + WailaHelper.suffix(-value);
        }
        if (value < 1000L) {
            return Long.toString(value);
        }
        int exp = (int)(Math.log(value) / Math.log(1000.0));
        return SUFFIXED_FORMAT.format((double)value / Math.pow(1000.0, exp)) + "KMGTPE".charAt(exp - 1);
    }

    public static int getAlpha(int argb) {
        return argb >> 24 & 0xFF;
    }

    public static int getRed(int rgb) {
        return rgb >> 16 & 0xFF;
    }

    public static int getGreen(int rgb) {
        return rgb >> 8 & 0xFF;
    }

    public static int getBlue(int rgb) {
        return rgb & 0xFF;
    }

    public static double getLuminance(int rgb) {
        return (0.299 * (double)WailaHelper.getRed(rgb) + 0.587 * (double)WailaHelper.getGreen(rgb) + 0.114 * (double)WailaHelper.getBlue(rgb)) / 255.0;
    }

    private WailaHelper() {
        throw new UnsupportedOperationException();
    }
}

