/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.command;

import com.google.common.base.Preconditions;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Predicate;

public class ArgumentBuilderBuilder<S> {
    private final LiteralArgumentBuilder<S> root;
    private final Deque<ArgumentBuilder<S, ?>> deque = new ArrayDeque();

    public ArgumentBuilderBuilder(LiteralArgumentBuilder<S> root) {
        this.root = root;
        this.deque.push((ArgumentBuilder<S, ?>)root);
    }

    public ArgumentBuilderBuilder<S> then(ArgumentBuilder<S, ?> builder) {
        this.deque.push(builder);
        return this;
    }

    public ArgumentBuilderBuilder<S> suggests(SuggestionProvider<S> provider) {
        Preconditions.checkState((boolean)(this.deque.peek() instanceof RequiredArgumentBuilder), (Object)"not a RequiredArgumentBuilder");
        ((RequiredArgumentBuilder)this.deque.peek()).suggests(provider);
        return this;
    }

    public ArgumentBuilderBuilder<S> executes(Command<S> command) {
        this.assertNonRoot();
        this.deque.peek().executes(command);
        return this;
    }

    public ArgumentBuilderBuilder<S> requires(Predicate<S> requirement) {
        this.deque.peek().requires(requirement);
        return this;
    }

    public ArgumentBuilderBuilder<S> pop(String ... names) {
        Preconditions.checkArgument((names.length > 0 ? 1 : 0) != 0, (Object)"names == 0");
        for (String name : names) {
            this.assertNonRoot();
            ArgumentBuilder<S, ?> last = this.deque.peek();
            if (last instanceof LiteralArgumentBuilder) {
                LiteralArgumentBuilder literal = (LiteralArgumentBuilder)last;
                Preconditions.checkArgument((boolean)literal.getLiteral().equals(name), (Object)"literal != name");
            } else if (last instanceof RequiredArgumentBuilder) {
                RequiredArgumentBuilder required = (RequiredArgumentBuilder)last;
                Preconditions.checkArgument((boolean)required.getName().equals(name), (Object)"required != name");
            }
            this.deque.pop();
            this.deque.peek().then(last);
        }
        return this;
    }

    public void register(CommandDispatcher<S> dispatcher) {
        Preconditions.checkState((this.deque.peek() == this.root ? 1 : 0) != 0, (Object)"last != root");
        dispatcher.register(this.root);
    }

    private void assertNonRoot() {
        Preconditions.checkState((this.deque.peek() != this.root ? 1 : 0) != 0, (Object)"last == root");
    }
}

