/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import com.google.gson.JsonArray;
import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import java.util.LinkedHashSet;
import java.util.Set;
import mcp.mobius.waila.api.IBlacklistConfig;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_7923;

public class BlacklistConfig
implements IBlacklistConfig {
    public static final int VERSION = 0;
    private int configVersion = 0;
    public int[] pluginHash = new int[]{0, 0, 0};
    public final transient LinkedHashSet<class_2248> blocks = new LinkedHashSet();
    public final transient LinkedHashSet<class_2591<?>> blockEntityTypes = new LinkedHashSet();
    public final transient LinkedHashSet<class_1299<?>> entityTypes = new LinkedHashSet();
    public final LinkedHashSet<class_2960> blockIds = new LinkedHashSet();
    public final LinkedHashSet<class_2960> blockEntityTypeIds = new LinkedHashSet();
    public final LinkedHashSet<class_2960> entityTypeIds = new LinkedHashSet();

    public int getConfigVersion() {
        return this.configVersion;
    }

    public void setConfigVersion(int configVersion) {
        this.configVersion = configVersion;
    }

    @Override
    public boolean contains(class_2248 block) {
        return this.blocks.contains(block);
    }

    @Override
    public boolean contains(class_2586 blockEntity) {
        return this.blockEntityTypes.contains(blockEntity.method_11017());
    }

    @Override
    public boolean contains(class_1297 entity) {
        return this.entityTypes.contains(entity.method_5864());
    }

    public static class Adapter
    implements JsonSerializer<BlacklistConfig>,
    JsonDeserializer<BlacklistConfig> {
        private <T> void serialize(JsonObject object, String key, class_2378<T> registry, Set<class_2960> rlSet, Set<T> tSet) {
            JsonArray array = new JsonArray();
            for (T t : tSet) {
                rlSet.add(registry.method_10221(t));
            }
            for (class_2960 rl : rlSet) {
                array.add(rl.toString());
            }
            object.add(key, (JsonElement)array);
        }

        private <T> void deserialize(JsonObject object, String key, class_2378<T> registry, Set<class_2960> rlSet, Set<T> tSet) {
            JsonArray array = object.getAsJsonArray(key);
            for (JsonElement element : array) {
                class_2960 rl = new class_2960(element.getAsString());
                rlSet.add(rl);
                registry.method_17966(rl).ifPresent(tSet::add);
            }
        }

        public JsonElement serialize(BlacklistConfig src, Type typeOfSrc, JsonSerializationContext context) {
            JsonObject object = new JsonObject();
            JsonArray comment = new JsonArray();
            comment.add("On the SERVER, changes will be applied after the server is restarted");
            comment.add("On the CLIENT, changes will be applied after player quit and rejoin a world");
            object.add("_comment", (JsonElement)comment);
            this.serialize(object, "blocks", (class_2378)class_7923.field_41175, (Set<class_2960>)src.blockIds, (Set)src.blocks);
            this.serialize(object, "blockEntityTypes", class_7923.field_41181, src.blockEntityTypeIds, src.blockEntityTypes);
            this.serialize(object, "entityTypes", (class_2378)class_7923.field_41177, (Set<class_2960>)src.entityTypeIds, (Set)src.entityTypes);
            object.addProperty("configVersion", (Number)src.configVersion);
            object.add("pluginHash", context.serialize((Object)src.pluginHash));
            return object;
        }

        public BlacklistConfig deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
            JsonObject object = json.getAsJsonObject();
            BlacklistConfig res = new BlacklistConfig();
            this.deserialize(object, "blocks", (class_2378)class_7923.field_41175, (Set<class_2960>)res.blockIds, (Set)res.blocks);
            this.deserialize(object, "blockEntityTypes", class_7923.field_41181, res.blockEntityTypeIds, res.blockEntityTypes);
            this.deserialize(object, "entityTypes", (class_2378)class_7923.field_41177, (Set<class_2960>)res.entityTypeIds, (Set)res.entityTypes);
            res.configVersion = object.get("configVersion").getAsInt();
            res.pluginHash = (int[])context.deserialize(object.get("pluginHash"), int[].class);
            return res;
        }
    }
}

