/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.config;

import com.google.common.base.Preconditions;
import com.google.gson.JsonPrimitive;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.Function;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class ConfigEntry<T> {
    public static final Type<Boolean> BOOLEAN = new Type<Boolean>((e, d) -> e.getAsBoolean(), JsonPrimitive::new);
    public static final Type<Integer> INTEGER = new Type<Integer>((e, d) -> e.getAsInt(), JsonPrimitive::new);
    public static final Type<Double> DOUBLE = new Type<Double>((e, d) -> e.getAsDouble(), JsonPrimitive::new);
    public static final Type<String> STRING = new Type<String>((e, d) -> e.getAsString(), JsonPrimitive::new);
    public static final Type<Enum<? extends Enum>> ENUM = new Type<Enum>((e, d) -> Enum.valueOf(d.getDeclaringClass(), e.getAsString()), e -> new JsonPrimitive(e.name()));
    private final class_2960 id;
    private final T defaultValue;
    private final T clientOnlyValue;
    private final boolean serverRequired;
    private final boolean merged;
    private final Type<T> type;
    private T serverValue;
    private T localValue;

    private ConfigEntry(class_2960 id, T defaultValue, T clientOnlyValue, boolean serverRequired, boolean merged, Type<T> type) {
        this.id = id;
        this.defaultValue = defaultValue;
        this.localValue = defaultValue;
        this.clientOnlyValue = clientOnlyValue;
        this.serverRequired = serverRequired;
        this.merged = merged;
        this.type = type;
    }

    public Type<T> getType() {
        return this.type;
    }

    public class_2960 getId() {
        return this.id;
    }

    public T getDefaultValue() {
        return this.defaultValue;
    }

    public T getClientOnlyValue() {
        return this.clientOnlyValue;
    }

    public boolean isServerRequired() {
        return this.serverRequired;
    }

    public T getLocalValue() {
        return this.localValue;
    }

    public T getServerValue() {
        return this.serverValue;
    }

    public void setLocalValue(T localValue) {
        this.assertInstance(localValue);
        this.localValue = localValue;
    }

    public void setServerValue(@Nullable T serverValue) {
        if (serverValue != null) {
            this.assertInstance(serverValue);
        }
        this.serverValue = serverValue;
    }

    public T getValue(boolean forceLocal) {
        if (forceLocal) {
            return this.localValue;
        }
        if (this.merged && this.serverValue instanceof Boolean) {
            return (T)Boolean.valueOf(this.serverValue == Boolean.TRUE && this.localValue == Boolean.TRUE);
        }
        return this.serverRequired ? Objects.requireNonNullElse(this.serverValue, this.clientOnlyValue) : this.localValue;
    }

    public boolean blocksClientEdit() {
        if (this.merged && this.serverValue instanceof Boolean) {
            return this.serverValue == Boolean.FALSE;
        }
        return this.serverRequired;
    }

    public boolean isMerged() {
        return this.merged;
    }

    public boolean isSynced() {
        return this.serverRequired || this.merged;
    }

    private void assertInstance(T value) {
        Preconditions.checkArgument((value.getClass() == this.defaultValue.getClass() ? 1 : 0) != 0, (Object)("Tried to assign " + this.defaultValue.getClass() + " with " + value.getClass()));
    }

    public static class Type<T> {
        public final BiFunction<JsonPrimitive, T, T> parser;
        public final Function<T, JsonPrimitive> serializer;

        public Type(BiFunction<JsonPrimitive, T, T> parser, Function<T, JsonPrimitive> serializer) {
            this.parser = parser;
            this.serializer = serializer;
        }

        public ConfigEntry<T> create(class_2960 id, T defaultValue, T clientOnlyValue, boolean serverRequired, boolean merged) {
            return new ConfigEntry<T>(id, defaultValue, clientOnlyValue, serverRequired, merged, this);
        }
    }
}

