/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.waila.plugin.vanilla.provider;

import mcp.mobius.waila.api.IDataProvider;
import mcp.mobius.waila.api.IDataWriter;
import mcp.mobius.waila.api.IEntityAccessor;
import mcp.mobius.waila.api.IEntityComponentProvider;
import mcp.mobius.waila.api.IPluginConfig;
import mcp.mobius.waila.api.IServerAccessor;
import mcp.mobius.waila.api.ITooltip;
import mcp.mobius.waila.api.component.PairComponent;
import mcp.mobius.waila.plugin.vanilla.config.Options;
import net.minecraft.class_1296;
import net.minecraft.class_2487;
import net.minecraft.class_2561;

public enum MobTimerProvider implements IEntityComponentProvider,
IDataProvider<class_1296>
{
    INSTANCE;

    private static final String TIMER = "%02d:%02d";
    private long lastAge;
    private long lastDataSync;

    @Override
    public void appendBody(ITooltip tooltip, IEntityAccessor accessor, IPluginConfig config) {
        class_2487 data = accessor.getData().raw();
        if (data.method_10545("age")) {
            long minutes;
            long seconds;
            if (this.lastDataSync != accessor.getServerDataTime()) {
                this.lastDataSync = accessor.getServerDataTime();
                this.lastAge = data.method_10550("age");
                long delay = (System.currentTimeMillis() - this.lastDataSync) / 50L;
                if (this.lastAge < 0L) {
                    this.lastAge += delay;
                } else if (this.lastAge > 0L) {
                    this.lastAge -= delay;
                }
            }
            if (this.lastAge < 0L && config.getBoolean(Options.TIMER_GROW)) {
                seconds = -this.lastAge / 20L + 1L;
                minutes = seconds / 60L;
                tooltip.addLine(new PairComponent((class_2561)class_2561.method_43471((String)"tooltip.waila.timer.grow"), (class_2561)class_2561.method_43470((String)TIMER.formatted(minutes, seconds -= minutes * 60L))));
            }
            if (this.lastAge > 0L && config.getBoolean(Options.TIMER_BREED)) {
                seconds = this.lastAge / 20L + 1L;
                minutes = seconds / 60L;
                tooltip.addLine(new PairComponent((class_2561)class_2561.method_43471((String)"tooltip.waila.timer.breed"), (class_2561)class_2561.method_43470((String)TIMER.formatted(minutes, seconds -= minutes * 60L))));
            }
            if (this.lastAge < 0L) {
                ++this.lastAge;
            } else if (this.lastAge > 0L) {
                --this.lastAge;
            }
        }
    }

    @Override
    public void appendData(IDataWriter data, IServerAccessor<class_1296> accessor, IPluginConfig config) {
        class_1296 mob = accessor.getTarget();
        data.raw().method_10569("age", mob.method_5618());
    }
}

