/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.paperdoll;

import com.mojang.blaze3d.systems.RenderSystem;
import dev.tr7zw.paperdoll.PaperDollSettings;
import dev.tr7zw.paperdoll.PaperDollShared;
import dev.tr7zw.paperdoll.PlayerAccess;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1695;
import net.minecraft.class_243;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5498;
import net.minecraft.class_7833;
import net.minecraft.class_898;
import org.joml.Quaternionf;
import org.joml.Quaternionfc;

public class PaperDollRenderer {
    private final class_310 mc_instance = class_310.method_1551();
    private final PaperDollShared instance = PaperDollShared.instance;
    private long showTill = 0L;

    public void render(float delta) {
        class_1297 playerEntity;
        if (!this.instance.settings.dollEnabled || this.mc_instance.field_1690.field_1866 || this.mc_instance.field_1687 == null) {
            return;
        }
        int xpos = 0;
        int ypos = 0;
        switch (this.instance.settings.location) {
            case TOP_LEFT: {
                xpos = 25 + this.instance.settings.dollXOffset;
                ypos = 55 + this.instance.settings.dollYOffset;
                break;
            }
            case TOP_RIGHT: {
                xpos = this.mc_instance.method_22683().method_4486() - (25 + this.instance.settings.dollXOffset);
                ypos = 55 + this.instance.settings.dollYOffset;
                break;
            }
            case BOTTOM_LEFT: {
                xpos = 25 + this.instance.settings.dollXOffset;
                ypos = this.mc_instance.method_22683().method_4502() - (55 + this.instance.settings.dollYOffset);
                break;
            }
            case BOTTOM_RIGHT: {
                xpos = this.mc_instance.method_22683().method_4486() - (25 + this.instance.settings.dollXOffset);
                ypos = this.mc_instance.method_22683().method_4502() - (55 + this.instance.settings.dollYOffset);
            }
        }
        int fXpos = xpos;
        int fYpos = ypos;
        int size = 25 + this.instance.settings.dollSize;
        int lookSides = -this.instance.settings.dollLookingSides;
        int lookUpDown = this.instance.settings.dollLookingUpDown;
        Object object = playerEntity = this.mc_instance.method_1560() != null ? this.mc_instance.method_1560() : this.mc_instance.field_1724;
        if (this.instance.settings.autoHide && playerEntity instanceof class_1309) {
            class_1309 livingEntity = (class_1309)playerEntity;
            boolean hide = true;
            if (livingEntity.method_18276() || livingEntity.method_5624() || livingEntity.method_6128() || livingEntity.method_5765() || livingEntity.method_20232()) {
                hide = false;
            }
            if (livingEntity.method_6039() || livingEntity.method_6115() || livingEntity.field_27857 || livingEntity.field_6252 || livingEntity.method_5809() || livingEntity.field_6235 > 0) {
                hide = false;
            }
            if (hide && System.currentTimeMillis() > this.showTill) {
                return;
            }
            if (!hide) {
                this.showTill = System.currentTimeMillis() + 500L;
            }
        }
        if (this.instance.settings.hideInF5 && class_310.method_1551().field_1690.method_31044() != class_5498.field_26664) {
            return;
        }
        if (playerEntity.method_5765()) {
            class_1297 vehicle = playerEntity.method_5668();
            vehicle.method_31748().forEachOrdered(entity -> {
                double yOffset = fYpos;
                if (entity != playerEntity) {
                    yOffset += (playerEntity.method_23318() - entity.method_23318()) * (double)size;
                }
                if (entity instanceof class_1309) {
                    class_1309 living = (class_1309)entity;
                    this.drawLivingEntity(fXpos, yOffset, size, lookSides, lookUpDown, living, delta, this.instance.settings.dollHeadMode == PaperDollSettings.DollHeadMode.LOCKED);
                } else {
                    this.drawEntity(fXpos, yOffset, size, lookSides, lookUpDown, (class_1297)entity, delta, this.instance.settings.dollHeadMode == PaperDollSettings.DollHeadMode.LOCKED);
                }
            });
        } else if (playerEntity instanceof class_1309) {
            class_1309 living = (class_1309)playerEntity;
            this.drawLivingEntity(fXpos, fYpos, size, lookSides, lookUpDown, living, delta, this.instance.settings.dollHeadMode == PaperDollSettings.DollHeadMode.LOCKED);
        } else {
            this.drawEntity(fXpos, fYpos, size, lookSides, lookUpDown, playerEntity, delta, this.instance.settings.dollHeadMode == PaperDollSettings.DollHeadMode.LOCKED);
        }
    }

    private void drawLivingEntity(double xpos, double ypos, int size, float lookSides, float lookUpDown, class_1309 livingEntity, float delta, boolean lockHead) {
        class_1297 class_12972;
        class_1297 class_12973;
        float rotationSide = (float)Math.atan(lookSides / 40.0f);
        float rotationUp = (float)Math.atan(lookUpDown / 40.0f);
        class_4587 poseStack = RenderSystem.getModelViewStack();
        poseStack.method_22903();
        if (livingEntity.method_6128() || livingEntity.method_6123()) {
            ypos -= (double)((90.0f + livingEntity.field_6004) / 90.0f * (float)size - 5.0f);
        }
        poseStack.method_22904(xpos, ypos, 1050.0);
        poseStack.method_22905(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 matrixStack = new class_4587();
        matrixStack.method_22904(0.0, 0.0, 1000.0);
        matrixStack.method_22905((float)size, (float)size, (float)size);
        Quaternionf quaternion = class_7833.field_40718.rotationDegrees(180.0f);
        Quaternionf quaternion2 = class_7833.field_40714.rotationDegrees(rotationUp * 20.0f);
        quaternion.mul((Quaternionfc)quaternion2);
        matrixStack.method_22907(quaternion);
        float yBodyRot = livingEntity.field_6283;
        float yRot = livingEntity.method_36454();
        float yRotO = livingEntity.field_5982;
        float yBodyRotO = livingEntity.field_6220;
        float xRot = livingEntity.method_36455();
        float xRotO = livingEntity.field_6004;
        float yHeadRotO = livingEntity.field_6259;
        float yHeadRot = livingEntity.field_6241;
        class_243 deltaMovement = livingEntity.method_18798();
        float vehicleYBodyRot = 0.0f;
        float vehicleYBodyRotO = 0.0f;
        livingEntity.field_6283 = 180.0f + rotationSide * 20.0f;
        livingEntity.method_36456(180.0f + rotationSide * 40.0f);
        livingEntity.field_6220 = livingEntity.field_6283;
        livingEntity.field_5982 = livingEntity.method_36454();
        class_243 lastDeltaMovement = null;
        if (livingEntity instanceof PlayerAccess) {
            PlayerAccess player = (PlayerAccess)livingEntity;
            lastDeltaMovement = player.getLastDelataMovement();
            player.setLastDeletaMovement(class_243.field_1353);
        }
        if (livingEntity.method_5765() && (class_12973 = livingEntity.method_5854()) instanceof class_1309) {
            class_1309 livingVehicle = (class_1309)class_12973;
            vehicleYBodyRot = livingVehicle.field_6283;
            vehicleYBodyRotO = livingVehicle.field_6220;
            livingVehicle.field_6283 = livingEntity.field_6283;
            livingVehicle.field_6220 = livingEntity.field_6220;
        }
        if (livingEntity.method_6128() || livingEntity.method_6123()) {
            livingEntity.method_18799(class_243.field_1353);
        }
        if (lockHead || livingEntity.method_6128() || livingEntity.method_6123()) {
            livingEntity.method_36457(-rotationUp * 20.0f);
            livingEntity.field_6004 = livingEntity.method_36455();
            livingEntity.field_6241 = livingEntity.method_36454();
            livingEntity.field_6259 = livingEntity.method_36454();
        } else if (this.instance.settings.dollHeadMode == PaperDollSettings.DollHeadMode.FREE) {
            livingEntity.field_6241 = 180.0f + rotationSide * 40.0f - (yBodyRot - yHeadRot);
            livingEntity.field_6259 = 180.0f + rotationSide * 40.0f - (yBodyRotO - yHeadRotO);
        } else {
            livingEntity.field_6241 = 180.0f + rotationSide * 40.0f - (yRot - yHeadRot);
            livingEntity.field_6259 = 180.0f + rotationSide * 40.0f - (yRotO - yHeadRotO);
        }
        class_308.method_34742();
        class_898 entityRenderDispatcher = this.mc_instance.method_1561();
        quaternion2.conjugate();
        entityRenderDispatcher.method_24196(quaternion2);
        entityRenderDispatcher.method_3948(false);
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        double offsetX = 0.0;
        double offsetY = 0.0;
        double offsetZ = 0.0;
        if (livingEntity.method_5765()) {
            class_1297 vehicle = livingEntity.method_5854();
            double offsetXTmp = livingEntity.method_23317() - vehicle.method_23317();
            double offsetZTmp = livingEntity.method_23321() - vehicle.method_23321();
            float rotation = vehicle.method_36454() - 180.0f - rotationSide * 20.0f;
            rotation *= (float)Math.PI / 180;
            offsetX += Math.cos(rotation *= -1.0f) * offsetXTmp - Math.sin(rotation) * offsetZTmp;
            offsetZ += Math.sin(rotation) * offsetXTmp + Math.cos(rotation) * offsetZTmp;
        }
        entityRenderDispatcher.method_3954((class_1297)livingEntity, offsetX, offsetY, offsetZ, 0.0f, delta, matrixStack, (class_4597)bufferSource, 0xF000F0);
        bufferSource.method_22993();
        entityRenderDispatcher.method_3948(true);
        if (livingEntity instanceof PlayerAccess) {
            PlayerAccess player = (PlayerAccess)livingEntity;
            player.setLastDeletaMovement(lastDeltaMovement);
        }
        livingEntity.field_6283 = yBodyRot;
        livingEntity.field_6220 = yBodyRotO;
        livingEntity.method_36456(yRot);
        livingEntity.field_5982 = yRotO;
        livingEntity.method_36457(xRot);
        livingEntity.field_6004 = xRotO;
        livingEntity.field_6259 = yHeadRotO;
        livingEntity.field_6241 = yHeadRot;
        livingEntity.method_18799(deltaMovement);
        if (livingEntity.method_5765() && (class_12972 = livingEntity.method_5854()) instanceof class_1309) {
            class_1309 livingVehicle = (class_1309)class_12972;
            livingVehicle.field_6283 = vehicleYBodyRot;
            livingVehicle.field_6220 = vehicleYBodyRotO;
        }
        poseStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
    }

    private void drawEntity(double xpos, double ypos, int size, float lookSides, float lookUpDown, class_1297 entity, float delta, boolean lockHead) {
        float rotationSide = (float)Math.atan(lookSides / 40.0f);
        float rotationUp = (float)Math.atan(lookUpDown / 40.0f);
        class_4587 poseStack = RenderSystem.getModelViewStack();
        poseStack.method_22903();
        if (this.mc_instance.field_1724.method_6128() || this.mc_instance.field_1724.method_6123()) {
            ypos -= (double)((90.0f + entity.field_6004) / 90.0f * (float)size - 5.0f);
        }
        poseStack.method_22904(xpos, ypos, 1050.0);
        poseStack.method_22905(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 matrixStack = new class_4587();
        matrixStack.method_22904(0.0, 0.0, 1000.0);
        matrixStack.method_22905((float)size, (float)size, (float)size);
        Quaternionf quaternion = class_7833.field_40718.rotationDegrees(180.0f);
        Quaternionf quaternion2 = class_7833.field_40714.rotationDegrees(rotationUp * 20.0f);
        quaternion.mul((Quaternionfc)quaternion2);
        matrixStack.method_22907(quaternion);
        float yRot = entity.method_36454();
        float yRotO = entity.field_5982;
        float xRot = entity.method_36455();
        float xRotO = entity.field_6004;
        class_243 vel = entity.method_18798();
        class_243 pos = entity.method_19538();
        double yOld = entity.field_5971;
        entity.method_36456(0.0f);
        entity.field_5982 = entity.method_36454();
        entity.method_18799(class_243.field_1353);
        entity.method_33574(pos.method_1031(0.0, 500.0, 0.0));
        entity.field_5971 += 500.0;
        if (lockHead) {
            entity.method_36457(-rotationUp * 20.0f);
            entity.field_6004 = entity.method_36455();
        }
        class_308.method_34742();
        class_898 entityRenderDispatcher = this.mc_instance.method_1561();
        quaternion2.conjugate();
        entityRenderDispatcher.method_24196(quaternion2);
        entityRenderDispatcher.method_3948(false);
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        float extraRotation = 0.0f;
        if (entity instanceof class_1695) {
            extraRotation += 90.0f;
        }
        entityRenderDispatcher.method_3954(entity, 0.0, 0.0, 0.0, 180.0f + rotationSide * 20.0f + extraRotation, delta, matrixStack, (class_4597)bufferSource, 0xF000F0);
        bufferSource.method_22993();
        entityRenderDispatcher.method_3948(true);
        entity.method_36456(yRot);
        entity.field_5982 = yRotO;
        entity.method_36457(xRot);
        entity.field_6004 = xRotO;
        entity.method_18799(vel);
        entity.method_33574(pos);
        entity.field_5971 = yOld;
        poseStack.method_22909();
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
    }
}

