/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.paperdoll;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.tr7zw.paperdoll.PaperDollRenderer;
import dev.tr7zw.paperdoll.PaperDollSettings;
import dev.tr7zw.paperdoll.config.CustomConfigScreen;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.ArrayList;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_7172;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PaperDollShared {
    public static final Logger LOGGER = LogManager.getLogger((String)"PaperDoll");
    public static PaperDollShared instance;
    private final File settingsFile = new File("config", "paperdoll.json");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public PaperDollSettings settings = new PaperDollSettings();
    public PaperDollRenderer renderer;

    public void init() {
        instance = this;
        LOGGER.info("Loading PaperDoll!");
        this.renderer = new PaperDollRenderer();
        if (this.settingsFile.exists()) {
            try {
                this.settings = (PaperDollSettings)this.gson.fromJson(new String(Files.readAllBytes(this.settingsFile.toPath()), StandardCharsets.UTF_8), PaperDollSettings.class);
            }
            catch (Exception ex) {
                System.out.println("Error while loading config! Creating a new one!");
                ex.printStackTrace();
            }
        }
        if (this.settings == null) {
            this.settings = new PaperDollSettings();
            this.writeSettings();
        }
    }

    public void writeSettings() {
        if (this.settingsFile.exists()) {
            this.settingsFile.delete();
        }
        try {
            Files.write(this.settingsFile.toPath(), this.gson.toJson((Object)this.settings).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public class_437 createConfigScreen(class_437 parent) {
        CustomConfigScreen screen = new CustomConfigScreen(parent, "text.paperdoll.title"){

            @Override
            public void initialize() {
                this.getOptions().method_20406(this.getOnOffOption("text.paperdoll.enabled", () -> PaperDollShared.this.settings.dollEnabled, b -> {
                    PaperDollShared.this.settings.dollEnabled = b;
                }));
                ArrayList<Object> options = new ArrayList<Object>();
                options.add(this.getEnumOption("text.paperdoll.location", PaperDollSettings.PaperDollLocation.class, () -> PaperDollShared.this.settings.location, loc -> {
                    PaperDollShared.this.settings.location = loc;
                }));
                options.add(this.getEnumOption("text.paperdoll.headMode", PaperDollSettings.DollHeadMode.class, () -> PaperDollShared.this.settings.dollHeadMode, mode -> {
                    PaperDollShared.this.settings.dollHeadMode = mode;
                }));
                options.add(this.getIntOption("text.paperdoll.xOffset", -100, 100, () -> PaperDollShared.this.settings.dollXOffset, i -> {
                    PaperDollShared.this.settings.dollXOffset = i;
                }));
                options.add(this.getIntOption("text.paperdoll.yOffset", -100, 100, () -> PaperDollShared.this.settings.dollYOffset, i -> {
                    PaperDollShared.this.settings.dollYOffset = i;
                }));
                options.add(this.getIntOption("text.paperdoll.size", -12, 40, () -> PaperDollShared.this.settings.dollSize, i -> {
                    PaperDollShared.this.settings.dollSize = i;
                }));
                options.add(this.getIntOption("text.paperdoll.lookingSides", -80, 80, () -> PaperDollShared.this.settings.dollLookingSides, i -> {
                    PaperDollShared.this.settings.dollLookingSides = i;
                }));
                options.add(this.getIntOption("text.paperdoll.lookingUpDown", -80, 80, () -> PaperDollShared.this.settings.dollLookingUpDown, i -> {
                    PaperDollShared.this.settings.dollLookingUpDown = i;
                }));
                options.add(this.getOnOffOption("text.paperdoll.autohide", () -> PaperDollShared.this.settings.autoHide, b -> {
                    PaperDollShared.this.settings.autoHide = b;
                }));
                options.add(this.getOnOffOption("text.paperdoll.hideInF5", () -> PaperDollShared.this.settings.hideInF5, b -> {
                    PaperDollShared.this.settings.hideInF5 = b;
                }));
                this.getOptions().method_20408(options.toArray(new class_7172[0]));
            }

            @Override
            public void save() {
                PaperDollShared.this.writeSettings();
            }

            @Override
            public void method_25394(class_332 guiGraphics, int i, int j, float f) {
                super.method_25394(guiGraphics, i, j, f);
                PaperDollShared.this.renderer.render(f);
            }

            @Override
            public void reset() {
                PaperDollShared.this.settings = new PaperDollSettings();
                PaperDollShared.this.writeSettings();
            }
        };
        return screen;
    }
}

