/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import dev.tr7zw.itemswapper.ItemSwapperSharedMod;
import dev.tr7zw.itemswapper.config.CacheServerAddresses;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public final class CacheManager {
    private CacheServerAddresses cache;
    private static final CacheManager INSTANCE = new CacheManager();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final File cacheFile = new File("config", "itemswapper-server-cache.json");

    private CacheManager() {
        if (this.cacheFile.exists()) {
            try {
                this.cache = (CacheServerAddresses)this.gson.fromJson(Files.readString(this.cacheFile.toPath()), CacheServerAddresses.class);
            }
            catch (JsonSyntaxException | IOException exception) {
                ItemSwapperSharedMod.LOGGER.warn("Error while loading config: " + exception.getMessage());
                ItemSwapperSharedMod.LOGGER.warn("A new configuration will be created!");
            }
        }
        if (this.cache == null) {
            this.reset();
        }
    }

    public CacheServerAddresses getCache() {
        return this.cache;
    }

    public static CacheManager getInstance() {
        return INSTANCE;
    }

    public void reset() {
        this.cache = new CacheServerAddresses();
        this.writeConfig();
    }

    public void writeConfig() {
        if (this.cacheFile.exists()) {
            boolean isDeleted = this.cacheFile.delete();
            ItemSwapperSharedMod.LOGGER.debug("Config could be deleted before writing to it: " + isDeleted);
        }
        try {
            Files.writeString(this.cacheFile.toPath(), (CharSequence)this.gson.toJson((Object)this.cache), new OpenOption[0]);
        }
        catch (IOException ioException) {
            ItemSwapperSharedMod.LOGGER.warn(ioException.getMessage());
        }
    }
}

