/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import dev.tr7zw.itemswapper.ItemSwapperSharedMod;
import dev.tr7zw.itemswapper.config.Config;
import dev.tr7zw.itemswapper.config.ConfigUpgrader;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;

public final class ConfigManager {
    private Config config;
    private static final ConfigManager INSTANCE = new ConfigManager();
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    private final File configFile = new File("config", "itemswapper.json");

    private ConfigManager() {
        if (this.configFile.exists()) {
            try {
                this.config = (Config)this.gson.fromJson(Files.readString(this.configFile.toPath()), Config.class);
            }
            catch (JsonSyntaxException | IOException exception) {
                ItemSwapperSharedMod.LOGGER.warn("Error while loading config: " + exception.getMessage());
                ItemSwapperSharedMod.LOGGER.warn("A new configuration will be created!");
            }
        }
        if (this.config == null) {
            this.reset();
        } else if (ConfigUpgrader.upgradeConfig(this.config)) {
            this.writeConfig();
        }
    }

    public Config getConfig() {
        return this.config;
    }

    public static ConfigManager getInstance() {
        return INSTANCE;
    }

    public void reset() {
        this.config = new Config();
        this.writeConfig();
    }

    public void writeConfig() {
        if (this.configFile.exists()) {
            boolean isDeleted = this.configFile.delete();
            ItemSwapperSharedMod.LOGGER.debug("Config could be deleted before writing to it: " + isDeleted);
        }
        try {
            Files.writeString(this.configFile.toPath(), (CharSequence)this.gson.toJson((Object)this.config), new OpenOption[0]);
        }
        catch (IOException ioException) {
            ItemSwapperSharedMod.LOGGER.warn(ioException.getMessage());
        }
    }
}

