/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.manager.itemgroups;

import dev.tr7zw.itemswapper.manager.itemgroups.ItemEntry;
import dev.tr7zw.itemswapper.manager.itemgroups.Shortcut;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class ItemGroup {
    private final class_2960 id;
    private final class_2561 displayName;
    private final class_1792 icon;
    private final int priority;
    private final boolean disableAutoLink;
    private final class_2960 fallbackLink;
    private final class_2960 forcedLink;
    private final ItemEntry[] items;
    private final Set<class_1792> openOnlyItems;
    private final Set<class_1792> ignoreItems;
    private final List<Shortcut> shortcuts;

    private ItemGroup(Builder builder) {
        this.id = builder.id;
        this.displayName = builder.displayName;
        this.icon = builder.icon;
        this.priority = builder.priority;
        this.disableAutoLink = builder.disableAutoLink;
        this.fallbackLink = builder.fallbackLink;
        this.forcedLink = builder.forcedLink;
        this.items = builder.items;
        this.openOnlyItems = builder.openOnlyItems;
        this.ignoreItems = builder.ignoreItems;
        this.shortcuts = builder.shortcuts;
    }

    public class_2960 getId() {
        return this.id;
    }

    public class_2561 getDisplayName() {
        return this.displayName;
    }

    public class_1792 getIcon() {
        return this.icon;
    }

    public int getPriority() {
        return this.priority;
    }

    public class_2960 getFallbackLink() {
        return this.fallbackLink;
    }

    public class_2960 getForcedLink() {
        return this.forcedLink;
    }

    public ItemEntry[] getItems() {
        return this.items;
    }

    public ItemEntry getItem(int id) {
        if (id >= this.items.length) {
            return null;
        }
        return this.items[id];
    }

    public Set<class_1792> getOpenOnlyItems() {
        return this.openOnlyItems;
    }

    public Set<class_1792> getIgnoreItems() {
        return this.ignoreItems;
    }

    public boolean autoLinkDisabled() {
        return this.disableAutoLink;
    }

    public List<Shortcut> getShortcuts() {
        return this.shortcuts;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder {
        private class_2960 id;
        private class_2561 displayName;
        private class_1792 icon;
        private int priority;
        private boolean disableAutoLink;
        private class_2960 fallbackLink;
        private class_2960 forcedLink;
        private ItemEntry[] items;
        private Set<class_1792> openOnlyItems = Collections.emptySet();
        private Set<class_1792> ignoreItems = Collections.emptySet();
        private List<Shortcut> shortcuts = Collections.emptyList();

        private Builder() {
        }

        public Builder withId(class_2960 id) {
            this.id = id;
            return this;
        }

        public Builder withDisplayName(class_2561 displayName) {
            this.displayName = displayName;
            return this;
        }

        public Builder withIcon(class_1792 icon) {
            this.icon = icon;
            return this;
        }

        public Builder withPriority(int priority) {
            this.priority = priority;
            return this;
        }

        public Builder withDisableAutoLink(boolean disableAutoLink) {
            this.disableAutoLink = disableAutoLink;
            return this;
        }

        public Builder withFallbackLink(class_2960 fallbackLink) {
            this.fallbackLink = fallbackLink;
            return this;
        }

        public Builder withForcedLink(class_2960 forcedLink) {
            this.forcedLink = forcedLink;
            return this;
        }

        public Builder withItems(ItemEntry[] items) {
            this.items = items;
            return this;
        }

        public Builder withOpenOnlyItems(Set<class_1792> openOnlyItems) {
            this.openOnlyItems = openOnlyItems;
            return this;
        }

        public Builder withIgnoreItems(Set<class_1792> ignoreItems) {
            this.ignoreItems = ignoreItems;
            return this;
        }

        public Builder withShortcuts(List<Shortcut> shortcuts) {
            this.shortcuts = shortcuts;
            return this;
        }

        public class_2960 getId() {
            return this.id;
        }

        public class_2561 getDisplayName() {
            return this.displayName;
        }

        public int getPriority() {
            return this.priority;
        }

        public boolean isDisableAutoLink() {
            return this.disableAutoLink;
        }

        public class_2960 getFallbackLink() {
            return this.fallbackLink;
        }

        public class_2960 getForcedLink() {
            return this.forcedLink;
        }

        public ItemEntry[] getItems() {
            return this.items;
        }

        public Set<class_1792> getOpenOnlyItems() {
            return this.openOnlyItems;
        }

        public Set<class_1792> getIgnoreItems() {
            return this.ignoreItems;
        }

        public List<Shortcut> getShortcuts() {
            return this.shortcuts;
        }

        public ItemGroup build() {
            return new ItemGroup(this);
        }
    }
}

