/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.itemswapper.overlay.logic;

import dev.tr7zw.itemswapper.ItemSwapperMod;
import dev.tr7zw.itemswapper.ItemSwapperSharedMod;
import dev.tr7zw.itemswapper.api.AvailableSlot;
import dev.tr7zw.itemswapper.api.client.ItemSwapperClientAPI;
import dev.tr7zw.itemswapper.manager.itemgroups.ItemEntry;
import dev.tr7zw.itemswapper.overlay.SwitchItemOverlay;
import dev.tr7zw.itemswapper.overlay.logic.GuiSlot;
import dev.tr7zw.itemswapper.overlay.logic.ItemGridWidget;
import dev.tr7zw.itemswapper.util.ItemUtil;
import dev.tr7zw.itemswapper.util.RenderHelper;
import dev.tr7zw.itemswapper.util.WidgetUtil;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1657;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_2371;
import net.minecraft.class_2960;
import net.minecraft.class_332;

public class InventoryWidget
extends ItemGridWidget {
    private static final class_2960 BACKGROUND_LOCATION = new class_2960("itemswapper", "textures/gui/inventory.png");

    public InventoryWidget(int x, int y) {
        super(x, y);
        WidgetUtil.setupSlots(this.widgetArea, this.slots, 9, 3, false, BACKGROUND_LOCATION);
        this.widgetArea.setBackgroundTextureSizeX(168);
        this.widgetArea.setBackgroundTextureSizeY(60);
    }

    private List<AvailableSlot> getItem(int id) {
        class_2371 items = this.minecraft.field_1724.method_31548().field_7547;
        if (id != -1 && !((class_1799)items.get(id + 9)).method_7960()) {
            return Collections.singletonList(new AvailableSlot(-1, id + 9, (class_1799)items.get(id + 9)));
        }
        return Collections.emptyList();
    }

    @Override
    protected void renderSlot(class_332 graphics, int x, int y, List<Runnable> itemRenderList, GuiSlot guiSlot, boolean overwrideAvailable) {
        List<AvailableSlot> slots = this.getItem(guiSlot.id());
        if (!slots.isEmpty()) {
            itemRenderList.add(() -> RenderHelper.renderSlot(graphics, x + 3, y + 4, (class_1657)this.minecraft.field_1724, ((AvailableSlot)slots.get(0)).item(), 1, RenderHelper.SlotEffect.NONE, ((AvailableSlot)slots.get(0)).amount().get()));
        }
    }

    @Override
    public void onSecondaryClick(SwitchItemOverlay overlay, GuiSlot guiSlot, int xOffset, int yOffset) {
        AvailableSlot slot;
        List<AvailableSlot> slots = this.getItem(guiSlot.id());
        if (!slots.isEmpty() && !(slot = slots.get(0)).item().method_7960()) {
            overlay.openPage(ItemSwapperMod.instance.getItemGroupManager().getNextPage(null, new ItemEntry(slot.item().method_7909(), null), guiSlot.id() + 9));
        }
    }

    @Override
    public boolean onPrimaryClick(SwitchItemOverlay overlay, GuiSlot guiSlot, int xOffset, int yOffset) {
        AvailableSlot slot;
        List<AvailableSlot> slots = this.getItem(guiSlot.id());
        if (!slots.isEmpty() && (slot = slots.get(0)).inventory() == -1) {
            ItemSwapperClientAPI.OnSwap event = this.clientAPI.prepareItemSwapEvent.callEvent(new ItemSwapperClientAPI.OnSwap(slot, new AtomicBoolean()));
            if (event.canceled().get()) {
                return true;
            }
            int hudSlot = ItemUtil.inventorySlotToHudSlot(slot.slot());
            this.minecraft.field_1761.method_2906(this.minecraft.field_1724.field_7498.field_7763, hudSlot, this.minecraft.field_1724.method_31548().field_7545, class_1713.field_7791, (class_1657)this.minecraft.field_1724);
            this.clientAPI.itemSwapSentEvent.callEvent(new ItemSwapperClientAPI.SwapSent(slot));
            ItemSwapperSharedMod.instance.setLastItem(slot.item().method_7909());
            ItemSwapperSharedMod.instance.setLastPage(overlay.getPageHistory().get(overlay.getPageHistory().size() - 1));
            return false;
        }
        return true;
    }

    @Override
    public void renderSelectedSlotName(GuiSlot selected, int yOffset, int maxWidth, boolean overwrideAvailable) {
        List<AvailableSlot> availableSlots = this.getItem(selected.id());
        if (!availableSlots.isEmpty() && !overwrideAvailable) {
            RenderHelper.renderSelectedItemName(ItemUtil.getDisplayname(availableSlots.get(0).item()), availableSlots.get(0).item(), false, yOffset, maxWidth);
        }
    }
}

