/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.clothconfig2.gui.entries;

import java.util.Arrays;
import java.util.Optional;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.Tooltip;
import me.shedaniel.math.Point;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

@Environment(value=EnvType.CLIENT)
public abstract class TooltipListEntry<T>
extends AbstractConfigListEntry<T> {
    @Nullable
    private Supplier<Optional<class_2561[]>> tooltipSupplier;

    @Deprecated
    @ApiStatus.Internal
    public TooltipListEntry(class_2561 fieldName, @Nullable Supplier<Optional<class_2561[]>> tooltipSupplier) {
        this(fieldName, tooltipSupplier, false);
    }

    @Deprecated
    @ApiStatus.Internal
    public TooltipListEntry(class_2561 fieldName, @Nullable Supplier<Optional<class_2561[]>> tooltipSupplier, boolean requiresRestart) {
        super(fieldName, requiresRestart);
        this.tooltipSupplier = tooltipSupplier;
    }

    @Override
    public void render(class_332 graphics, int index, int y, int x, int entryWidth, int entryHeight, int mouseX, int mouseY, boolean isHovered, float delta) {
        Optional<class_2561[]> tooltip;
        super.render(graphics, index, y, x, entryWidth, entryHeight, mouseX, mouseY, isHovered, delta);
        if (this.isMouseInside(mouseX, mouseY, x, y, entryWidth, entryHeight) && (tooltip = this.getTooltip(mouseX, mouseY)).isPresent() && tooltip.get().length > 0) {
            this.addTooltip(Tooltip.of(new Point(mouseX, mouseY), this.postProcessTooltip(tooltip.get())));
        }
    }

    private class_5481[] postProcessTooltip(class_2561[] tooltip) {
        return (class_5481[])Arrays.stream(tooltip).flatMap(component -> class_310.method_1551().field_1772.method_1728((class_5348)component, this.getConfigScreen().field_22789).stream()).toArray(class_5481[]::new);
    }

    public Optional<class_2561[]> getTooltip() {
        if (this.tooltipSupplier != null) {
            return this.tooltipSupplier.get();
        }
        return Optional.empty();
    }

    public Optional<class_2561[]> getTooltip(int mouseX, int mouseY) {
        return this.getTooltip();
    }

    @Nullable
    public Supplier<Optional<class_2561[]>> getTooltipSupplier() {
        return this.tooltipSupplier;
    }

    public void setTooltipSupplier(@Nullable Supplier<Optional<class_2561[]>> tooltipSupplier) {
        this.tooltipSupplier = tooltipSupplier;
    }
}

