/*
 * Decompiled with CFR 0.152.
 */
package me.jellysquid.mods.sodium.client.render.chunk.region;

import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.EnumMap;
import java.util.Map;
import java.util.Set;
import me.jellysquid.mods.sodium.client.SodiumClientMod;
import me.jellysquid.mods.sodium.client.gl.arena.AsyncBufferArena;
import me.jellysquid.mods.sodium.client.gl.arena.GlBufferArena;
import me.jellysquid.mods.sodium.client.gl.arena.SwapBufferArena;
import me.jellysquid.mods.sodium.client.gl.arena.staging.StagingBuffer;
import me.jellysquid.mods.sodium.client.gl.device.CommandList;
import me.jellysquid.mods.sodium.client.gl.tessellation.GlTessellation;
import me.jellysquid.mods.sodium.client.gui.SodiumGameOptions;
import me.jellysquid.mods.sodium.client.render.chunk.RenderSection;
import me.jellysquid.mods.sodium.client.render.chunk.passes.BlockRenderPass;
import me.jellysquid.mods.sodium.client.render.chunk.region.RenderRegionManager;
import me.jellysquid.mods.sodium.client.render.vertex.type.ChunkModelVertexFormats;
import me.jellysquid.mods.sodium.client.util.MathUtil;
import me.jellysquid.mods.sodium.client.util.frustum.Frustum;
import net.minecraft.class_4076;
import org.apache.commons.lang3.Validate;

public class RenderRegion {
    public static final int REGION_WIDTH = 8;
    public static final int REGION_HEIGHT = 4;
    public static final int REGION_LENGTH = 8;
    private static final int REGION_WIDTH_M = 7;
    private static final int REGION_HEIGHT_M = 3;
    private static final int REGION_LENGTH_M = 7;
    private static final int REGION_WIDTH_SH = Integer.bitCount(7);
    private static final int REGION_HEIGHT_SH = Integer.bitCount(3);
    private static final int REGION_LENGTH_SH = Integer.bitCount(7);
    public static final int REGION_SIZE = 256;
    private static final int REGION_EXCESS = 8;
    private final RenderRegionManager manager;
    private final Set<RenderSection> chunks = new ObjectOpenHashSet();
    private RenderRegionArenas arenas;
    private final int x;
    private final int y;
    private final int z;
    private Frustum.Visibility visibility;

    public RenderRegion(RenderRegionManager manager, int x, int y, int z) {
        this.manager = manager;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public static RenderRegion createRegionForChunk(RenderRegionManager manager, int x, int y, int z) {
        return new RenderRegion(manager, x >> REGION_WIDTH_SH, y >> REGION_HEIGHT_SH, z >> REGION_LENGTH_SH);
    }

    public RenderRegionArenas getArenas() {
        return this.arenas;
    }

    public void deleteResources(CommandList commandList) {
        if (this.arenas != null) {
            this.arenas.delete(commandList);
            this.arenas = null;
        }
    }

    public static long getRegionKeyForChunk(int x, int y, int z) {
        return class_4076.method_18685((int)(x >> REGION_WIDTH_SH), (int)(y >> REGION_HEIGHT_SH), (int)(z >> REGION_LENGTH_SH));
    }

    public int getOriginX() {
        return this.x << REGION_WIDTH_SH << 4;
    }

    public int getOriginY() {
        return this.y << REGION_HEIGHT_SH << 4;
    }

    public int getOriginZ() {
        return this.z << REGION_LENGTH_SH << 4;
    }

    public RenderRegionArenas getOrCreateArenas(CommandList commandList) {
        RenderRegionArenas arenas = this.arenas;
        if (arenas == null) {
            this.arenas = arenas = this.manager.createRegionArenas(commandList);
        }
        return arenas;
    }

    public void addChunk(RenderSection chunk) {
        if (!this.chunks.add(chunk)) {
            throw new IllegalStateException("Chunk " + chunk + " is already a member of region " + this);
        }
    }

    public void removeChunk(RenderSection chunk) {
        if (!this.chunks.remove(chunk)) {
            throw new IllegalStateException("Chunk " + chunk + " is not a member of region " + this);
        }
    }

    public boolean isEmpty() {
        return this.chunks.isEmpty();
    }

    public int getChunkCount() {
        return this.chunks.size();
    }

    public void updateVisibility(Frustum frustum) {
        int x = this.getOriginX();
        int y = this.getOriginY();
        int z = this.getOriginZ();
        this.visibility = frustum.testBox(x - 8, y - 8, z - 8, x + 128 + 8, y + 64 + 8, z + 128 + 8);
    }

    public Frustum.Visibility getVisibility() {
        return this.visibility;
    }

    public static int getChunkIndex(int x, int y, int z) {
        return x * 8 * 4 + y * 8 + z;
    }

    static {
        Validate.isTrue((boolean)MathUtil.isPowerOfTwo(8));
        Validate.isTrue((boolean)MathUtil.isPowerOfTwo(4));
        Validate.isTrue((boolean)MathUtil.isPowerOfTwo(8));
    }

    public static class RenderRegionArenas {
        public final GlBufferArena vertexBuffers;
        public final GlBufferArena indexBuffers;
        public final Map<BlockRenderPass, GlTessellation> tessellations = new EnumMap<BlockRenderPass, GlTessellation>(BlockRenderPass.class);

        public RenderRegionArenas(CommandList commandList, StagingBuffer stagingBuffer) {
            int expectedVertexCount = 193536;
            int expectedIndexCount = expectedVertexCount / 4 * 6;
            this.vertexBuffers = RenderRegionArenas.createArena(commandList, expectedVertexCount * ChunkModelVertexFormats.COMPACT.getVertexFormat().getStride(), stagingBuffer);
            this.indexBuffers = RenderRegionArenas.createArena(commandList, expectedIndexCount * 4, stagingBuffer);
        }

        public void delete(CommandList commandList) {
            this.deleteTessellations(commandList);
            this.vertexBuffers.delete(commandList);
            this.indexBuffers.delete(commandList);
        }

        public void deleteTessellations(CommandList commandList) {
            for (GlTessellation tessellation : this.tessellations.values()) {
                commandList.deleteTessellation(tessellation);
            }
            this.tessellations.clear();
        }

        public void setTessellation(BlockRenderPass pass, GlTessellation tessellation) {
            this.tessellations.put(pass, tessellation);
        }

        public GlTessellation getTessellation(BlockRenderPass pass) {
            return this.tessellations.get((Object)pass);
        }

        public boolean isEmpty() {
            return this.vertexBuffers.isEmpty() && this.indexBuffers.isEmpty();
        }

        public long getDeviceUsedMemory() {
            return this.vertexBuffers.getDeviceUsedMemory() + this.indexBuffers.getDeviceUsedMemory();
        }

        public long getDeviceAllocatedMemory() {
            return this.vertexBuffers.getDeviceAllocatedMemory() + this.indexBuffers.getDeviceAllocatedMemory();
        }

        private static GlBufferArena createArena(CommandList commandList, int initialCapacity, StagingBuffer stagingBuffer) {
            return switch (SodiumClientMod.options().advanced.arenaMemoryAllocator) {
                default -> throw new IncompatibleClassChangeError();
                case SodiumGameOptions.ArenaMemoryAllocator.ASYNC -> new AsyncBufferArena(commandList, initialCapacity, stagingBuffer);
                case SodiumGameOptions.ArenaMemoryAllocator.SWAP -> new SwapBufferArena(commandList);
            };
        }
    }
}

