/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.api.common.display;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.InputIngredient;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuSerializationContext;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import me.shedaniel.rei.impl.display.DisplaySpec;
import net.minecraft.class_2960;
import org.jetbrains.annotations.ApiStatus;

public interface Display
extends DisplaySpec {
    public List<EntryIngredient> getInputEntries();

    @Deprecated(forRemoval=true)
    default public List<EntryIngredient> getInputEntries(MenuSerializationContext<?, ?, ?> context, MenuInfo<?, ?> info, boolean fill) {
        return this.getInputEntries();
    }

    default public List<InputIngredient<EntryStack<?>>> getInputIngredients(MenuSerializationContext<?, ?, ?> context, MenuInfo<?, ?> info, boolean fill) {
        return CollectionUtils.mapIndexed(this.getInputEntries(context, info, fill), InputIngredient::of);
    }

    public List<EntryIngredient> getOutputEntries();

    default public List<EntryIngredient> getRequiredEntries() {
        return this.getInputEntries();
    }

    public CategoryIdentifier<?> getCategoryIdentifier();

    default public Optional<class_2960> getDisplayLocation() {
        return Optional.empty();
    }

    @Override
    @ApiStatus.NonExtendable
    default public Display provideInternalDisplay() {
        return this;
    }

    @Override
    @ApiStatus.NonExtendable
    default public Collection<class_2960> provideInternalDisplayIds() {
        Optional<class_2960> location = this.getDisplayLocation();
        if (location.isPresent()) {
            return Collections.singletonList(location.get());
        }
        return Collections.emptyList();
    }
}

