/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.rei.impl.common.transfer;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.ints.IntListIterator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.transfer.RecipeFinder;
import me.shedaniel.rei.api.common.transfer.info.MenuInfo;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoContext;
import me.shedaniel.rei.api.common.transfer.info.MenuInfoRegistry;
import me.shedaniel.rei.api.common.transfer.info.stack.SlotAccessor;
import me.shedaniel.rei.api.common.util.CollectionUtils;
import net.minecraft.class_1263;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_2371;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import org.jetbrains.annotations.Nullable;

public class InputSlotCrafter<T extends class_1703, C extends class_1263, D extends Display>
implements MenuInfoContext<T, class_3222, D> {
    protected CategoryIdentifier<D> category;
    protected T container;
    protected MenuInfo<T, D> menuInfo;
    private Iterable<SlotAccessor> inputStacks;
    private Iterable<SlotAccessor> inventoryStacks;
    private class_3222 player;

    private InputSlotCrafter(CategoryIdentifier<D> category, T container) {
        this.category = category;
        this.container = container;
    }

    public void setMenuInfo(MenuInfo<T, D> menuInfo) {
        this.menuInfo = menuInfo;
    }

    public static <T extends class_1703, C extends class_1263, D extends Display> InputSlotCrafter<T, C, D> start(CategoryIdentifier<D> category, T menu, class_3222 player, class_2487 display, boolean hasShift) {
        InputSlotCrafter<T, C, D> crafter = new InputSlotCrafter<T, C, D>(category, menu);
        MenuInfo<T, D> menuInfo = Objects.requireNonNull(MenuInfoRegistry.getInstance().get(category, menu, crafter, display), "Container Info does not exist on the server!");
        crafter.setMenuInfo(menuInfo);
        crafter.fillInputSlots(player, hasShift);
        return crafter;
    }

    private void fillInputSlots(class_3222 player, boolean hasShift) {
        this.player = player;
        this.inventoryStacks = this.menuInfo.getInventorySlots(this);
        this.inputStacks = this.menuInfo.getInputSlots(this);
        this.cleanInputs();
        RecipeFinder recipeFinder = new RecipeFinder();
        this.menuInfo.getRecipeFinderPopulator().populate(this, recipeFinder);
        class_2371 ingredients = class_2371.method_10211();
        for (List<class_1799> itemStacks : this.menuInfo.getInputs(this, true)) {
            ingredients.add((Object)CollectionUtils.toIngredient(itemStacks));
        }
        if (!recipeFinder.findRecipe((class_2371<class_1856>)ingredients, null)) {
            this.cleanInputs();
            this.menuInfo.markDirty(this);
            throw new NotEnoughMaterialsException();
        }
        this.fillInputSlots(recipeFinder, (class_2371<class_1856>)ingredients, hasShift);
        this.menuInfo.markDirty(this);
    }

    public void alignRecipeToGrid(Iterable<SlotAccessor> inputStacks, Iterator<Integer> recipeItemIds, int craftsAmount) {
        for (SlotAccessor inputStack : inputStacks) {
            if (!recipeItemIds.hasNext()) {
                return;
            }
            this.acceptAlignedInput(recipeItemIds.next(), inputStack, craftsAmount);
        }
    }

    public void acceptAlignedInput(Integer recipeItemId, SlotAccessor inputStack, int craftsAmount) {
        class_1799 toBeTakenStack = RecipeFinder.getStackFromId(recipeItemId);
        if (!toBeTakenStack.method_7960()) {
            for (int i = 0; i < craftsAmount; ++i) {
                this.fillInputSlot(inputStack, toBeTakenStack);
            }
        }
    }

    protected void fillInputSlot(SlotAccessor slot, class_1799 toBeTakenStack) {
        class_1799 takenStack;
        SlotAccessor takenSlot = this.takeInventoryStack(toBeTakenStack);
        if (takenSlot != null && !(takenStack = takenSlot.getItemStack().method_7972()).method_7960()) {
            if (takenStack.method_7947() > 1) {
                takenSlot.takeStack(1);
            } else {
                takenSlot.setItemStack(class_1799.field_8037);
            }
            takenStack.method_7939(1);
            if (slot.getItemStack().method_7960()) {
                slot.setItemStack(takenStack);
            } else {
                slot.getItemStack().method_7933(1);
            }
        }
    }

    protected void fillInputSlots(RecipeFinder recipeFinder, class_2371<class_1856> ingredients, boolean hasShift) {
        int recipeCrafts = recipeFinder.countRecipeCrafts(ingredients, null);
        IntArrayList recipeItemIds = new IntArrayList();
        int amountToFill = hasShift ? recipeCrafts : 1;
        if (recipeFinder.findRecipe(ingredients, (IntList)recipeItemIds, amountToFill)) {
            int finalCraftsAmount = amountToFill;
            IntListIterator intListIterator = recipeItemIds.iterator();
            while (intListIterator.hasNext()) {
                int itemId = (Integer)intListIterator.next();
                finalCraftsAmount = Math.min(finalCraftsAmount, RecipeFinder.getStackFromId(itemId).method_7914());
            }
            if (recipeFinder.findRecipe(ingredients, (IntList)recipeItemIds, finalCraftsAmount)) {
                this.cleanInputs();
                this.alignRecipeToGrid(this.inputStacks, (Iterator<Integer>)recipeItemIds.iterator(), finalCraftsAmount);
            }
        }
    }

    protected void cleanInputs() {
        this.menuInfo.getInputCleanHandler().clean(this);
    }

    @Nullable
    public SlotAccessor takeInventoryStack(class_1799 itemStack) {
        for (SlotAccessor inventoryStack : this.inventoryStacks) {
            class_1799 itemStack1 = inventoryStack.getItemStack();
            if (itemStack1.method_7960() || !InputSlotCrafter.areItemsEqual(itemStack, itemStack1) || itemStack1.method_7986() || itemStack1.method_7942() || itemStack1.method_7938()) continue;
            return inventoryStack;
        }
        return null;
    }

    private static boolean areItemsEqual(class_1799 stack1, class_1799 stack2) {
        return class_1799.method_31577((class_1799)stack1, (class_1799)stack2);
    }

    @Override
    public T getMenu() {
        return this.container;
    }

    @Override
    public class_3222 getPlayerEntity() {
        return this.player;
    }

    @Override
    public D getDisplay() {
        return this.menuInfo.getDisplay();
    }

    @Override
    public CategoryIdentifier<D> getCategoryIdentifier() {
        return this.category;
    }

    public static class NotEnoughMaterialsException
    extends RuntimeException {
    }
}

