#version 420 compatibility

layout(location = 0) out vec4 color;
layout(location = 1) out vec4 rays;

#define Brightnoon
#define AO
#define TAA

/*
const int colortex0Format = RGBA16F;
const int colortex1Format = RGBA16F;
*/

const int shadowMapResolution = 2048; //[1024 1732 2048 3766 4096]
const float noiseTextureResolution = 32;
const float sunPathRotation = -25.0;
const float ambientOcclusionLevel = 0.5; //[0.0 0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]
const float shadowDistance = 128.0; //[128.0 256.0 512.0 1024.0]
const bool shadowHardwareFiltering = true;
const float pi = 3.14159265359;
const float invPi = 1.0 / pi;

const float zenithOffset = 0.0;
const float multiScatterPhase = 0.1;
const float density = 0.7;

const float anisotropicIntensity = 0.0; //Higher numbers result in more anisotropic scattering

const vec3 skyColor = vec3(0.39, 0.57, 1.0) * (1.0 + anisotropicIntensity); //Make sure one of the conponents is never 0.0

#define smooth(x) x*x*(3.0-2.0*x)
#define zenithDensity(x) density / pow(max(x - zenithOffset, 0.35e-2), 0.75)
#define wCaustics
#define cDistThreshold 0.15 //[0.05 0.15 0.25 0.35 0.45 0.55 0.65 0.75]

uniform sampler2DShadow shadowtex0;
uniform sampler2DShadow shadowtex1;
uniform sampler2D shadowcolor0;
uniform sampler2D shadowcolor1;

uniform sampler2D tex;
uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex2;
uniform sampler2D colortex3;
uniform sampler2D colortex4;
uniform sampler2D colortex6;
uniform sampler2D colortex7;
uniform sampler2D colortex10;
uniform sampler2D depthtex1;
uniform sampler2D depthtex0;
uniform sampler2D noisetex;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 shadowModelView;
uniform mat4 shadowModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowProjectionInverse;
uniform mat4 gbufferPreviousModelView;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferProjection;

uniform float viewWidth;
uniform float viewHeight;
uniform float sunAngle;
uniform float far;
uniform float near;
uniform float aspectRatio;
uniform float frameTimeCounter;
uniform float rainStrength;

uniform ivec2 eyeBrightnessSmooth;

uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;
uniform vec3 shadowLightPosition;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 upPosition;
uniform vec3 fogColor;

uniform int isEyeInWater; 
uniform int frameCounter;
uniform int worldTime;

varying vec2 texcoord;

flat in vec3 lightVector;


#include "/lib/pos.glsl"
#include "/lib/poisson.glsl"
#include "/lib/time.glsl"
//#include "/lib/normals.glsl"
mat3 tbnNormalTangent(vec3 normal, vec3 tangent) {
    vec3 bitangent = cross(normal, tangent);
    return mat3(tangent, bitangent, normal);
}

mat3 tbnNormal(vec3 normal) {
    vec3 tangent = normalize(cross(normal, vec3(0, 1, 1)));
    return tbnNormalTangent(normal, tangent);
}

float bayer2(vec2 a){
    a = floor(a);
    return fract( dot(a, vec2(.5, a.y * .75)) );
}

#define bayer4(a)   (bayer2( .5*(a))*.25+bayer2(a))
#define bayer8(a)   (bayer4( .5*(a))*.25+bayer2(a))
#define bayer16(a)  (bayer8( .5*(a))*.25+bayer2(a))
#define bayer32(a)  (bayer16(.5*(a))*.25+bayer2(a))
#define bayer64(a)  (bayer32(.5*(a))*.25+bayer2(a))
#define bayer128(a)  (bayer64(.5*(a))*.25+bayer2(a))

float timeAngle = worldTime/24000.0;
float timeBrightness = max(sin(timeAngle*6.28318530718),0.0);


mat2 getRotationMatrix(in vec2 coord) {
    float rotationAmount = texture(noisetex, coord * vec2(viewWidth / noiseTextureResolution, viewHeight / noiseTextureResolution)).r;
    return mat2(
        cos(rotationAmount), -sin(rotationAmount),
        sin(rotationAmount), cos(rotationAmount)
    );
}

vec3 shadowCoord;
mat2 rotationMatrix = getRotationMatrix(texcoord);

float distx(float dist){
	return (far * (dist - near)) / (dist * (far - near));
}
// #define PCSS_SAMPLE_COUNT 3

// vec3 CircleMap(in float index, in float count) {
//     float goldenAngle = 2.4;
//     return vec3(cos(index * goldenAngle), sin(index * goldenAngle), sin(index*goldenAngle)+cos(index*goldenAngle)) * sqrt(index / count);
// }

// float getPenumbraWidth(in vec3 shadowCoord) {
//     float dFragment = shadowCoord.z; //distance from pixel to light
//     float dBlocker = 0.0; //distance from blocker to light
//     float penumbra = 0.0;
    
//     float shadowMapSample; //duh
//     float numBlockers = 0.0;

//     float lightSize  = 105.0;
//     float searchSize = lightSize / 15.0;
//     float dither = bayer16(gl_FragCoord.xy);
//     #ifdef TAA
//     dither = fract(frameTimeCounter*8.0 + dither);
//     #endif
    
//     for (int i = -PCSS_SAMPLE_COUNT; i < PCSS_SAMPLE_COUNT; i++) {
//         float angle = 2.4 * i + dither * 6.28;
//         vec3 offset = vec3(cos(angle), sin(angle), sin(angle)+cos(angle)) * sqrt((i+dither) / PCSS_SAMPLE_COUNT);
//         vec3 sampleCoord = shadowCoord + (offset * searchSize / (shadowMapResolution));
//         shadowMapSample = texture(shadowtex0, sampleCoord).x;

//         dBlocker += shadowMapSample;
//         numBlockers += 1.0;
//     }

//     if(numBlockers > 0.0) {
// 		dBlocker /= numBlockers;
// 		penumbra = (dFragment - dBlocker) * lightSize;
// 	}

//     return clamp(max(penumbra, 0.5), 0.0, lightSize);
// }

void getShadows(in vec3 shadowCoord, in mat2 rotationMatrix, in bool watermask, out float shadow, out vec3 shadowcolor) {
    shadow = 0.0;         //always initialize these, otherwise you can get weirdness galore, especially on nvidia
    vec4 tempcol = vec4(0.0); //this is for storing the shadowcolor before making it use-ready
    //float shadowDist = getPenumbraWidth(shadowCoord);
        for (int i = 0; i < shadowSamples.length(); i++) {
            vec2 Offset = shadowSamples[i] / shadowMapResolution;
            Offset = rotationMatrix * Offset;
            //Offset *= shadowDist;

            float shadow0sample = texture(shadowtex0, vec3(shadowCoord.xy+Offset, shadowCoord.z)).r;
            float shadow1sample = texture(shadowtex1, vec3(shadowCoord.xy+Offset, shadowCoord.z)).r;
        shadow += shadow1sample;
               bool mask = abs(shadow1sample-shadow0sample)>0.1;
            if (mask) {
                if (isEyeInWater == 0 && texelFetch(colortex2, ivec2(gl_FragCoord.xy),0).x<0.2 && !watermask) tempcol += texture(shadowcolor0, shadowCoord.xy+Offset);
               //if (watermask) tempcol += texture(shadowcolor0, shadowCoord.xy+Offset)*100.0;
            } else tempcol += vec4(1.0, 1.0, 1.0, 0.0);
        }
        tempcol /= shadowSamples.length();
        shadow /= shadowSamples.length();

    shadowcolor = mix(vec3(1.0), tempcol.rgb*tempcol.rgb, sqrt(tempcol.a));
}

float lind(float depth) {
    return (near * far) / (depth * (near - far) + far);
}

// float ld(float depth) {
//    return (2.0 * near) / (far + near - depth * (far - near));
// }

float cdist(vec2 coord) {
	return max(abs(coord.s-0.5),abs(coord.t-0.5))*2.0;
}

vec3 ShadowNDC(vec3 PlayerPos) {
    vec3 shadowView = mat3(shadowModelView)*PlayerPos + shadowModelView[3].xyz;
    return (shadowView*vec3(shadowProjection[0].x, shadowProjection[1].y, shadowProjection[2].z) + shadowProjection[3].xyz) / (shadowView.z * shadowProjection[2].w + shadowProjection[3].w);
}


vec2 distortShadow(vec2 position) {
    vec2 multipliedShadowPos = getMultipliedShadowPos(position);
    float dist = pow(multipliedShadowPos.x*multipliedShadowPos.x + multipliedShadowPos.y*multipliedShadowPos.y, 1.0/4.0);
    float distFac = (1.0 - SHADOW_MAP_BIAS) + dist * SHADOW_MAP_BIAS;
    return position / distFac*0.92;
}

vec3 getVL(float dither, vec3 worldPos, float depth) {

    vec3 vl = vec3(0.0);
    
    #ifdef TAA
    dither    = fract(dither + frameTimeCounter*14.0);
    #endif

    int samples = 64; //also can be named as steps
    vec3 start = vec3(0.,0.,0.); //the position of the camera in player space
    vec3 end = worldPos-cameraPosition; //player space
    vec3 startPos = ShadowNDC(start);
    vec3 endPos = ShadowNDC(end);
    vec3 increment = (endPos-startPos)/samples;
    vec3 currentPos = dither*startPos;
    float shadowCheck = 0.0;
    for(int i = 0; i <samples; i++, currentPos += increment) {
        //if(startPos>endPos) break;
        vec3 shadowSS = vec3(distortShadow(currentPos.xy),currentPos.z*0.2)*0.5+0.5;
        float shadowMapDepth = texture(shadowtex1, shadowSS).x;
        shadowCheck += depth < 1.0 ? float(shadowSS.z > shadowMapDepth) : 0.0;
    }
    return mix(vec3(1.0),vl,shadowCheck/samples);
}

float noise2De(in vec2 coord, in float size, in vec2 offset) {
    coord      *= size;
    coord      += offset;
    coord      /= 64.;
    return texture(noisetex, coord).r*2.0-1.0;
}

float waterH(vec3 wpos) {
    float windAnim = -frameTimeCounter*0.2;
    
    vec2 tick = vec2(windAnim, 0.0);
    vec3 wind = vec3(tick.x, 0.5*windAnim, tick.y);

    vec3 rpos = wpos;
    rpos.y *= 0.0;

    float noise = noise2De(rpos.xz, 0.2, tick);
        noise += noise2De(rpos.xz, 0.6, tick*1.2)*0.5;
        noise += noise2De(rpos.xz, 1.4, tick*1.5)*0.25;
        noise += noise2De(rpos.xz, 1.6, tick*1.9)*0.0125;
	
    return noise * 0.22;
}


float rand(vec2 co, inout float seed) // Canonical one liner
{
	seed++;

    float x = fract(sin(dot(co*seed, vec2(12.9898, 4.1414))) * 43758.5453);

    return x;
}

#ifdef wCaustics
float CalcWaterC(vec3 worldPos, float dither) {
    dither    = fract(dither + frameTimeCounter*4.0);    
	vec3 NWLightvec = vec3(0.0, -1.0, 0.0);
	float detectwVL = min(abs(worldPos.y), 2.0);
	vec3 FRFvec = refract(NWLightvec, vec3(0.0, 1.0, 0.0), 1.0 / 1.8);
	float detectwL = detectwVL / -FRFvec.y;
	vec3 lookupCenter = worldPos.xyz - FRFvec * detectwL;

	int s = 1;
	int c = 0;

	float caustics = 0.0;

	for (int i = -s; i <= s; i++)
	{
		for (int j = -s; j <= s; j++)
		{
			vec2 offset = vec2(i + dither, j + dither) * 0.35;
			vec3 detectlookup = lookupCenter + vec3(offset.x, 0.0, offset.y);
			vec3 wNormal = vec3(waterH(detectlookup));
			vec3 RFvec = refract(NWLightvec, wNormal, 1.0 / 1.3333);
			float rayL = detectwVL / RFvec.y;
			vec3 detectcollision = detectlookup - RFvec * rayL;

			float dist = dot(detectcollision - worldPos, detectcollision - worldPos) * 7.1;

			caustics += 1.0 - clamp(dist / cDistThreshold, 0.0, 1.0);

			c++;
		}
	}

	caustics /= c;

	return pow(caustics/cDistThreshold, 1.0) * 5.0;
}
#endif

#define AOStrength 2.0	//[0.5 0.7 1.0 1.2 1.5 1.7 2.0]
#define AODistance 1.30 //[0.25 0.30 0.35 0.40 0.45 0.50 0.55 0.60 0.65 0.70 0.75 0.80 0.85 0.90 0.95 1.00 1.05 1.10 1.15 1.20 1.25 1.30 1.35 1.40 1.45 1.50 1.55 1.60 1.65 1.70 1.75 1.80 1.85 1.90 1.95 2.00 3.00 4.00 5.00 6.00]

vec2 offsetDist(float x, int s){
	float n = fract(x*1.414)*3.1415;
    return vec2(cos(n),sin(n))*x/s;
}

vec3 hemispherefunction(mat3 normal, vec2 random)
{
    // Uniform hemisphere sampling
    float cosTheta = sqrt(random.x);
  float sinTheta = sqrt(1.0 - cosTheta * cosTheta);
  float phi = 2.0 * 3.14 * random.y;
  vec3 tangentSpaceDir = vec3(cos(phi) * sinTheta, sin(phi) * sinTheta, cosTheta);
  // Transform direction to world space
  return normal * tangentSpaceDir;
}


float ssao(float dither, vec3 normal, vec3 fragpos) {
	float ao = 0.0;
	//dither = fract(frameTimeCounter * 4.0 + dither);
	int s = 5;
	mat3 tbnormal = tbnNormal(normal);
	float radius = 0.9;
	float seed = 0.1;
	float seed2 = 0.2;
    //#ifdef TAA
    //dither = fract(frameTimeCounter * 15.0 + dither);
    //#endif
	for(int i = 0; i < s; i++) {
		float r1 = rand(gl_FragCoord.xy, seed);
		float r2 = rand(gl_FragCoord.xy, seed2);
		#ifdef TAA
		r1 = fract(frameTimeCounter * 15.0 + r1);
		r2 = fract(frameTimeCounter * 15.0 + r2);
		#endif
		vec3 direction = hemispherefunction(tbnormal, vec2(r1,r2));
		vec3 spos = fragpos + radius*direction;
		vec4 offset = vec4(spos, 1.0);
        offset      = gbufferProjection * offset; 
        offset.xyz /= offset.w;
        offset.xyz  = offset.xyz * 0.5 + 0.5;
		float sdepth = texture(depthtex0, offset.xy).x;
		float rc = smoothstep(0.0, 1.0, radius / abs(fragpos.z - sdepth));
		if(offset.z < sdepth) {
			ao += 1;
		}
	}
		ao = (ao / s);
	return ao;
}


vec3 lightingCalculation(in vec4 scolor, in float depth, in bool waterm, in bool glass, in bool ice, in vec3 fragpos, vec3 belowdepth) {
        float shadow;
        vec3 shadowcolor;
        getShadows(shadowCoord, rotationMatrix, waterm, shadow, shadowcolor);
        vec3 normalMap = texelFetch(colortex1, ivec2(gl_FragCoord.xy),0).xyz*2.0-1.0;
        float Diffuse = max(dot(normalMap, normalize(shadowLightPosition)), 0.0);
        #ifdef wCaustics
        if (waterm && isEyeInWater == 0) {
            shadow *= max(CalcWaterC(belowdepth, bayer8(gl_FragCoord.xy)),0.5);
        } else if (!waterm && isEyeInWater == 1) {
            shadow *= CalcWaterC(belowdepth, bayer8(gl_FragCoord.xy));
        }
        #endif
        if(!waterm) shadow = min(Diffuse, shadow);
        vec3 nightLight = vec3(0.1);
        vec3 nightAmbient = vec3(0.2); 
        vec3 shadowLight = vec3((vec3(0.9, 0.49, 0.1)*2.5)*times.sunrise + vec3(2.8)*times.noon + (vec3(0.9, 0.49, 0.1)*2.5)*times.sunset + nightLight*times.night);
        float torchTex = texelFetch(colortex2, ivec2(gl_FragCoord.xy),0).r*texelFetch(colortex2, ivec2(gl_FragCoord.xy),0).r;
        float skyTex = texelFetch(colortex2, ivec2(gl_FragCoord.xy),0).g*texelFetch(colortex2, ivec2(gl_FragCoord.xy),0).g;
        vec3 ambientLight = vec3((vec3(0.5, 0.5, 0.55)*1.5)*times.sunrise + (vec3(0.6, 0.6, 0.7)*0.8)*times.noon + (vec3(0.5, 0.5, 0.55)*1.5)*times.sunset + nightAmbient*times.night)*pow(skyTex, 2.0);
        //if(waterm) scolor *= pow(skyTex, 2.0);
        if (isEyeInWater == 1) ambientLight *= 15.;
        if (isEyeInWater == 1) shadowLight *= 1.5;
    	vec3 torchCol = ((pow(torchTex, 3.0) * 2.7) * vec3(0.9,0.45,0.1));
        float ambientocclusion = 1.0;
        #ifdef AO
        if(!waterm) ambientocclusion = ssao(bayer64(gl_FragCoord.xy), normalMap, fragpos);
        #endif

        vec3 calcLight = ((ambientLight*1.26+torchCol)*ambientocclusion + (shadow*shadowLight))*shadowcolor;
        if(ice) scolor.rgb *= vec3(vec3(0.5)*times.sunrise + vec3(1.0)*times.noon + vec3(0.5)*times.sunset + vec3(0.25)*times.night);
        if(!glass && !ice) {
            return scolor.rgb * calcLight;
        } else {
            return scolor.rgb;
        }
}


void main() {
    int id = int(texelFetch(colortex3, ivec2(gl_FragCoord.xy),0).b*65535.);
    bool iswaterm = id == 8 || id == 9;
    bool isglass = id == 102 || id == 160 || id == 95;
    //bool plants = id == 161 || id == 18 || id == 175 || id == 32 || id == 31 || id == 8 || id == 9;
    bool isice = id == 79;
    float depth = texelFetch(depthtex0, ivec2(gl_FragCoord.xy),0).x;
    float belowdepth = texelFetch(depthtex1, ivec2(gl_FragCoord.xy),0).x;

	vec3 nightFogColor = vec3(0.1, 0.5, 1.0)*0.5;
    vec3 noonFogColor = vec3(0.2, 0.2, 0.2)*1.0;
	vec3 sunsetFogColor = vec3(0.7, 0.7, 1.0)*0.5;
    //vec3 normalrgb = texelFetch(colortex1, ivec2(gl_FragCoord.xy),0).rgb*2.0-1.0;
	vec3 customFogColor = (sunsetFogColor*times.sunrise + noonFogColor*times.noon + sunsetFogColor*times.sunset + nightFogColor*times.night);
	vec4 scolor = texelFetch(tex, ivec2(gl_FragCoord.xy),0);
    vec3 fragpos = getCameraSpacePos(texcoord, depth);
    shadowCoord = getShadowSpacePos(texcoord, depth, lightVector, 0.08);
    vec3 tex0world = getWorldSpacePos(texcoord, depth);
    vec3 tex1world = getWorldSpacePos(texcoord, belowdepth);
    vec3 coeff = vec3(0.35, 0.05, 0.03);
    float dist = distance(tex0world, tex1world); //With help by Jessie who develops Chronos and Magnificent and NV 
    float dist2 = distance(fragpos, gbufferModelViewInverse[3].xyz);
    if(depth<1.0) scolor.rgb = lightingCalculation(scolor, depth, iswaterm, isglass, isice, fragpos, tex1world);


    if(isEyeInWater == 0 && iswaterm) scolor.rgb = scolor.rgb * exp(-coeff * dist);
    if(isEyeInWater == 1 && !iswaterm) scolor.rgb = scolor.rgb * exp(-coeff * dist2);
    //if(isEyeInWater == 1 && !iswaterm) scolor.rgb *= 0.3;

    
/*DRAWBUFFERS:06*/
	color = scolor;
    //rays = vec4(getVolumetricRays(depth, texelFetch(depthtex1, ivec2(gl_FragCoord.xy),0).x, scolor.rgb, bayer128(gl_FragCoord.xy)), 1.0);
    rays = vec4(getVL(bayer16(gl_FragCoord.xy),tex1world,belowdepth),1.0);
}