#version 420 compatibility

layout(location = 0) out vec4 color;

#define TAA
#define sunriseprofile 3 //[3 2 1]
//#define RReflections
#define rrsamples 1 //[1 2 3 4 5 6 7 8 9 10]

#define STEP_SIZE (1.8 / 32.)

const float pi = 3.14159265359;
const float zenithOffset = 0.0;
const float multiScatterPhase = 0.1;
const float density = 0.7;

const float anisotropicIntensity = 0.0; //Higher numbers result in more anisotropic scattering

const vec3 skyColor = vec3(0.39, 0.57, 1.0) * (1.0 + anisotropicIntensity); //Make sure one of the conponents is never 0.0
vec3 _betaR = vec3(1.95e-2, 1.1e-1, 2.94e-1); 
vec3 _betaM = vec3(4e-2, 4e-2, 4e-2);
#define smooth(x) x*x*(3.0-2.0*x)
#define zenithDensity(x) density / pow(max(x - zenithOffset, 0.35e-2), 0.75)

#define FOGMULTIPLIER 0.7 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2]

/*
const int colortex3Format = RGBA16;
*/

uniform sampler2D tex;
uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex2;
uniform sampler2D colortex3;
uniform sampler2D colortex4;
uniform sampler2D colortex7;
uniform sampler2D depthtex1;
uniform sampler2D depthtex0;
uniform sampler2D noisetex;
uniform sampler2D colortex8;
uniform sampler2D colortex10;


uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferModelView;
uniform mat4 gbufferPreviousModelView;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferProjection;

uniform float viewWidth;
uniform float viewHeight;
uniform float sunAngle;
uniform float far;
uniform float near;
uniform float aspectRatio;
uniform float frameTimeCounter;
uniform float rainStrength;

uniform ivec2 eyeBrightnessSmooth;

uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;
uniform vec3 shadowLightPosition;
uniform vec3 sunPosition;
uniform vec3 moonPosition;
uniform vec3 upPosition;

uniform int isEyeInWater; 
uniform int frameCounter;
uniform int worldTime;

varying vec2 texcoord;

varying vec3 lightVector;
varying vec3 viewVector;

#include "/lib/time.glsl"

float bayer2(vec2 a){
    a = floor(a);
    return fract( dot(a, vec2(.5, a.y * .75)) );
}

#define bayer4(a)   (bayer2( .5*(a))*.25+bayer2(a))
#define bayer8(a)   (bayer4( .5*(a))*.25+bayer2(a))
#define bayer16(a)  (bayer8( .5*(a))*.25+bayer2(a))
#define bayer32(a)  (bayer16(.5*(a))*.25+bayer2(a))

vec3 getCameraSpacePos(in vec2 coord, in float depth) {
    vec3 screenspace = vec3(coord,depth)*2.0-1.0;

        return (screenspace*vec3(gbufferProjectionInverse[0].x, gbufferProjectionInverse[1].y, gbufferProjectionInverse[2].z) + gbufferProjectionInverse[3].xyz) / (screenspace.z * gbufferProjectionInverse[2].w + gbufferProjectionInverse[3].w);
}

vec3 getWorldSpacePos(in vec2 coord, in float depth) {
    vec3 WorldSpacePos = mat3(gbufferModelViewInverse)*getCameraSpacePos(coord, depth)+gbufferModelViewInverse[3].xyz;

    return WorldSpacePos;
}


vec3 getScreenSpacePos(in vec3 coord) {
    vec3 screenspace = (coord*vec3(gbufferProjection[0].x,gbufferProjection[1].y,gbufferProjection[2].z) + gbufferProjection[3].xyz) / (coord.z * gbufferProjection[2].w + gbufferProjection[3].w);


    return screenspace*0.5+0.5;
}


float lind(float depth) {
    return (near * far) / (depth * (near - far) + far);
}

float makethicc(float depth, float value, vec2 screenpos) {
    depth = getCameraSpacePos(screenpos, depth).x;
    depth *= value;
    return getScreenSpacePos(vec3(screenpos, depth)).x;
}

mat3 tbnNormalTangent(vec3 normal, vec3 tangent) {
    vec3 bitangent = cross(normal, tangent);
    return mat3(tangent, bitangent, normal);
}

// Creates a TBN matrix from just a normal
// The tangent version is needed for normal mapping because
//   of face rotation
mat3 tbnNormal(vec3 normal) {
    // This could be
    // normalize(vec3(normal.y - normal.z, -normal.x, normal.x))
    vec3 tangent = normalize(cross(normal, vec3(0, 1, 1)));
    return tbnNormalTangent(normal, tangent);
}


// vec3 binaryRF(in vec3 screenPos, in vec3 screenDir) {
//     for(int i = 0; i < 4; i++) {
//         float depth = texture(depthtex1, screenPos.xy).x;
//         screenPos = screenPos + (screenDir * sign(depth-screenPos.z));
//         //screenDir *= 0.5;
//     }
//     return screenPos;
// }
vec4 RayTrace(in vec3 viewPos, in vec3 normal, in float dither, in vec3 rvector, inout vec3 screenPos) {//function by Tech, modified by me    

    screenPos = getScreenSpacePos(viewPos);
    vec3 screenDir = normalize(getScreenSpacePos(viewPos + rvector) - screenPos) * STEP_SIZE;
	#ifdef TAA
    dither = fract(dither + frameTimeCounter * 11.3333);
	#endif
    //dither *= 0.25;
    screenPos += dither * screenDir;

    for (int i = 0; i < 32; i++, screenPos += screenDir) {
        float ssdepth = texture(depthtex1, screenPos.xy).x;
        if(clamp(screenPos, 0.0, 1.0) != screenPos) break;

        if(screenPos.z > ssdepth)
        {
            if(ssdepth<1.0) return texture(colortex0, screenPos.xy);
        }
    }

    return vec4(0.0);
}

//vec4 Refraction(in vec3 viewPos, in vec3 normal, in float dither) {//function by Tech, modified by me    

	//vec3 rvector = normalize(refract(viewPos, normal, 0.75));
    //vec3 screenPos = getScreenSpacePos(viewPos);
    //vec3 screenDir = normalize(getScreenSpacePos(viewPos + rvector) - screenPos) * STEP_SIZE;
	//#ifdef TAA
    //dither = fract(dither + frameTimeCounter * 11.3333);
	//#endif
    //dither *= 0.25;
    //screenPos += dither * screenDir;
   // for (int i = 0; i < 100; i++) {
        //screenPos += screenDir;
        
        //if(clamp(screenPos, 0.0, 1.0) != screenPos) break;

        //float ssdepth = texture(depthtex0, screenPos.xy).x;
        //float theminimumofthez = screenPos.z - STEP_SIZE * abs(screenDir.z);
        //if(screenPos.z > ssdepth && ssdepth<1.0 )
        //{
            //screenPos = binaryRF(screenPos,screenDir);
            //return texelFetch(colortex0, screenPos.xy,0);
        //}
    //}

    //return vec4(0.0);
//}



vec3 GGXVNDFS(vec3 fdir, vec2 s, float r) { //fdir is the direction s is the seed aka noise and r is the roughness
    float a = pow(r, 2.); // the alpha
    vec3 fn = vec3(a*fdir.xy,fdir.z);
    fdir = normalize(fn);
    float l = dot(fdir.yx,fdir.yx);
    vec3 T1 = vec3(l > 0.0 ? vec2(-fdir.y, fdir.x) * inversesqrt(l) : vec2(1.0, 0.0), 0.0);
    vec3 T2 = cross(T1, fdir);
    float dither = sqrt(s.x);
    float phi = 6.28 * s.y;
    float t1 = dither * cos(phi);
    float tmp = clamp(1.0-pow(t1,2.0),0.0,1.0);
    float t2 = mix(sqrt(tmp), dither * sin(phi), 0.5+ 0.5 * fdir.z);
    vec3 rh = (t1 * T1) + (t2 * T2) + sqrt(clamp(tmp - pow(t2, 2.0), 0.0, 1.0)) * fdir;
    
    return normalize(vec3(a * rh.xy, rh.z));
}

vec3 fresnelDieletricConductor(vec3 eta, vec3 etaK, float cosTheta) {  
   float cosTheta2 = cosTheta * cosTheta;
   float sinTheta2 = 1.0 - cosTheta2;
   vec3 eta2  = eta * eta;
   vec3 etaK2 = etaK * etaK;

   vec3 t0   = eta2 - etaK2 - sinTheta2;
   vec3 a2b2 = sqrt(t0 * t0 + 4.0 * eta2 * etaK2);
   vec3 t1   = a2b2 + cosTheta2;
   vec3 a    = sqrt(0.5 * (a2b2 + t0));
   vec3 t2   = 2.0 * a * cosTheta;
   vec3 Rs   = (t1 - t2) / (t1 + t2);

   vec3 t3 = cosTheta2 * a2b2 + sinTheta2 * sinTheta2;
   vec3 t4 = t2 * sinTheta2;   
   vec3 Rp = Rs * (t3 - t4) / (t3 + t4);

   return clamp((Rp + Rs) * 0.5, 0.0, 1.0);
}
float F0toIOR(float F0) {
    return (1.0 + sqrt(F0)) / (1.0 - sqrt(F0));
}

// Thanks LVutner#5199 for providing lambda smith equation
float lambdaSmith(float cosTheta, float alpha) {
    float cosTheta2 = pow(cosTheta,2.0);
    return (-1.0 + sqrt(1.0 + alpha * (1.0 - cosTheta2) / cosTheta2)) * 0.5;
}

float G1SmithGGX(float cosTheta, float roughness) {
    float alpha = pow(roughness, 2.0);
    return 1.0 / (1.0 + lambdaSmith(cosTheta, alpha));
}

float G2SmithGGX(float NdotL, float NdotV, float roughness) {
    float alpha   = pow(roughness, 2.0);
    float lambdaV = lambdaSmith(NdotV, alpha);
    float lambdaL = lambdaSmith(NdotL, alpha);
    return 1.0 / (1.0 + lambdaV + lambdaL);
}

void pcg(inout uint seed) {
    uint state = seed * 747796405u + 2891336453u;
    uint word = ((state >> ((state >> 28u) + 4u)) ^ state) * 277803737u;
    seed = (word >> 22u) ^ word;
}

uint rngState = 185730u * uint(frameCounter) + uint(gl_FragCoord.x + gl_FragCoord.y * viewWidth);
float randF() { pcg(rngState); return float(rngState) / float(0xffffffffu); }

vec3 ssrRough(vec3 fragpos, vec3 normal, float dither, float r, float f0, inout vec3 sPos, inout vec3 rvec, inout vec3 fresnel) { //Thanks to Belmu for providing me with proper importance sampled rough reflections! You can check out his work at https://www.patreon.com/Belmu and https://discord.gg/jjRrhpkH9e 
    vec3 ssr = vec3(0.0);
    fragpos += normal * 1e-2;
    mat3 tbn = tbnNormal(normal);
    float ndv = max(dot(normal, normalize(fragpos)),0.0);
    dither = fract(frameTimeCounter * 8.0 + dither);
    for(int i=0; i<rrsamples; i++) {
        vec3 importancesampling = tbn * GGXVNDFS(-normalize(fragpos), vec2(randF(),randF()), r);
        rvec = reflect(normalize(fragpos), importancesampling);
        vec4 ahit = RayTrace(fragpos, normal, dither, rvec,sPos);
        if(dot(normal,rvec)>0.0) {
            fresnel = fresnelDieletricConductor(vec3(F0toIOR(f0)),vec3(0.5),dot(normal,-normalize(fragpos)));
            //float g1 = G1SmithGGX(ndv,r);
            //float g2 = G2SmithGGX(dot(normal,rvec),ndv,r);
            ssr += ahit.rgb*fresnel;
            //* ((fresnel * g2) / g1)
            if(clamp(sPos,0.0,1.0) != sPos) sPos = vec3(0.0);
        } else break;
    }
    return ssr/float(rrsamples);
}

#include "/lib/sky.glsl"

#define getAngle(x) (0.07 / (x * x + 0.07))

// vec2 projectSphere(vec3 direction) {
//     float longitude = atan(-direction.x, -direction.z);
//     float latitude  = acos(direction.y);

//     return vec2(longitude * (1.0 / 6.28) + 0.5, latitude * (1.0/3.14));
// }

vec4 applyReflections(vec4 albedo, vec3 normalmap, vec3 fragpos, float dither, float depth) {
    float fresnelvalue = (150.*times.sunrise + 120.*times.noon + 150.*times.sunset + 60.*times.night);
    float fresnel = pow(clamp(1.0 + dot(normalmap, getCameraSpacePos(gl_FragCoord.xy/vec2(viewWidth,viewHeight),gl_FragCoord.z).xyz),0.0,1.0),fresnelvalue*0.2);
    vec4 reflections = vec4(0.0);
    vec3 rvec = normalize(reflect(fragpos, normalmap));
    vec3 sPos;
    reflections = RayTrace(fragpos, normalmap, dither, rvec, sPos);
    //vec4 refractions = Refraction(fragpos, normalmap, dither);
    vec3 sky = getAtmosphericScattering(mat3(gbufferModelViewInverse)*rvec, mat3(gbufferModelViewInverse)*normalize(sunPosition))*0.3;
    sky += getAtmosphericScattering(mat3(gbufferModelViewInverse)*rvec, mat3(gbufferModelViewInverse)*normalize(moonPosition))*(vec3(0.1, 0.2, 0.4)*0.1);
    sky += smoothstep(0.01, 0.0096, distance(mat3(gbufferModelViewInverse)*rvec, mat3(gbufferModelViewInverse)*normalize(sunPosition)))*5.;
    sky += smoothstep(0.01, 0.0096, distance(mat3(gbufferModelViewInverse)*rvec, mat3(gbufferModelViewInverse)*normalize(moonPosition)))*5.;
    float mixfog = max(0.0,getAngle(dot(normalize(upPosition), rvec)));
	vec3 sunsetcol = vec3(0.39, 0.57, 1.0)*0.01+vec3(0.59, 0.37, 0.2)*0.03;

    float skyTex = texelFetch(colortex2, ivec2(gl_FragCoord.xy),0).g*texelFetch(colortex2, ivec2(gl_FragCoord.xy),0).g;

    sky.rgb += (sunsetcol*times.sunrise + (vec3(0.3, 0.7, 1.6)*0.1)*times.noon + sunsetcol*times.sunset + vec3(0.0)*times.night);
    vec4 clouds = texture(colortex8, sPos.xy);
    if(clamp(sPos.xy,0.0,1.0) != sPos.xy) clouds = vec4(0.0);
    float cloudalpha = 1.0*float(clouds.rgb != vec3(0.0));
    sky.rgb = mix(sky.rgb, clouds.rgb,cloudalpha*clouds.a);
    //sky.rgb *= pow(skyTex,2.0);
	//albedo.rgb += clouds.rgb;
    //refractions.rgb = mix(albedo.rgb,refractions.rgb,refractions.a);
    albedo.rgb = mix(albedo.rgb, sky.rgb, mixfog);
    albedo.rgb = mix(albedo.rgb,reflections.rgb,fresnel*reflections.a);
    return albedo;
}

vec3 getAtmosphericScatteringStrongSun(vec3 direction, vec3 lightdirection){
		
	float zenith = zenithDensity(direction.y);
	float sunPointDistMult =  clamp(length(max(lightdirection.y + multiScatterPhase, 0.0)), 0.0, 1.0);
	
	float rayleighMult = getRayleigMultiplier(direction, lightdirection);
	
	vec3 absorption = getSkyAbsorption(skyColor, zenith);
    vec3 sunAbsorption = getSkyAbsorption(skyColor, zenithDensity(lightdirection.y + multiScatterPhase));
	vec3 sky = skyColor * zenith * rayleighMult;
	vec3 sun = getSunPoint(direction, lightdirection) * absorption * 12.;
	vec3 mie = getMie(direction, lightdirection) * sunAbsorption*vec3(0.5,0.6,0.7);
	
	vec3 totalSky = mix(sky * absorption, sky / sqrt(sky * sky + 2.0), sunPointDistMult);
         totalSky += sun + mie;
	     totalSky *= sunAbsorption * 0.5 + 0.5 * length(sunAbsorption);
	
	return totalSky;
}

#ifdef RReflections
vec4 applyRoughReflections(vec4 albedo, vec3 normalmap, vec3 fragpos, float dither, float roughness, float f0) {
    vec3 reflectionsrough = vec3(0.0);
    vec3 screenPos;
    vec3 rvec;
    vec3 fresnel;
    reflectionsrough = ssrRough(fragpos, normalmap, dither, roughness, f0,screenPos,rvec,fresnel);
    albedo.rgb += reflectionsrough;
    vec3 sky = getAtmosphericScatteringStrongSun(mat3(gbufferModelViewInverse)*rvec, mat3(gbufferModelViewInverse)*normalize(sunPosition))*0.1;
    sky += getAtmosphericScatteringStrongSun(mat3(gbufferModelViewInverse)*rvec, mat3(gbufferModelViewInverse)*normalize(moonPosition))*(vec3(0.1, 0.2, 0.4)*0.1);
    sky += smoothstep(0.01, 0.0096, distance(mat3(gbufferModelViewInverse)*rvec, mat3(gbufferModelViewInverse)*normalize(sunPosition)))*49.0;
    float mixfog = pow(texture(colortex2,screenPos.xy).g,40.0);
    sky.rgb += ((vec3(0.39, 0.57, 1.0)*0.1)*times.sunrise + (vec3(0.3, 0.7, 1.0)*0.1)*times.noon + (vec3(0.39, 0.57, 1.0)*0.1)*times.sunset + vec3(0.0)*times.night);
    // albedo.rgb = mix(albedo.rgb,sky,fresnel*mixfog*f0);
    return albedo;
}
#endif


vec3 getAtmosphericScatteringmoon(vec3 p, vec3 lp){
		
	float zenith = zenithDensity(p.y);
	float sunPointDistMult =  clamp(length(max(lp.y + multiScatterPhase, 0.0)), 0.0, 1.0);
	
	float rayleighMult = getRayleigMultiplier(p, lp);
	
	vec3 absorption = getSkyAbsorption(skyColor, zenith);
    vec3 sunAbsorption = getSkyAbsorption(skyColor, zenithDensity(lp.y + multiScatterPhase));
	vec3 sky = skyColor * zenith * rayleighMult;
	vec3 mie = getMie(p, lp) * sunAbsorption;
	
	vec3 totalSky = mix(sky * absorption, sky / sqrt(sky * sky + 2.0), sunPointDistMult);
         totalSky += mie;
	     totalSky *= sunAbsorption * 0.5 + 0.5 * length(sunAbsorption);
	
	return totalSky;
}

void main() {
    int id = int(texelFetch(colortex3, ivec2(gl_FragCoord.xy),0).b*65535.);
    bool iswaterm = id == 8 || id == 9;

    vec2 coord = texcoord;

    float depth = texelFetch(depthtex0, ivec2(gl_FragCoord.xy),0).x;
    float depth1 = texelFetch(depthtex1, ivec2(gl_FragCoord.xy),0).x;

	vec3 nightFogColor = vec3(0.1, 0.3, 1.0)*0.063;
    vec3 noonFogColor = vec3(0.4, 0.5, 0.6)*1.4;
	vec3 sunsetcol = vec3(1.0);
	#if sunriseprofile == 1
	sunsetcol = vec3(0.9, 0.46, 0.1)*0.1;
	#endif

	#if sunriseprofile == 2
	sunsetcol = vec3(0.9, 0.16, 0.3)*0.1;
	#endif

	#if sunriseprofile == 3
	sunsetcol = vec3(0.39, 0.57, 1.0)*0.25+vec3(0.59, 0.37, 0.2)*0.5;
	#endif

    vec3 normalrgb = texelFetch(colortex1, ivec2(gl_FragCoord.xy),0).rgb*2.0-1.0;
    vec3 fragpos = getCameraSpacePos(coord, depth).xyz;
    vec3 tex0world = getWorldSpacePos(texcoord, depth);
    vec3 tex1world = getWorldSpacePos(texcoord, depth1);
    float dist = distance(tex0world.y, tex1world.y); //With help by Jessie who develops Chronos and Magnificent and NV 
    float dist2 = distance(fragpos, gbufferModelViewInverse[3].xyz);
	vec3 customFogColor = (sunsetcol*times.sunrise + noonFogColor*times.noon + sunsetcol*times.sunset + nightFogColor*times.night)*0.3;
    customFogColor += vec3(0.5,0.5,0.5)*rainStrength;
	vec4 albedo = texelFetch(tex, ivec2(gl_FragCoord.xy),0);
    vec4 speculartext = texelFetch(colortex4, ivec2(gl_FragCoord.xy),0);
    #ifdef RReflections
    if (depth<1.0 && !iswaterm) albedo = applyRoughReflections(albedo, normalrgb, fragpos, bayer16(gl_FragCoord.xy), speculartext.r,speculartext.g);
    #endif
    vec3 waterFogColor = (vec3(0.4, 0.75, 0.9)*0.15) - vec3(0.025)*times.sunset - vec3(0.025)*times.sunrise - vec3(0.125)*times.night;
    if(iswaterm) albedo.rgb = mix(waterFogColor, albedo.rgb,exp(-dist*0.5));
    if(isEyeInWater == 1) albedo.rgb = mix(waterFogColor, albedo.rgb,exp(-dist2*0.1));
    if(iswaterm && isEyeInWater == 0) albedo = applyReflections(albedo, normalrgb, fragpos, bayer8(gl_FragCoord.xy), depth);
    if(depth<1.0 && isEyeInWater == 0) albedo.rgb = mix(albedo.rgb, getAtmosphericScatteringmoon(mat3(gbufferModelViewInverse)*normalize(fragpos), mat3(gbufferModelViewInverse)*normalize(sunPosition))*customFogColor, min(lind(depth) * (FOGMULTIPLIER*2.+(0.1*rainStrength)) / far, 1.0));



/*DRAWBUFFERS:0*/
	color = albedo;
}

	// vec3 sunsetcol = vec3(1.0);
	// #if sunriseprofile == 1
	// sunsetcol = vec3(0.9, 0.46, 0.1)*0.1;
	// #endif

	// #if sunriseprofile == 2
	// sunsetcol = vec3(0.9, 0.16, 0.3)*0.1;
	// #endif

	// #if sunriseprofile == 3
	// sunsetcol = vec3(0.39, 0.57, 1.0)*0.01+vec3(0.59, 0.37, 0.2)*0.03;
	// #endif

    // float depth = texture2D(depthtex0, texcoord).x;
	// vec3 viewVec = (gbufferProjectionInverse*(vec4(gl_FragCoord.xy/vec2(viewWidth,viewHeight),gl_FragCoord.z,1.0)*2.0-1.0)).xyz;
    // float mixfog = pow(dot(normalize(upPosition), normalize(viewVec)), 1.0);
	// vec3 sun =  vec3(smoothstep(0.998, 0.999, max(dot(normalize(viewVec), normalize(sunVec)), 0.0)))*70.0;
    // sun = (vec3(0.8, 0.46, 0.1)*times.sunrise + vec3(1.0)*times.noon + vec3(0.8, 0.46, 0.1)*times.sunset + vec3(0.2, 0.2, 0.5)*times.night)*sun;
    // float moon =  smoothstep(0.998, 0.999, max(dot(normalize(viewVec), normalize(moonVec)), 0.0));
    // vec4 scolor = texture2D(colortex0, texcoord);
	// vec3 atmopsherecols = (sunsetcol*times.sunrise + (vec3(0.39, 0.57, 1.0)*0.1)*times.noon + sunsetcol*times.sunset + vec3(0.0)*times.night);