#version 120

varying vec2 texcoord;

varying vec3 lightVector;
varying vec3 viewVector;

uniform float sunAngle;

uniform vec3 sunPosition;
uniform vec3 moonPosition;

uniform mat4 gbufferModelViewInverse;

void main() {
	gl_Position = ftransform();
	texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;
    if (sunAngle < 0.5f) {
        lightVector = normalize(sunPosition);
    } else {
        lightVector = normalize(moonPosition);
    }
        viewVector = (gl_ModelViewMatrix * gl_Vertex).xyz;
}