#version 420 compatibility

layout(location = 0) out vec4 color;

//#define LightShaft
#define LightShaftStrength 1.50	//[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 3.00 4.00 5.00]
//const bool colortex6MipmapEnabled = true;
#define FOGMULTIPLIER 0.7 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2]

const float pi = 3.14159265359;
const float zenithOffset = 0.0;
const float multiScatterPhase = 0.1;
const float density = 0.7;

const float anisotropicIntensity = 0.0; //Higher numbers result in more anisotropic scattering

const vec3 skyColor = vec3(0.39, 0.57, 1.0) * (1.0 + anisotropicIntensity); //Make sure one of the conponents is never 0.0
vec3 _betaR = vec3(1.95e-2, 1.1e-1, 2.94e-1); 
vec3 _betaM = vec3(4e-2, 4e-2, 4e-2);
#define smooth(x) x*x*(3.0-2.0*x)
#define zenithDensity(x) density / pow(max(x - zenithOffset, 0.35e-2), 0.75)

varying vec3 upVec;
varying vec3 sunVec;

varying vec2 texcoord;

uniform int isEyeInWater;
uniform int worldTime;

uniform float blindness;
uniform float rainStrength;
uniform float frameTimeCounter;
uniform float sunAngle;
uniform float near;
uniform float far;

uniform ivec2 eyeBrightnessSmooth;

uniform vec2 view;

uniform vec3 sunPosition;
uniform vec3 moonPosition;

uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferProjectionInverse;

uniform sampler2D colortex0;
uniform sampler2D colortex6;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;

struct SceneData{
    float shadows;
    vec4 scolor;
    float depth;
    vec3 normal;
    vec3 lightvec;
    float diffuse;
} sdata;


float eBS = eyeBrightnessSmooth.y/240.0;
float shadowFade = clamp(1.0 - (abs(abs(sunAngle - 0.5) - 0.25) - 0.23) * 100.0, 0.0, 1.0);

#include "/lib/sky.glsl"
#include "/lib/time.glsl"

vec3 getCameraSpacePos(in vec2 coord, in float depth) {
    vec3 screenspace = vec3(coord,depth)*2.0-1.0;

        return (screenspace*vec3(gbufferProjectionInverse[0].x, gbufferProjectionInverse[1].y, gbufferProjectionInverse[2].z) + gbufferProjectionInverse[3].xyz) / (screenspace.z * gbufferProjectionInverse[2].w + gbufferProjectionInverse[3].w);
}

vec3 getWorldSpacePos(in vec2 coord, in float depth) {
    vec3 WorldSpacePos = mat3(gbufferModelViewInverse)*getCameraSpacePos(coord, depth)+gbufferModelViewInverse[3].xyz;

    return WorldSpacePos;
}

vec3 getAtmosphericScatteringNoSun(vec3 p, vec3 lp){
		
	float zenith = zenithDensity(p.y);
	float sunPointDistMult =  clamp(length(max(lp.y + multiScatterPhase, 0.0)), 0.0, 1.0);
	
	float rayleighMult = getRayleigMultiplier(p, lp);
	
	vec3 absorption = getSkyAbsorption(skyColor, zenith);
    vec3 sunAbsorption = getSkyAbsorption(skyColor, zenithDensity(lp.y + multiScatterPhase));
	vec3 sky = skyColor * zenith * rayleighMult;
	vec3 mie = getMie(p, lp) * sunAbsorption;
	
	vec3 totalSky = mix(sky * absorption, sky / sqrt(sky * sky + 2.0), sunPointDistMult);
         totalSky += mie;
	     totalSky *= sunAbsorption * 0.5 + 0.5 * length(sunAbsorption);
	
	return totalSky;
}

float lind(float depth) {
    return (near * far) / (depth * (near - far) + far);
}

void main(){
	sdata.scolor = texelFetch(colortex0,ivec2(gl_FragCoord.xy),0);
    sdata.depth = texelFetch(depthtex1,ivec2(gl_FragCoord.xy),0).r;
	float lssterngthunderwater = 1.0;
	#ifdef LightShaft
	vec3 vl = texelFetch(colortex6,ivec2(gl_FragCoord.xy),0).rgb;
	
	float b = clamp(blindness*2.0-1.0,0.0,1.0);
	b *= b;
    vec3 viewVec = getCameraSpacePos(gl_FragCoord.xy/view,gl_FragCoord.z);
	vec3 lightShaftColor = getAtmosphericScatteringNoSun(mat3(gbufferModelViewInverse)*normalize(viewVec),mat3(gbufferModelViewInverse)*normalize(sunVec));
    lightShaftColor += (vec3(0.39, 0.57, 1.0)*times.sunrise + vec3(0.3, 0.7, 1.0)*times.noon + vec3(0.39, 0.27, 0.2)*times.sunset + vec3(0.0)*times.night);
    //if(isEyeInWater == 1) lightShaftColor *= 55.5;
	float fogFactor = min(lind(sdata.depth) * (FOGMULTIPLIER*2.) / far, 1.0);
	if(sdata.depth == 1.0) fogFactor = 0.5;

    //if(sdata.depth>=1.0) vl *= 0.5;
	sdata.scolor.rgb += mix(vec3(0.0),vl*vl * (LightShaftStrength*0.2)*lightShaftColor,fogFactor*float(vl));
	#endif
/*DRAWBUFFERS:0*/
	color = vec4(sdata.scolor);
}
