#version 420 compatibility

layout(location = 0) out vec4 color;


//CODE IS TAKEN FROM BSL MADE BY CAPT TATSU

#define Bloom
#define DOF
#define bloomStrength 0.01 //[0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.15 0.2 0.25 0.3 0.4 0.5]
#define DOFStrength 0.2 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0]

uniform sampler2D depthtex2;
uniform sampler2D depthtex1;
uniform sampler2D colortex0;
uniform sampler2D tex;
uniform sampler2D colortex1;

uniform float viewWidth;
uniform float viewHeight;
uniform float centerDepthSmooth;
uniform float aspectRatio;
uniform float far;
uniform float near;

varying vec2 texcoord;

vec3 lengthBloom(vec3 x){
	return x*x*128.0;
}

vec3 getBloom(vec3 color, vec2 coord){
	vec3 blur1 = lengthBloom(texture2D(colortex1,coord/pow(2.0,2.0) + vec2(0.0,0.0)).rgb);
	vec3 blur2 = lengthBloom(texture2D(colortex1,coord/pow(2.0,3.0) + vec2(0.0,0.26)).rgb);
	vec3 blur3 = lengthBloom(texture2D(colortex1,coord/pow(2.0,4.0) + vec2(0.135,0.26)).rgb);
	vec3 blur4 = lengthBloom(texture2D(colortex1,coord/pow(2.0,5.0) + vec2(0.2075,0.26)).rgb);
	vec3 blur5 = lengthBloom(texture2D(colortex1,coord/pow(2.0,6.0) + vec2(0.235,0.3325)).rgb);
	vec3 blur6 = lengthBloom(texture2D(colortex1,coord/pow(2.0,7.0) + vec2(0.360625,0.3325)).rgb);
	vec3 blur7 = lengthBloom(texture2D(colortex1,coord/pow(2.0,8.0) + vec2(0.3784375,0.3325)).rgb);

	vec3 blur = (blur1 + blur2 + blur3 + blur4 + blur5 + blur6 + blur7) * 0.06;
	
	return blur*bloomStrength;
}

vec2 DOFfset[60] = vec2[60]  (  vec2( 0.0000, 0.2500 ),
									vec2( -0.2267, 0.1250 ),
									vec2( -0.2267, -0.1250 ),
									vec2( -0.0000, -0.2500 ),
									vec2( 0.2267, -0.1250 ),
									vec2( 0.2267, 0.1250 ),
									vec2( 0.0000, 0.5000 ),
									vec2( -0.2500, 0.4330 ),
									vec2( -0.4330, 0.2500 ),
									vec2( -0.5000, 0.0000 ),
									vec2( -0.4330, -0.2500 ),
									vec2( -0.2500, -0.4330 ),
									vec2( -0.0000, -0.5000 ),
									vec2( 0.2500, -0.4330 ),
									vec2( 0.4330, -0.2500 ),
									vec2( 0.5000, -0.0000 ),
									vec2( 0.4330, 0.2500 ),
									vec2( 0.2500, 0.4330 ),
									vec2( 0.0000, 0.7500 ),
									vec2( -0.2565, 0.7048 ),
									vec2( -0.4821, 0.5745 ),
									vec2( -0.51295, 0.3750 ),
									vec2( -0.7386, 0.1302 ),
									vec2( -0.7386, -0.1302 ),
									vec2( -0.51295, -0.3750 ),
									vec2( -0.4821, -0.5745 ),
									vec2( -0.2565, -0.7048 ),
									vec2( -0.0000, -0.7500 ),
									vec2( 0.2565, -0.7048 ),
									vec2( 0.4821, -0.5745 ),
									vec2( 0.51295, -0.3750 ),
									vec2( 0.7386, -0.1302 ),
									vec2( 0.7386, 0.1302 ),
									vec2( 0.51295, 0.3750 ),
									vec2( 0.4821, 0.5745 ),
									vec2( 0.2565, 0.7048 ),
									vec2( 0.0000, 1.0000 ),
									vec2( -0.2588, 0.9659 ),
									vec2( -0.5000, 0.8660 ),
									vec2( -0.7071, 0.7071 ),
									vec2( -0.8660, 0.5000 ),
									vec2( -0.9659, 0.2588 ),
									vec2( -1.0000, 0.0000 ),
									vec2( -0.9659, -0.2588 ),
									vec2( -0.8660, -0.5000 ),
									vec2( -0.7071, -0.7071 ),
									vec2( -0.5000, -0.8660 ),
									vec2( -0.2588, -0.9659 ),
									vec2( -0.0000, -1.0000 ),
									vec2( 0.2588, -0.9659 ),
									vec2( 0.5000, -0.8660 ),
									vec2( 0.7071, -0.7071 ),
									vec2( 0.8660, -0.5000 ),
									vec2( 0.9659, -0.2588 ),
									vec2( 1.0000, -0.0000 ),
									vec2( 0.9659, 0.2588 ),
									vec2( 0.8660, 0.5000 ),
									vec2( 0.7071, 0.7071 ),
									vec2( 0.5000, 0.8660 ),
									vec2( 0.2588, 0.9659 ));


vec3 DOField(vec3 scolor, float depth) {
	vec3 dof = vec3(0.0);
	float noncenter = abs(depth-centerDepthSmooth)*DOFStrength;
	for(int i=0; i < 20; ++i) {
		dof += texelFetch(tex, ivec2(gl_FragCoord.xy + DOFfset[i]*noncenter*vec2(viewWidth,viewHeight)*vec2(1.0/aspectRatio,1.0)),0).rgb;
	}
	return dof/20.;
}
void main() {

    vec4 scolor = texelFetch(tex, ivec2(gl_FragCoord.xy),0);
	float depth = texelFetch(depthtex2, ivec2(gl_FragCoord.xy),0).x;
	//depth = ld(depth); doesnt work with this DOF

	#ifdef DOF
	scolor.rgb = DOField(scolor.rgb, depth);
	#endif

    #ifdef Bloom
    scolor.rgb += getBloom(scolor.rgb, texcoord);
    #endif

/*DRAWBUFFERS:0*/
    color = scolor;
}