#version 420 compatibility
#define TAA
#ifdef TAA
/*DRAWBUFFERS:05*/
layout(location = 0) out vec4 color;
layout(location = 1) out vec4 tcolor;
#else
/*DRAWBUFFERS:0*/
layout(location = 0) out vec4 color;
#endif


/*
const int RGBA16                 = 1;             
const int colortex5Format        =  RGBA16F;
const int colortex6Format        =  RGBA16;
const bool colortex5Clear = false;
const bool colortex6Clear = false;
*/

uniform float viewHeight;
uniform float viewWidth;
uniform float near;
uniform float far;
uniform sampler2D colortex0;
uniform sampler2D depthtex0;
uniform sampler2D colortex5;
uniform sampler2D depthtex1;

uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousProjection;
uniform mat4 gbufferPreviousModelView;

varying vec4 texcoord;

//Previous frame reprojection from Chocapic13 and Eldeston
vec2 toPrevScreenPos(vec2 currScreenPos, float depth){
    vec3 currViewPos = vec3(vec2(gbufferProjectionInverse[0].x, gbufferProjectionInverse[1].y) * (currScreenPos.xy * 2.0 - 1.0) + gbufferProjectionInverse[3].xy, gbufferProjectionInverse[3].z);
    currViewPos /= (gbufferProjectionInverse[2].w * (depth * 2.0 - 1.0) + gbufferProjectionInverse[3].w);
    vec3 currFeetPlayerPos = mat3(gbufferModelViewInverse) * currViewPos + gbufferModelViewInverse[3].xyz;

    vec3 prevFeetPlayerPos = depth > 0.56 ? currFeetPlayerPos + cameraPosition - previousCameraPosition : currFeetPlayerPos;
    vec3 prevViewPos = mat3(gbufferPreviousModelView) * prevFeetPlayerPos + gbufferPreviousModelView[3].xyz;
    vec2 finalPos = vec2(gbufferPreviousProjection[0].x, gbufferPreviousProjection[1].y) * prevViewPos.xy + gbufferPreviousProjection[3].xy;
    return (finalPos / -prevViewPos.z) * 0.5 + 0.5;
}

mat3 ycocg = mat3(vec3(0.25,0.5,0.25),
                vec3(0.5,0,-0.5),
				vec3(-0.25, 0.5, -0.25)
				);
mat3 ycocgtolinear =  mat3(vec3(1.0,  1.0,  1.0),
                           vec3(1.0, 0.0, -1.0),
                           vec3(-1.0,  1.0, -1.0)
						   );

vec3 neighbourhoodClamping(vec3 color, vec3 tempcolor){
	vec3 coltl = texelFetch(colortex0,ivec2(gl_FragCoord.xy)+ivec2(-1.0,-1.0),0).rgb;
	vec3 coltm = texelFetch(colortex0,ivec2(gl_FragCoord.xy)+ivec2( 0.0,-1.0),0).rgb;
	vec3 coltr = texelFetch(colortex0,ivec2(gl_FragCoord.xy)+ivec2( 1.0,-1.0),0).rgb;
	vec3 colml = texelFetch(colortex0,ivec2(gl_FragCoord.xy)+ivec2(-1.0, 0.0),0).rgb;
	vec3 colmr = texelFetch(colortex0,ivec2(gl_FragCoord.xy)+ivec2( 1.0, 0.0),0).rgb;
	vec3 colbl = texelFetch(colortex0,ivec2(gl_FragCoord.xy)+ivec2(-1.0, 1.0),0).rgb;
	vec3 colbm = texelFetch(colortex0,ivec2(gl_FragCoord.xy)+ivec2( 0.0, 1.0),0).rgb;
	vec3 colbr = texelFetch(colortex0,ivec2(gl_FragCoord.xy)+ivec2( 1.0, 1.0),0).rgb;
	
	vec3 minclr = min(color,min(min(min(coltl,coltm),min(coltr,colml)),min(min(colmr,colbl),min(colbm,colbr))));
	vec3 maxclr = max(color,max(max(max(coltl,coltm),max(coltr,colml)),max(max(colmr,colbl),max(colbm,colbr))));
	
	return clamp(tempcolor,minclr,maxclr);
}


// float neighbourhoodClampingDepth(float depth, float tempDepth){
// 	float depthtl = texelFetch(depthtex1,ivec2(gl_FragCoord.xy)+ivec2(-1.0,-1.0),0).x;
// 	float depthtm = texelFetch(depthtex1,ivec2(gl_FragCoord.xy)+ivec2( 0.0,-1.0),0).x;
// 	float depthtr = texelFetch(depthtex1,ivec2(gl_FragCoord.xy)+ivec2( 1.0,-1.0),0).x;
// 	float depthml = texelFetch(depthtex1,ivec2(gl_FragCoord.xy)+ivec2(-1.0, 0.0),0).x;
// 	float depthmr = texelFetch(depthtex1,ivec2(gl_FragCoord.xy)+ivec2( 1.0, 0.0),0).x;
// 	float depthbl = texelFetch(depthtex1,ivec2(gl_FragCoord.xy)+ivec2(-1.0, 1.0),0).x;
// 	float depthbm = texelFetch(depthtex1,ivec2(gl_FragCoord.xy)+ivec2( 0.0, 1.0),0).x;
// 	float depthbr = texelFetch(depthtex1,ivec2(gl_FragCoord.xy)+ivec2( 1.0, 1.0),0).x;
	
// 	float minDepth = min(depth,min(min(min(depthtl,depthtm),min(depthtr,depthml)),min(min(depthmr,depthbl),min(depthbm,depthbr))));
// 	float maxDepth = max(depth,max(max(max(depthtl,depthtm),max(depthtr,depthml)),max(max(depthmr,depthbl),max(depthbm,depthbr))));
	
// 	return clamp(tempDepth,minDepth,maxDepth);
// }

float getblendfactor(vec2 velo) {
    return exp(-length(velo)) * 0.3 + 0.6;
}

float lind(float depth) {
    return (near * far) / (depth * (near - far) + far);
}
void main() {

    vec3 scolor = texelFetch(colortex0,ivec2(gl_FragCoord.xy),0).rgb;
	float depth = texelFetch(depthtex1,ivec2(gl_FragCoord.xy),0).x;
	#ifdef TAA
	vec2 prvcoord = toPrevScreenPos(texcoord.st,depth);
	vec2 view = vec2(viewWidth,viewHeight); //will make uniform aswell later
	vec3 tempcolor = neighbourhoodClamping(scolor,texelFetch(colortex5,ivec2(gl_FragCoord.xy),0).rgb);
	//tempcolor *= ycocgtolinear;
	vec2 velocity = (texcoord.st-prvcoord.xy)*view;
	float blendfactor = 0.95;
	// float sampledPreviousDepth = 1.0-texture(colortex5,prvcoord.xy).a;
	// float sampledPreviousDepthNC = neighbourhoodClampingDepth(depth,sampledPreviousDepth);
    // float depthWeight  = exp(-abs(lind(depth) - lind(sampledPreviousDepthNC)));
	// if(sampledPreviousDepthNC != sampledPreviousDepth) blendfactor *= depthWeight;
	blendfactor *= getblendfactor(velocity);
	tempcolor = mix(scolor,tempcolor,blendfactor);
	#endif
#ifdef TAA
	color = vec4(tempcolor,1.0);
	tcolor = vec4(tempcolor,1.0-depth);
#else
	color = vec4(scolor,1.0);
#endif
}

