#version 420 compatibility

layout(location = 0) out vec4 color;
/*
const int colortex0Format   = RGBA16F;
*/

//#define LightShaft
#define LightShaftStrength 1.50	//[0.25 0.50 0.75 1.00 1.25 1.50 1.75 2.00 3.00 4.00 5.00]

#define sunriseprofile 3 //[3 2 1]
varying vec3 sunVec;
varying vec3 moonVec;
varying vec3 viewVector;

varying vec2 texcoord;

uniform vec2 aspectRatio;

uniform vec3 upPosition;
uniform vec3 sunPosition;
uniform vec3 moonPosition;

uniform float rainStrength;
uniform float viewWidth;
uniform float viewHeight;
uniform float sunAngle;

uniform int isEyeInWater;

uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;

uniform sampler2D colortex0;
uniform sampler2D depthtex1;
uniform sampler2D depthtex0;

const float pi = 3.14159265359;
const float invPi = 1.0 / pi;

const float multiScatterPhase = 0.1;
const float density = 0.7; 

const float anisotropicIntensity = 0.0; //Higher numbers result in more anisotropic scattering

const vec3 skyColor = vec3(0.39, 0.57, 1.0) * (1.0 + anisotropicIntensity); //Make sure one of the conponents is never 0.0

#define zenithDensity(x) density / pow(max(x, 0.35e-2), 0.75)

#include "/lib/time.glsl"
#include "/lib/sky.glsl"

vec3 getAtmosphericScatteringmoon(vec3 p, vec3 lp){
		
	float zenith = zenithDensity(p.y);
	float sunPointDistMult =  clamp(length(max(lp.y + multiScatterPhase, 0.0)), 0.0, 1.0);
	
	float rayleighMult = getRayleigMultiplier(p, lp);
	
	vec3 absorption = getSkyAbsorption(skyColor, zenith);
    vec3 sunAbsorption = getSkyAbsorption(skyColor, zenithDensity(lp.y + multiScatterPhase));
	vec3 sky = skyColor * zenith * rayleighMult;
	vec3 mie = getMie(p, lp) * sunAbsorption;
	
	vec3 totalSky = mix(sky * absorption, sky / sqrt(sky * sky + 2.0), sunPointDistMult);
         totalSky += mie;
	     totalSky *= sunAbsorption * 0.5 + 0.5 * length(sunAbsorption);
	
	return totalSky;
}
vec2 sincos(float x) {
	return vec2(sin(x),cos(x));
}
vec3 unprojectSphere(vec2 coord) {
    float latitude = coord.y * 3.14;
    return vec3(sincos(coord.x * 6.28) * sin(latitude), cos(latitude)).xzy;
}

//RENDERTARGETS: 0,8,9,12

void main() {
	vec3 sunsetcol = vec3(1.0);
	#if sunriseprofile == 1
	sunsetcol = vec3(0.9, 0.46, 0.1)*0.1;
	#endif

	#if sunriseprofile == 2
	sunsetcol = vec3(0.9, 0.16, 0.3)*0.1;
	#endif

	#if sunriseprofile == 3
	sunsetcol = vec3(0.39, 0.57, 1.0)*0.01+vec3(0.59, 0.37, 0.2)*0.03;
	#endif

    float depth = texture2D(depthtex0, texcoord).x;
	vec3 viewVec = (gbufferProjectionInverse*(vec4(gl_FragCoord.xy/vec2(viewWidth,viewHeight),gl_FragCoord.z,1.0)*2.0-1.0)).xyz;
    float mixfog = pow(dot(normalize(upPosition), normalize(viewVec)), 1.0);
	vec3 sun =  vec3(smoothstep(0.998, 0.999, max(dot(normalize(viewVec), normalize(sunVec)), 0.0)))*70.0;
    sun = (vec3(0.8, 0.46, 0.1)*times.sunrise + vec3(1.0)*times.noon + vec3(0.8, 0.46, 0.1)*times.sunset + vec3(0.2, 0.2, 0.5)*times.night)*sun;
    float moon =  smoothstep(0.998, 0.999, max(dot(normalize(viewVec), normalize(moonVec)), 0.0));
    vec4 scolor = texture2D(colortex0, texcoord);
	vec3 atmopsherecols = (sunsetcol*times.sunrise + (vec3(0.39, 0.57, 1.0)*0.1)*times.noon + sunsetcol*times.sunset + vec3(0.0)*times.night);

    if(depth >= 1.0) { 
		scolor.rgb += 0.2*getAtmosphericScattering(mat3(gbufferModelViewInverse)*normalize(viewVec.xyz), mat3(gbufferModelViewInverse)*normalize(sunVec))+(atmopsherecols*2.0);
        scolor.rgb += 0.2*getAtmosphericScatteringmoon(mat3(gbufferModelViewInverse)*normalize(viewVec.xyz), (mat3(gbufferModelViewInverse)*normalize(moonVec)))*vec3(0.1, 0.2, 0.4);
		// #ifdef LightShaft
		// scolor.rgb *= 0.9-(0.2*LightShaftStrength);
		// #endif
	}
	

/*DRAWBUFFERS:0*/
    color = scolor;
}