#version 130

#define ExposaUnique

#define VClouds
#define VCloudRes 4.0 //[1.0 2.0 4.0 6.0 8.0 16.0]
//#define Clouds

#define altitude 4050.0      //[200.0 300 400.0 500.0 650.0 700.0 750.0 800.0 850.0 900.0 1050.0 1250.0 2050.0 3000.0 4050.0 8050.0 10500.0] 
#define thickness 4050.0      //[200.0 300 400.0 500.0 650.0 700.0 750.0 800.0 850.0 900.0 1050.0 1250.0 2050.0 3000.0 4050.0 8050.0 10500.0]

#define VAltitude 200.0 //[50.0 100.0 200.0 300 400.0 500.0 650.0 700.0 750.0 800.0 850.0 900.0]
#define Vthickness 200.0 //[50.0 100.0 200.0 300 400.0 500.0 650.0 700.0 750.0 800.0 850.0 900.0]

const int noiseTextureResolution = 256;

varying vec3 lightVector;
varying vec3 colSky;
varying vec3 colFog;
varying vec3 sunlight;

uniform mat4 gbufferProjection;
uniform mat4 gbufferModelView;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform mat4 gbufferPreviousProjection;
uniform mat4 shadowModelView;
uniform mat4 shadowModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowProjectionInverse;

uniform sampler2D colortex0;
uniform sampler2D colortex1;
uniform sampler2D colortex10;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;

varying vec4 texcoord;
uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;

uniform float frameTimeCounter;
uniform int frameCounter;
uniform float viewHeight;
uniform float viewWidth;
uniform float far;
uniform float near;


uniform vec3 sunPosition;

uniform float rainStrength;
uniform float sunAngle;

float timeVal = sunAngle;

    float tSunrise  = ((clamp(timeVal, 0.96, 1.00)-0.96) / 0.04 + 1-(clamp(timeVal, 0.02, 0.15)-0.02) / 0.13);
    float tNoon     = ((clamp(timeVal, 0.02, 0.15)-0.02) / 0.13   - (clamp(timeVal, 0.35, 0.48)-0.35) / 0.13);
    float tSunset   = ((clamp(timeVal, 0.35, 0.48)-0.35) / 0.13   - (clamp(timeVal, 0.50, 0.53)-0.50) / 0.03);
    float tNight    = ((clamp(timeVal, 0.50, 0.53)-0.50) / 0.03   - (clamp(timeVal, 0.96, 1.00)-0.96) / 0.03);

vec3 rayPos(in float depth, const float scale) {           //funtion to get the ray position in world space
    vec2 coord = gl_FragCoord.xy;
        coord.x /= viewWidth;
        coord.y /= viewHeight;
    vec4 posNDC = vec4((coord.x) * 2.0 - 1.0, (coord.y) * 2.0 - 1.0, 2.0 * depth - 1.0, 1.0);
    vec4 posCamSpace = gbufferProjectionInverse * posNDC;
        posCamSpace /= posCamSpace.w;
    vec4 posWorldSpace = gbufferModelViewInverse * posCamSpace;
        posWorldSpace.xyz *= scale;
    return posWorldSpace.xyz+cameraPosition.xyz;
}

vec4 rayPos(in float depth) {           //funtion for ray position in world space
    vec2 coord = gl_FragCoord.xy;
        coord.x /= viewWidth;
        coord.y /= viewHeight;
    vec4 posNDC = vec4((coord.x) * 2.0 - 1.0, (coord.y) * 2.0 - 1.0, 2.0 * depth - 1.0, 1.0);
    vec4 posCamSpace = gbufferProjectionInverse * posNDC;
        posCamSpace /= posCamSpace.w;
    vec4 posWorldSpace = gbufferModelViewInverse * posCamSpace;
    return posWorldSpace;
}

#include "/lib/clouds.glsl"
#include "/lib/volumeclouds.glsl"
#include "/lib/pos.glsl"
#include "/lib/volumevoid.glsl"

float max_depth3x3(sampler2D depthtex, vec2 coord, vec2 px) {

    float tl    = texture2D(depthtex, coord + vec2(-px.x, -px.y)).x;
    float tc    = texture2D(depthtex, coord + vec2(0.0, -px.y)).x;
    float tr    = texture2D(depthtex, coord + vec2(px.x, -px.y)).x;
    float tmin  = max(tl, max(tc, tr));

    float ml    = texture2D(depthtex, coord + vec2(-px.x, 0.0)).x;
    float mc    = texture2D(depthtex, coord).x;
    float mr    = texture2D(depthtex, coord + vec2(px.x, 0.0)).x;
    float mmin  = max(ml, max(mc, mr));

    float bl    = texture2D(depthtex, coord + vec2(-px.x, px.y)).x;
    float bc    = texture2D(depthtex, coord + vec2(0.0, px.y)).x;
    float br    = texture2D(depthtex, coord + vec2(px.x, px.y)).x;
    float bmin  = max(bl, max(bc, br));

    return max(tmin, max(mmin, bmin));
}

#define rcp(x) (1.0 / x)

vec2 sincos(float x) {
	return vec2(sin(x),cos(x));
}
vec3 unprojectSphere(vec2 coord) {
    float latitude = coord.y * 3.14;
    return vec3(sincos(coord.x * 6.28) * sin(latitude), cos(latitude)).xzy;
}

void main() {
    const float cLOD    = sqrt(VCloudRes);

    vec2  scalecoord  = texcoord.st*cLOD;
 

     #ifdef ExposaUnique

     #endif

     float height = 0.0;

    vec4 vclouds;

    vec3 sceneCol   = texture2D(colortex0, scalecoord).rgb;
    vec3 sceneCola   = texture2D(colortex0, texcoord.st).rgb;

    float sceneDepth = max_depth3x3(depthtex0, scalecoord, vec2(1.0 / viewWidth, 1.0 / viewHeight)*cLOD);
    float linearDepth = depthLin(sceneDepth);
    float dither = fract(bayer64(gl_FragCoord.xy)+ frameCounter/8.0);
    if (clamp(scalecoord, -0.003, 1.003) == scalecoord && sceneDepth >= 1.0) {
        scalecoord = clamp(scalecoord, 0.0, 1.0);
        vec3 worldPos = getWorldSpacePos(scalecoord, sceneDepth).xyz;
    

    bool isTerrain = sceneDepth < 1.0;

    
    float sunLightBrtness = (1.2*tSunrise + 1.5*tNoon + 1.2*tSunset + 0.65*tNight);

    #ifdef Clouds
    clouds_2D(worldPos, cameraPosition, lightVector, sunlight*sunLightBrtness, colSky, isTerrain, height, sceneCol);
    #endif

    #ifdef VClouds
    vec3 worldVec   = normalize(worldPos-cameraPosition.xyz);
    vclouds = fastvolumetricloud(lightVector, worldVec, sceneCol);
	vclouds.rgb /= 1.0 + vclouds.rgb;
    #endif
    }

/*DRAWBUFFERS:07*/
    gl_FragData[0] = vec4(sceneCola, 1.0);
    if (clamp(scalecoord, -0.003, 1.003) == scalecoord && sceneDepth >= 1.0) {
    #ifdef VClouds
    gl_FragData[1] = vclouds;
    #else
    gl_FragData[1] = vec4(sceneCola, 1.0);
    #endif
    } else {
        gl_FragData[1] = vec4(0.0, 0.0, 0.0, 1.0);
    }
   
}