#version 120
#define TemporalReproject

varying vec4 texcoord;
varying vec3 lightVector;
varying vec3 colSky;
varying vec3 colFog;
varying vec3 sunlight;

uniform sampler2D texture;
//uniform sampler2D lightmap;
uniform vec3 shadowLightPosition;

//varying vec4 lmcoord; 	//you cannot get lightmap data like this in composite/deferred passes

uniform vec3 skyColor; 	//vanilla sky color uniform
uniform vec3 fogColor; 	//vanilla fog color

uniform int frameCounter;

uniform float viewWidth;
uniform float viewHeight;

vec2 jitter[8] = vec2[8](vec2( 0.125,-0.375),
							   vec2(-0.125, 0.375),
							   vec2( 0.625, 0.125),
							   vec2( 0.375,-0.625),
							   vec2(-0.625, 0.625),
							   vec2(-0.875,-0.125),
							   vec2( 0.375,-0.875),
							   vec2( 0.875, 0.875));
				

vec2 taaJitter(vec2 coord, float w){
	return jitter[int(mod(frameCounter,8.0))]*(w/vec2(viewWidth,viewHeight)) + coord;
}

void main(){
	gl_Position = ftransform();
	//#ifdef TemporalReproject
	    //gl_Position.xy = taaJitter(gl_Position.xy, gl_Position.w);
	//#endif

    //vec3 color = texture2D(lightmap,lmcoord.st).xyz; 	//that does not make sense

	sunlight 	= vec3(1.0, 1.0, 1.0); //can use any sunlight color here

	colSky 	= skyColor;
	colFog 	= fogColor;
	
	texcoord = gl_MultiTexCoord0;

	lightVector 	= normalize(shadowLightPosition);

}
