#version 120

#define ExposaUnique

#define VClouds

#define VCloudRes 4.0 //[1.0 2.0 4.0 6.0 8.0 16.0]
/*
const int RGBA16                 = 1;             
const int colortex9Format        =  RGBA16;
const bool colortex9Clear = false;
*/

uniform mat4 gbufferProjection;
uniform mat4 gbufferModelView;
uniform mat4 gbufferProjectionInverse;
uniform mat4 gbufferModelViewInverse;
uniform mat4 gbufferPreviousModelView;
uniform mat4 gbufferPreviousProjection;
uniform mat4 shadowModelView;
uniform mat4 shadowModelViewInverse;
uniform mat4 shadowProjection;
uniform mat4 shadowProjectionInverse;

uniform sampler2D colortex0;
uniform sampler2D colortex7;
uniform sampler2D depthtex0;
uniform sampler2D depthtex1;
uniform sampler2D noisetex;
uniform sampler2D colortex5;
uniform sampler2D colortex6;
uniform sampler2D colortex9;

varying vec4 texcoord;
uniform vec3 cameraPosition;
uniform vec3 previousCameraPosition;

uniform float frameTimeCounter;
uniform int frameCounter;
uniform float viewHeight;
uniform float viewWidth;
uniform float far;
uniform float near;

uniform vec3 sunPosition;

uniform float rainStrength;
uniform float sunAngle;

float bayer2(vec2 a){
    a = floor(a);
    return fract( dot(a, vec2(.5, a.y * .75)) );
}

float getblendfactor(vec2 velo) {
    return exp(-length(velo)) * 0.1 + 0.6;
}

vec3 neighbourhoodClamping(vec3 color, vec3 tempcolor, vec2 view){
	vec3 coltl = texture2D(colortex0,texcoord.st+vec2(-1.0,-1.0)*view,1.0).rgb;
	vec3 coltm = texture2D(colortex0,texcoord.st+vec2( 0.0,-1.0)*view,1.0).rgb;
	vec3 coltr = texture2D(colortex0,texcoord.st+vec2( 1.0,-1.0)*view,1.0).rgb;
	vec3 colml = texture2D(colortex0,texcoord.st+vec2(-1.0, 0.0)*view,1.0).rgb;
	vec3 colmr = texture2D(colortex0,texcoord.st+vec2( 1.0, 0.0)*view,1.0).rgb;
	vec3 colbl = texture2D(colortex0,texcoord.st+vec2(-1.0, 1.0)*view,1.0).rgb;
	vec3 colbm = texture2D(colortex0,texcoord.st+vec2( 0.0, 1.0)*view,1.0).rgb;
	vec3 colbr = texture2D(colortex0,texcoord.st+vec2( 1.0, 1.0)*view,1.0).rgb;
	
	vec3 minclr = min(color,min(min(min(coltl,coltm),min(coltr,colml)),min(min(colmr,colbl),min(colbm,colbr))));
	vec3 maxclr = max(color,max(max(max(coltl,coltm),max(coltr,colml)),max(max(colmr,colbl),max(colbm,colbr))));
	
	return clamp(tempcolor,minclr,maxclr);
}

#define bayer4(a)   (bayer2( .5*(a))*.25+bayer2(a))
#define bayer8(a)   (bayer4( .5*(a))*.25+bayer2(a))
#define bayer16(a)  (bayer8( .5*(a))*.25+bayer2(a))

#define rcp(x) (1.0 / x)

vec2 toPrevScreenPos(vec2 currScreenPos, float depth){
    vec3 currViewPos = vec3(vec2(gbufferProjectionInverse[0].x, gbufferProjectionInverse[1].y) * (currScreenPos.xy * 2.0 - 1.0) + gbufferProjectionInverse[3].xy, gbufferProjectionInverse[3].z);
    currViewPos /= (gbufferProjectionInverse[2].w * (depth * 2.0 - 1.0) + gbufferProjectionInverse[3].w);
    vec3 currFeetPlayerPos = mat3(gbufferModelViewInverse) * currViewPos + gbufferModelViewInverse[3].xyz;

    vec3 prevFeetPlayerPos = depth > 0.56 ? currFeetPlayerPos + cameraPosition - previousCameraPosition : currFeetPlayerPos;
    vec3 prevViewPos = mat3(gbufferPreviousModelView) * prevFeetPlayerPos + gbufferPreviousModelView[3].xyz;
    vec2 finalPos = vec2(gbufferPreviousProjection[0].x, gbufferPreviousProjection[1].y) * prevViewPos.xy + gbufferPreviousProjection[3].xy;
    return (finalPos / -prevViewPos.z) * 0.5 + 0.5;
}

void main() {

    const float cLOD    = sqrt(VCloudRes);
	vec2 prvcoord = toPrevScreenPos(texcoord.st,texture2D(depthtex1,texcoord.st).r);
	vec2 view = vec2(viewWidth,viewHeight);

    #ifdef VClouds
    vec2 cloudcoord = texcoord.st*rcp(cLOD);
    vec4 clouds = texture2D(colortex7, cloudcoord);
	// clouds.rgb /= 1.0 - clouds.rgb * 0.999;
    #endif
    vec4 col = texture2D(colortex0, texcoord.st);
    float depth = texture2D(depthtex0, texcoord.st).x;
    #ifdef VClouds
    if (depth>=1.0) col.rgb = clamp(mix(col.rgb, clouds.rgb, clouds.a),0.0,1.0);
	vec3 tempcolor = neighbourhoodClamping(col.rgb,texture2D(colortex9,texcoord.st).rgb,1.0/view);
	vec2 velocity = (texcoord.st-prvcoord.xy)*view;
	float blendfactor = getblendfactor(velocity);
    if (depth>=1.0) tempcolor = mix(col.rgb,tempcolor,blendfactor);
    #endif

/*DRAWBUFFERS:089*/
    gl_FragData[0] = col;
	#ifdef VClouds
    if (depth>=1.0) gl_FragData[0] = vec4(tempcolor, 1.0);
	gl_FragData[1] = clouds;
    gl_FragData[2] = vec4(tempcolor, 1.0);
	#endif

   
}