#version 120

#define FilmGrain
#define Saturation 1.4 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define Contrast 1.0 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
#define Vibrance 1.4 //[0.1 0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 1.0 1.1 1.2 1.3 1.4 1.5 1.6 1.7 1.8 1.9 2.0]
//#define chromaticaberration 
#define chromaticaberrationstrength 0.005 //[0.001 0.002 0.003 0.004 0.005 0.006 0.007 0.008 0.009 0.01]
#define tonemap 1 //[1 2]
#define LUTS 0 //[0 1 2 3 4 5 6 7 8 9 10]

/*
const int colortex15Format        =  RGBA16;
*/

uniform sampler2D tex;
uniform sampler2D depthtex1;
uniform sampler2D noisetex;
uniform sampler2D colortex3;
uniform sampler2D colortex15;

uniform float viewWidth;
uniform float viewHeight;
uniform float aspectRatio;
uniform float rainStrength;
uniform float frameTimeCounter;

uniform int isEyeInWater;

varying vec2 texcoord;
varying vec4 color;

varying vec3 viewVector;
varying vec3 moonVec;

vec2 ca(vec2 coord) {
    float dist = distance(texcoord, vec2(0.5));
    float cas = chromaticaberrationstrength*dist;
    float r = texture2D(tex,texcoord.xy-vec2(cas,0)).r;
    float b = texture2D(tex,texcoord.xy+vec2(cas,0)).b;
    return vec2(r,b);
}

float luminance(vec3 color) {
    return dot(color, vec3(0.212, 0.7152, 0.722));
}

vec3 getVibrance(vec3 color) {
    float minChannel       = min(min(color.r,color.g),color.b);
    float maxChannel       = max(max(color.r,color.g),color.b);
    float sat      = (1.0 - clamp(maxChannel - minChannel,0.0,1.0)) * (clamp(1.0 - maxChannel,0.0,1.0) * luminance(color)) * 5.0;
    vec3 lightValue = vec3((minChannel + maxChannel) * 0.5);

    return mix(color, mix(lightValue, color, Vibrance), sat); //diz = vibrance
    // return mix(color, lightValue, (1.0 - lightValue) * (1.0 - Vibrance) * 0.5 * Vibrance); // diz = negative vibrance
}

vec3 getSaturate(vec3 scolor){
    float mixrgb = (scolor.r + scolor.g + scolor.b) / 3.5;
    float weight = (Saturation-(0.5*rainStrength)) + (1.0 - pow(1.0 - 1.0 * mixrgb, 2.0)) * 0.08;

    return max(mix(vec3(mixrgb), scolor, weight),1e-5);
}

vec3 getContrast(vec3 scolor) {
    vec3 l = log2(scolor + 1e-4);
    l = (l + 1.0)*Contrast - 1.0;
    return exp2(l)-1e-4;
}

// Originally made by Richard Burgess-Dawson
// Modified by https://github.com/TechDevOnGitHub
vec3 burgess(vec3 color) {
    vec3 maxColor = color * min(vec3(1.0), 1.0 - exp(-1.0 / (luminance(color) * 0.1) * color));
    return (maxColor * (6.2 * maxColor + 0.5)) / (maxColor * (6.2 * maxColor + 1.7) + 0.06);
}

vec3 ACESFilm(vec3 x) //function by https://knarkowicz.wordpress.com/2016/01/06/aces-filmic-tone-mapping-curve/
{
    float a = 2.51;
    float b = 0.03;
    float c = 2.43;
    float d = 0.59;
    float e = 0.14;
    return clamp((x*(a*x+b))/(x*(c*x+d)+e),0.0,1.0);
}

// vec2 refraction(in vec2 coord) {
//         vec2 refraction = vec2(sin(frameTimeCounter * 1.75 * 1.0 + coord.x * 50.0 + coord.y * 25.0), cos(frameTimeCounter * 2.5 * 1.0 + coord.y * 100.0 + coord.x * 25.0));
//         return coord + refraction * 0.002 * 2.0;
//     return coord;
// }
    // const int lutCount     = 19;
    // const int lutTile      = 8;
    // const int lutSize      = lutTile * lutTile;
    // const int lutRes       = lutSize * lutTile;
    // const float invLutTile = 1.0 / lutTile;

    // // LUT grid concept from Raspberry shaders (https://rutherin.netlify.app/)
    // const vec2 invRes = 1.0 / vec2(lutRes, lutRes * lutCount);
    // const mat2 lutGrid = mat2(
    //     vec2(1.0, invRes.y * lutRes),
    //     vec2(0.0, (LUT - 1) * invRes.y * lutRes)
    // );

    // // https://developer.nvidia.com/gpugems/gpugems2/part-iii-high-quality-rendering/chapter-24-using-lookup-tables-accelerate-color
    // void applyLUT(sampler2D lookupTable, inout vec3 color) {
    //     color = clamp(color, vec3(1e-38), vec3(maxVal8 / 256.0));

    //     color.b *= lutSize - 1.0;
    //     int b0 = int(color.b);
    //     int b1 = b0 + 1;

    //     vec2 off0 = vec2(mod(b0, lutTile), b0 / lutTile) * invLutTile;
    //     vec2 off1 = vec2(mod(b1, lutTile), b1 / lutTile) * invLutTile;

    //     color = mix(
    //         texture(lookupTable, (off0 + color.rg * invLutTile) * lutGrid[0] + lutGrid[1]).rgb,
    //         texture(lookupTable, (off1 + color.rg * invLutTile) * lutGrid[0] + lutGrid[1]).rgb,
    //         fract(color.b)
    //     );
    // }
vec3 getLUT(vec3 color, sampler2D LUT) {
    color = clamp(color,1e-5,1.0);
    float amountOfLUTS = 15.; //how many LUTS are stored in the texture
    float LUTile = 8.; //size of a single LUT tile
    float LUTSize = 64.; //size of a single LUT
    vec2 LUTResolution = vec2(512, 512*amountOfLUTS); //width of LUT texture, height of LUT texture
    vec2 LUTResolutionINV = 1.0 / LUTResolution;
    mat2 LUTGrid = mat2(
        vec2(1.0, LUTResolutionINV.y * LUTResolution.x),
        vec2(0.0, (LUTS - 1) * LUTResolutionINV.y * LUTResolution.x)
    );
    float LUTileINV = 1./LUTile;

    // color.b *=LUTileINV;

    vec2 offset = LUTileINV*vec2(int(color.b)/LUTile, int(color.b)/LUTile);
    // color.g -= color.g*0.3;
    // color.r *= 0.9;
    vec3 LUT0 = texture(LUT, vec2(offset+(color.rg*LUTileINV))*LUTGrid[0]+LUTGrid[1]).rgb;
    
    return LUT0;
}

void main() {
    vec2 fragcoord = gl_FragCoord.xy;
    vec2 coord = texcoord;
    // int id = int(texelFetch(colortex3, ivec2(gl_FragCoord.xy),0).b*65535.);
    // bool iswaterm = id == 8 || id == 9;
        // fragcoord = refraction(fragcoord);
        // coord = refraction(coord);
    vec4 scolor = texelFetch(tex, ivec2(fragcoord.xy),0) * color;

    float depth = texelFetch(depthtex1, ivec2(fragcoord.xy),0).x;

    scolor.rgb = getSaturate(scolor.rgb);
    scolor.rgb = getContrast(scolor.rgb);
    scolor.rgb = getVibrance(scolor.rgb);
    #ifdef chromaticaberration
    scolor.rb = ca(coord);
    #endif
    #if tonemap == 2
    scolor.rgb = burgess(scolor.rgb);
    #elif tonemap == 1
    scolor.rgb = ACESFilm(scolor.rgb);
    #endif
    scolor.rgb = pow(scolor.rgb, vec3(1.0 / 2.2));

    #if LUTS > 0
    scolor.rgb = getLUT(scolor.rgb, colortex15);
    #endif

/*DRAWBUFFERS:0*/
    gl_FragColor = scolor;

}

