#version 120

#define TAA
#define FoliageMovement 0.1 //[0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.2 0.3 0.4 0.5]

uniform float rainStrength;
uniform float frameTimeCounter;

uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;

uniform vec3 cameraPosition;

varying vec2 lmcoord;
varying vec2 texcoord;
varying vec4 color;

flat out vec3 normal;
varying vec3 viewVector;

flat out mat3 tbn;

uniform int frameCounter;

uniform float viewWidth;
uniform float viewHeight;

attribute vec4 at_tangent;
attribute vec4 mc_Entity;

flat out float id;

vec2 jitter[8] = vec2[8](vec2( 0.125,-0.375),
							   vec2(-0.125, 0.375),
							   vec2( 0.625, 0.125),
							   vec2( 0.375,-0.625),
							   vec2(-0.625, 0.625),
							   vec2(-0.875,-0.125),
							   vec2( 0.375,-0.875),
							   vec2( 0.875, 0.875));
				

vec2 taaJitter(vec2 coord, float w){
	return jitter[int(mod(frameCounter,8.0))]*(w/vec2(viewWidth,viewHeight)) + coord;
}

void main() {
    vec4 pos = gl_Vertex;
    float fast =  (FoliageMovement/4.);
    float fastsinx = sin((frameTimeCounter*1.0) + (cameraPosition.y+pos.y));
    float fastsiny = sin((frameTimeCounter*1.0) + (cameraPosition.z+pos.z));
    float fastsinz = sin((frameTimeCounter*1.0) + (cameraPosition.x+pos.x));

    float medium = (FoliageMovement/2.);
    float mediumsinx = sin((frameTimeCounter*0.5) + (cameraPosition.y+pos.y)+0.12);
    float mediumsiny = sin((frameTimeCounter*0.5) + (cameraPosition.z+pos.z)+0.12);
    float mediumsinz = sin((frameTimeCounter*0.5) + (cameraPosition.x+pos.x)+0.12);

    float slow = FoliageMovement;
    float slowsinx = sin((frameTimeCounter*0.25) + (cameraPosition.y+pos.y)+0.01);
    float slowsiny = sin((frameTimeCounter*0.25) + (cameraPosition.z+pos.z)+0.01);
    float slowsinz = sin((frameTimeCounter*0.25) + (cameraPosition.x+pos.x)+0.01);

	if(mc_Entity.x == 161.0 || mc_Entity.x == 18.0 || mc_Entity.x == 175.0 || mc_Entity.x == 32.0 || mc_Entity.x == 31.0 || mc_Entity.x == 8.0 || mc_Entity.x == 9.0) {
		pos.x += (fast*fastsinx)+(medium*mediumsinx)+(slow*slowsinx);
		pos.y += (fast*fastsiny)+(medium*mediumsiny)+(slow*slowsiny);
		pos.z += (fast*fastsinz)+(medium*mediumsinz)+(slow*slowsinz);

	}
    gl_Position = gl_ProjectionMatrix * (gl_ModelViewMatrix * pos);
    #ifdef TAA
    gl_Position.xy = taaJitter(gl_Position.xy, gl_Position.w);
    #endif
    
    texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).xy;

    lmcoord = (gl_TextureMatrix[1] * gl_MultiTexCoord1).xy;
    
    color = gl_Color;

    normal 	= normalize(gl_NormalMatrix*gl_Normal);
        vec3 tangent = normalize(gl_NormalMatrix*at_tangent.xyz);
        vec3 binormal = normalize(gl_NormalMatrix*cross(at_tangent.xyz, gl_Normal.xyz) * at_tangent.w);

        tbn     = mat3(tangent.x, binormal.x, normal.x,
                    tangent.y, binormal.y, normal.y,
                    tangent.z, binormal.z, normal.z);
    id = mc_Entity.x;

	viewVector = tbn*normalize(gl_ModelViewMatrix * gl_Vertex).xyz;

}