#version 130

#define bumpness 0.45 //[0.05 0.1 0.15 0.2 0.25 0.3 0.35 0.4 0.45 0.5 0.55 0.6 0.7 0.8 0.9 1.0]
#define waterAlpha 0.2 //[0.2 0.3 0.4 0.5 0.6 0.7 0.8 0.9 0.95]
#define WatercolorR 0.1 //[0.1 0.2 0.3 0.4 0.5]
#define WatercolorG 0.4 //[0.1 0.2 0.3 0.4 0.5]
#define WatercolorB 0.5 //[0.1 0.2 0.3 0.4 0.5]

const float PI = 3.1415927;
const float noiseTextureResolution = 16000;

varying vec4 color;
varying vec2 texcoord;
varying vec2 lmcoord;
varying vec3 binormal;
varying vec3 normal;
varying vec3 tangent;
varying vec3 wpos;
varying float iswater;

flat in float id;

uniform sampler2D texture;
uniform sampler2D noisetex;
uniform int worldTime;
uniform float far;
uniform float rainStrength;
uniform float frameTimeCounter;
uniform vec3 cameraPosition;

float noise2De(in vec2 coord, in float size, in vec2 offset) {
    coord      *= size;
    coord      += offset;
    coord      /= noiseTextureResolution;
    return texture(noisetex, coord).r*2.0-1.0;
}
float noise3D(in vec3 pos, in float size, in vec3 offset) {
    pos            *= size;
    pos            += offset;
    vec3 i          = floor(pos);
    vec3 f          = fract(pos);

    vec2 p1         = (i.xy+i.z*vec2(17.0)+f.xy);
    vec2 p2         = (i.xy+(i.z+1.f)*vec2(17.0))+f.xy;
    vec2 c1         = (p1+1.5)/noiseTextureResolution;
    vec2 c2         = (p2+1.5)/noiseTextureResolution;
    float r1        = texture(noisetex, c1).r;
    float r2        = texture(noisetex, c2).r;
    return mix(r1, r2, f.z)*2.0-1.0;
}

float waterH(vec3 wpos) {
    float windAnim = -frameTimeCounter*0.2;
    vec3 tick = vec3(windAnim);
    float noise = noise3D(wpos, 0.1, tick);
    return noise*0.25;
}

mat2 Rot(float a) {
    float s = sin(a), c=cos(a);
    return mat2(c, -s, s, c);
}

vec3 GerstnerWave(vec2 coord, float wavelength, float steepness, vec2 direction) //water waves by tech, modified by me
{
    
    vec3 gerstner = vec3(0.0);
    float k = 2.0 * PI / wavelength;
    float c = sqrt(9.81 / k); //earth's gravitational constant
    float a = steepness / k;
    vec2 dir = normalize(direction);
    float f = k * (dot(dir, coord.xy) - c * frameTimeCounter*5.);
    
    gerstner.x += dir.x * (a * cos(f));
    gerstner.y = a * sin(f);
    gerstner.z += dir.y * (a * cos(f));
    
    return min(gerstner,0.0);
}

// float fake3D(in vec2 coord, in float size) {
//     coord *= size;
//     vec3 i          = floor(vec3(coord, 0.0));
//     vec3 f          = fract(vec3(coord, 0.0));

//     vec2 p1         = (i.xy+i.z*vec2(20.0)+f.xy);
//     vec2 p2         = (i.xy+(i.z+1.f)*vec2(20.0))+f.xy;
//     vec2 c1         = (p1+0.5)/noiseTextureResolution;
//     vec2 c2         = (p2+0.5)/noiseTextureResolution;
//     float r1        = texture2D(noisetex, c1).r;
//     float r2        = texture2D(noisetex, c2).r;
//     return mix(r1, r2, f.z)*2.0-1.0;

// }
// const vec2[5] worleyPointPositions = vec2[5] (
//     vec2(0.18,0.25),
//     vec2(0.45,0.347),
//     vec2(0.17,0.2345),
//     vec2(0.142,0.98),
//     vec2(0.871,0.54)
// );
vec2 Rand2(vec2 p) {
    return fract(sin(vec2(dot(p, vec2(25.6, 35.7)), dot(p, vec2(16.2, 95.5))))*.005);
}
float worleyNoise(vec3 p) {
    p *= 0.05;
    p.z *= 0.25;
    float minDist = 1.0;
    // float noise = waterH(p);
    float divider = 0.9;
    float adder = 0.1;
    for(int i = 0; i < 5; i++) {
                vec2 offsetedPosition = p.xz + normalize(Rot(float(i)*55.)*vec2(1.0, -1.0));
                offsetedPosition += adder;
                vec2 random = Rand2(offsetedPosition/divider);
                random = sin(6.28*random)*0.5+0.5;
                minDist = min(minDist, length(random));
                p += minDist*.2;
                divider *= 0.8;
                adder *= 5.5;
    }
    return minDist*2.;
}

// float ComputeWaterHeight(vec3 p) 
// {
//     float height;
//     vec2 direction = normalize(vec2(1.0, -1.0));
//     p *= 120.0;
    
//     int iterations = 16;
//     float amplitude = 0.1;
//     float frequency = 0.04;
// 	float noise = waterH(p/120.);
// 	float wavelength = 20.0/frequency;
// 	wavelength *= 1.0 + noise * 0.018;
    
//     for (int i = 0; i < iterations; i++) 
//     {
//         vec2 newDir = normalize(Rot(float(i) * 8.5) * direction);
//         vec3 gerstner = GerstnerWave(p.xz, wavelength, amplitude, newDir);
//         height += gerstner.y+noise;
//         p -= gerstner * .2;
//         amplitude *= 0.86;
//         wavelength *= 0.75;
//         frequency *= 3.56;
//     }
    
//     return height * 0.0001;
// }

// float pNoise(vec2 p){
// 	float persistance = .7;
// 	float n = 0.0;
// 	float normK = 0.0;
// 	float f = 0.4;
// 	float amp = 1.;
// 	for (int i = 0; i<12; i++){
// 		n+=amp*fake3D(p, f);
// 		f*=1.9;
// 		normK+=amp;
// 		amp*=persistance;
// 	}
// 	float nf = n/normK;
// 	return nf * 0.5;
// }

void main() {	
	vec4 tex = vec4(vec3(WatercolorR,WatercolorG,WatercolorB)*0.1, waterAlpha);
	if (iswater<0.9) tex = texture2D(texture, texcoord)*color;
	
	vec3 posxz = wpos.xyz;

	posxz.x += sin(posxz.x+frameTimeCounter)*0.25;
	posxz.z += cos(posxz.z+frameTimeCounter)*0.25;
	
	float dist = 4e-3;
    vec3 p1 = posxz + vec3(dist, 0., -dist);
    vec3 p2 = posxz + vec3(-dist, 0., dist);
    vec3 p3 = posxz + vec3(-dist, 0., -dist); 
    float h1 = worleyNoise(p1);
    float h2 = worleyNoise(p2);
    float h3 = worleyNoise(p3);
    vec3 newnormal = normalize(cross(vec3(p2.xz - p1.xz, h2 - h1), vec3(p3.xz - p1.xz, h3 - h1)));
    // newnormal = normalize(cross(dFdx(vec3(h1,h2,h3)), dFdy(vec3(h1,h2,h3))));
			
	newnormal = newnormal * vec3(bumpness, bumpness, bumpness) + vec3(0.0, 0.0, 1.0 - bumpness);
	mat3 tbnMatrix = mat3(tangent.x, binormal.x, normal.x,
						tangent.y, binormal.y, normal.y,
						tangent.z, binormal.z, normal.z);
		
	vec4 frag2 = vec4(normalize(newnormal * tbnMatrix) * 0.5 + 0.5, 1.0);

/*DRAWBUFFERS:013*/
	gl_FragData[0] = tex;
	gl_FragData[1] = frag2;	
    gl_FragData[2] = vec4(vec2(normal), id/65535, 1.0);
}