#version 120
#define FoliageMovement 0.1 //[0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.1 0.2 0.3 0.4 0.5]

varying vec4 color;
varying vec2 texcoord;
varying vec2 lmcoord;
varying vec3 binormal;
varying vec3 normal;
varying vec3 tangent;
varying vec3 wpos;
varying float iswater;

flat out float id;

attribute vec4 mc_Entity;
attribute vec4 at_tangent;

uniform vec3 cameraPosition;
uniform mat4 gbufferModelView;
uniform mat4 gbufferModelViewInverse;
uniform int worldTime;
uniform float frameTimeCounter;
uniform float rainStrength;
uniform int isEyeInWater;

void main() {
	
	//vec4 viewpos = gl_ModelViewMatrix * gl_Vertex;
	vec4 position = gl_ModelViewMatrix * gl_Vertex;
	iswater = 0.0f;

	vec4 viewpos = gbufferModelViewInverse * position;

	wpos = viewpos.xyz + cameraPosition;

    vec4 pos = gl_Vertex;
    float fast =  (FoliageMovement/4.);
    float fastsiny = sin((frameTimeCounter*1.0) + (cameraPosition.z+pos.z));

    float medium = (FoliageMovement/2.);
    float mediumsiny = sin((frameTimeCounter*0.5) + (cameraPosition.z+pos.z)+0.12);

    float slow = FoliageMovement;
    float slowsiny = sin((frameTimeCounter*0.25) + (cameraPosition.z+pos.z)+0.01);
	
	if(mc_Entity.x == 8.0 || mc_Entity.x == 9.0) {
		iswater = 1.0;
		// pos.x += (fast*fastsinx)+(medium*mediumsinx)+(slow*slowsinx);
		pos.y += (fast*fastsiny)+(medium*mediumsiny)+(slow*slowsiny);
		// pos.z += (fast*fastsinz)+(medium*mediumsinz)+(slow*slowsinz);
	}

    gl_Position = gl_ProjectionMatrix * (gl_ModelViewMatrix * pos);
	
	color = gl_Color;
	
	texcoord = (gl_TextureMatrix[0] * gl_MultiTexCoord0).st;

	lmcoord = (gl_TextureMatrix[1] * gl_MultiTexCoord1).st;
	
	gl_FogFragCoord = gl_Position.z;
	
	tangent = normalize(gl_NormalMatrix * at_tangent.xyz);
	binormal = normalize(gl_NormalMatrix * cross(at_tangent.xyz, gl_Normal.xyz) * at_tangent.w);
	normal = normalize(gl_NormalMatrix * gl_Normal);

	id = mc_Entity.x;
	

}