uvec4 tex1 = texelFetch(colortex1, ivec2(gl_FragCoord.xy),0);

vec2 clampNormal(const vec3 n, const vec3 v) { //get encoded normals
    float NoV = clamp(dot(n, -v), 0.0, 1.0);
    return normalize(NoV * v + n).xy;
}

vec2 getnormalmaps(uvec4 sampledtex1) { //get water normals and normal maps
    return unpackSnorm2x16(sampledtex1.y);
}

vec2 getnormals(uvec4 sampledtex1) { //get vertex normals
    return unpackUnorm4x8(sampledtex1.x).xy;
}

vec3 normalsandz(vec2 clampednormals) { //get decoded normals
    float normalz = sqrt(1.0 - dot(clampednormals.xy, clampednormals.xy));
    return vec3(clampednormals,normalz);
}

vec2 getlightmapcoords(uvec4 sampledtex1) { //get the lightmaps
    return unpackUnorm4x8(sampledtex1.x).zw;
}

vec4 getpbrdata(uvec4 sampledtex1) { //get specular data used for reflections and GGX
    vec4 speculardata = unpackUnorm4x8(sampledtex1.w);
    speculardata.r = 1.0 - speculardata.r;
    return speculardata;
}