vec3 getCameraSpacePos(in vec2 coord, in float depth) {
    vec3 screenspace = vec3(coord,depth)*2.0-1.0;

        return (screenspace*vec3(gbufferProjectionInverse[0].x, gbufferProjectionInverse[1].y, gbufferProjectionInverse[2].z) + gbufferProjectionInverse[3].xyz) / (screenspace.z * gbufferProjectionInverse[2].w + gbufferProjectionInverse[3].w);
}

vec3 getWorldSpacePos(in vec2 coord, in float depth) {
    vec3 WorldSpacePos = mat3(gbufferModelViewInverse)*getCameraSpacePos(coord, depth)+gbufferModelViewInverse[3].xyz;

    return WorldSpacePos + cameraPosition;
}

#define SHADOW_MAP_BIAS 0.85

vec3 normalss = texelFetch(colortex10, ivec2(gl_FragCoord.xy),0).rgb*2.0-1.0;
//float bias = SHADOW_MAP_BIAS - (clamp(dot(normalize(sunPosition), normalss),0.0,1.0));

vec2 getMultipliedShadowPos(in vec2 pos) {
    return pos*abs(pos)*1.357225;
}

vec3 getShadowSpacePos(in vec2 coord, in float depth, vec3 lightvec, float offset) {
    vec3 WorldSpacePos = getWorldSpacePos(coord, depth);

    WorldSpacePos -= cameraPosition;
    WorldSpacePos += mat3(gbufferModelViewInverse)*normalize(lightvec)*offset;
    vec3 ShadowSpacePos = mat3(shadowProjection)*(mat3(shadowModelView) * WorldSpacePos+shadowModelView[3].xyz)+shadowProjection[3].xyz;
    vec2 multipliedShadowPos = getMultipliedShadowPos(ShadowSpacePos.xy);
    float dist = pow(multipliedShadowPos.x*multipliedShadowPos.x + multipliedShadowPos.y*multipliedShadowPos.y, 1.0/4.0);
    float distFac = (1.0 - SHADOW_MAP_BIAS) + dist * SHADOW_MAP_BIAS;
    ShadowSpacePos.xy /= distFac*0.92;
    ShadowSpacePos.z *= 0.2;  
    return ShadowSpacePos.xyz * 0.5 + 0.5;
}
