

#define sstep(x, low, high) smoothstep(low, high, x)

float noise3D(in vec3 pos, in float size, in vec3 offset) {
    pos            *= size;
    pos            += offset;
    vec3 i          = floor(pos);
    vec3 f          = fract(pos);

    vec2 p1         = (i.xy+i.z*vec2(17.0)+f.xy);
    vec2 p2         = (i.xy+(i.z+1.f)*vec2(17.0))+f.xy;
    vec2 c1         = (p1+1.5)/noiseTextureResolution;
    vec2 c2         = (p2+1.5)/noiseTextureResolution;
    float r1        = texture2D(noisetex, c1).r;
    float r2        = texture2D(noisetex, c2).r;
    return mix(r1, r2, f.z)*2.0-1.0;
}

float opNoise2D(in vec3 coord, in float size, in vec3 offset) {
    coord      *= size;
    coord      += offset;
    coord      /= noiseTextureResolution;
    return texture2D(noisetex, coord.xz).x*2.0-1.0;
}

float cubeSmooth(float x) {
    return (x*x) * (3.0-2.0*x);
}

float density = 0.8;

float getNoiseQuality(in vec3 pos, in float size, in vec3 wind) {
    float noise = opNoise2D(pos, size, wind);
    noise -= noise3D(pos*4.0, size, wind)*0.4;
    noise -= noise3D(pos*6.0, size*1.5, wind)*0.2;
    noise -= noise3D(pos*8.0, size*3.0, wind)*0.1;
    noise -= noise3D(pos*8.0, size*3.0, wind)*0.05;
    noise -= noise3D(pos*8.0, size*3.0, wind)*0.025;
    return noise;
}

#define vCoverage 0.15 //[0.01 0.02 0.03 0.04 0.05 0.06 0.07 0.08 0.09 0.10 0.11 0.12 0.13 0.14 0.15 0.16 0.17 0.18 0.19 0.20 0.21 0.22 0.23 0.24 0.25 0.30 0.45 0.50 0.55 0.60]

float volumeShape(in vec3 pos) {
    float tick = frameTimeCounter;
    vec3 wind = vec3(tick)*0.09;

    float size = 0.004;

    float hfade     = 1.0-sstep(pos.y, VAltitude+Vthickness*0.4, VAltitude+Vthickness);
    float lfade     = sstep(pos.y, VAltitude, VAltitude+Vthickness*0.4);

    float noise = getNoiseQuality(pos, size, wind);
    noise -= (vCoverage + -0.7*rainStrength);

    noise   = max(noise, 0.0);  //we don't want negative noise values
    noise   = cubeSmooth(noise);
    noise  *= hfade*lfade;          //apply fading

    return max(noise*density, 0.0)*0.8;
}